/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections;

import com.ibm.ws.repository.common.enums.ReadMode;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.internal.AbstractRepositoryConnection;
import com.ibm.ws.repository.transport.client.DirectoryClient;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import java.io.File;

public class DirectoryRepositoryConnection
extends AbstractRepositoryConnection
implements RepositoryConnection {
    private final File _root;
    private final ReadMode _readMode;
    private DirectoryClient client;

    @Deprecated
    public DirectoryRepositoryConnection(File root) {
        this(root, ReadMode.DETECT_CHANGES);
    }

    public DirectoryRepositoryConnection(File root, ReadMode readMode) {
        this._root = root;
        this._readMode = readMode;
    }

    public File getRoot() {
        return this._root;
    }

    @Override
    public String getRepositoryLocation() {
        return this._root.getAbsolutePath();
    }

    @Override
    public synchronized RepositoryReadableClient createClient() {
        if (this.client == null) {
            this.client = new DirectoryClient(this.getRoot(), this._readMode);
        }
        return this.client;
    }
}

