/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IThreadRootController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.JobListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ListenerFactory;
import com.ibm.jbatch.container.controller.impl.ExecutionTransitioner;
import com.ibm.jbatch.container.execution.impl.RuntimeJobExecution;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.jsl.ModelSerializer;
import com.ibm.jbatch.container.jsl.ModelSerializerFactory;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.api.listener.JobListener;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.runtime.BatchStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class WorkUnitThreadControllerImpl
implements IThreadRootController {
    private static final String CLASSNAME = WorkUnitThreadControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private final RuntimeWorkUnitExecution runtimeWorkUnitExecution;
    private ListenerFactory listenerFactory;
    private ExecutionTransitioner transitioner;
    private final ModelNavigator<JSLJob> jobNavigator;
    private PartitionReplyQueue partitionReplyQueue;
    private ControllerHelper threadTypeBasedControllerHelper;
    boolean listenersCalled;
    static final long serialVersionUID = -8871593879502100585L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WorkUnitThreadControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution});
        }
        this.listenerFactory = null;
        this.threadTypeBasedControllerHelper = null;
        this.listenersCalled = false;
        this.runtimeWorkUnitExecution = runtimeWorkUnitExecution;
        this.threadTypeBasedControllerHelper = new ThreadTypeBasedHelperFactory().createControllerHelper();
        this.jobNavigator = runtimeWorkUnitExecution.getJobNavigator();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WorkUnitThreadControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution, PartitionReplyQueue partitionReplyQueue) {
        this(runtimeWorkUnitExecution);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution, partitionReplyQueue});
        }
        this.partitionReplyQueue = partitionReplyQueue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus runExecutionOnThread() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "runExecutionOnThread", new Object[0]);
        }
        ExecutionStatus executionStatus = this.threadTypeBasedControllerHelper.runExecutionOnThread();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "runExecutionOnThread", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ExecutionStatus executeCoreTransitionLoop() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "executeCoreTransitionLoop", new Object[0]);
        }
        ExecutionStatus retVal = this.transitioner.doExecutionLoop();
        ExtendedBatchStatus extBatchStatus = retVal.getExtendedBatchStatus();
        switch (extBatchStatus) {
            case JSL_STOP: {
                this.jslStop();
                break;
            }
            case JSL_FAIL: {
                this.updateJobBatchStatus(BatchStatus.FAILED);
                break;
            }
            case EXCEPTION_THROWN: {
                this.updateJobBatchStatus(BatchStatus.FAILED);
                break;
            }
        }
        ExecutionStatus executionStatus = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "executeCoreTransitionLoop", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean startWorkUnitIfNotStopping() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "startWorkUnitIfNotStopping", new Object[0]);
        }
        BatchStatus batchStatus = this.runtimeWorkUnitExecution.getBatchStatus();
        if (batchStatus.equals((Object)BatchStatus.STARTING)) {
            this.markWorkStarted();
            if (!(this.runtimeWorkUnitExecution instanceof RuntimePartitionExecution)) {
                JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "job.started", new Object[]{this.runtimeWorkUnitExecution.getTopLevelJobName(), this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getTopLevelExecutionId()}, logger);
                if (!(this.runtimeWorkUnitExecution instanceof RuntimeSplitFlowExecution)) {
                    JobInstanceEntity instanceEntity = this.getPersistenceManagerService().getJobInstance(this.runtimeWorkUnitExecution.getTopLevelInstanceId());
                    String jsl = instanceEntity.getJobXml();
                    JoblogUtil.logToJobLogAndTraceOnly(Level.INFO, "display.unresolved.jsl", new Object[]{jsl}, logger);
                }
                JSLJob jslJob = this.jobNavigator.getRootModelElement();
                ModelSerializer<JSLJob> ms = ModelSerializerFactory.createJobModelSerializer();
                String prettyXml = ms.prettySerializeModel(jslJob);
                String type = "job";
                if (this.runtimeWorkUnitExecution instanceof RuntimeSplitFlowExecution) {
                    type = "flow";
                }
                JoblogUtil.logToJobLogAndTraceOnly(Level.INFO, "display.resolved.jsl", new Object[]{type, prettyXml}, logger);
            }
            this.listenersCalled = true;
            this.jobListenersBeforeJob();
            this.transitioner = new ExecutionTransitioner(this.runtimeWorkUnitExecution, this.jobNavigator, this.partitionReplyQueue);
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "startWorkUnitIfNotStopping", bl);
            }
            return bl;
        }
        logger.fine("Won't start work unit because status is currently : " + batchStatus);
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "startWorkUnitIfNotStopping", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus executeWorkUnit() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "executeWorkUnit", new Object[0]);
        }
        ExecutionStatus retVal = null;
        boolean workStarted = false;
        this.setupListeners();
        try {
            RuntimeWorkUnitExecution.StopLock stopLock2;
            stopLock = stopLock2 = this.getStopLock();
            synchronized (stopLock) {
                workStarted = this.startWorkUnitIfNotStopping();
            }
            if (workStarted) {
                retVal = this.executeCoreTransitionLoop();
            }
        }
        catch (Throwable stopLock2) {
            void t;
            FFDCFilter.processException((Throwable)stopLock2, (String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", (String)"181", (Object)this, (Object[])new Object[0]);
            this.threadTypeBasedControllerHelper.batchStatusFailedFromException();
            if (this.runtimeWorkUnitExecution instanceof RuntimeJobExecution) {
                JoblogUtil.logToJobLogAndTraceOnly(Level.SEVERE, "exception.executing.job", new Object[]{this.getExceptionString((Throwable)t)}, logger);
                JoblogUtil.logToJobLogAndTrace(Level.WARNING, "job.failed", new Object[]{this.runtimeWorkUnitExecution.getTopLevelJobName(), this.runtimeWorkUnitExecution.getBatchStatus(), this.runtimeWorkUnitExecution.getExitStatus(), this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getTopLevelExecutionId()}, logger);
            }
            JoblogUtil.logRawMsgToJobLogAndTraceOnly(Level.SEVERE, this.getExceptionString((Throwable)t), logger);
        }
        stopLock = stopLock2 = this.getStopLock();
        synchronized (stopLock) {
            this.endOfWorkUnit(this.listenersCalled);
            if (!(this.runtimeWorkUnitExecution instanceof RuntimePartitionExecution)) {
                Object[] params = new Object[]{this.runtimeWorkUnitExecution.getTopLevelJobName(), this.runtimeWorkUnitExecution.getBatchStatus(), this.runtimeWorkUnitExecution.getExitStatus(), this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getTopLevelExecutionId()};
                if (this.runtimeWorkUnitExecution.getBatchStatus() == BatchStatus.FAILED) {
                    JoblogUtil.logToJobLogAndTrace(Level.WARNING, "job.failed", params, logger);
                } else {
                    JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "job.ended", params, logger);
                }
            }
        }
        ExecutionStatus executionStatus = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "executeWorkUnit", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void jslStop() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "jslStop", new Object[0]);
        }
        this.threadTypeBasedControllerHelper.jslStop();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "jslStop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void markWorkStarted() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "markWorkStarted", new Object[0]);
        }
        this.runtimeWorkUnitExecution.workStarted(new Date());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "markWorkStarted");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void endOfWorkUnit(boolean callAfterJobListeners) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "endOfWorkUnit", new Object[]{callAfterJobListeners});
        }
        if (callAfterJobListeners) {
            try {
                this.jobListenersAfterJob();
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", (String)"260", (Object)this, (Object[])new Object[]{callAfterJobListeners});
                if (this.runtimeWorkUnitExecution instanceof RuntimeJobExecution) {
                    JoblogUtil.logToJobLogAndTraceOnly(Level.SEVERE, "exception.after.job", new Object[]{this.getExceptionString((Throwable)t)}, logger);
                } else {
                    JoblogUtil.logRawMsgToJobLogAndTraceOnly(Level.SEVERE, this.getExceptionString((Throwable)t), logger);
                }
                this.threadTypeBasedControllerHelper.batchStatusFailedFromException();
            }
        }
        this.transitionToFinalBatchStatus();
        if (this.runtimeWorkUnitExecution.getExitStatus() == null) {
            logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.runtimeWorkUnitExecution.getBatchStatus());
            this.runtimeWorkUnitExecution.setExitStatus(this.runtimeWorkUnitExecution.getBatchStatus().name());
        }
        this.persistWorkUnitBatchAndExitStatus();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "endOfWorkUnit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void persistWorkUnitBatchAndExitStatus() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "persistWorkUnitBatchAndExitStatus", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            String errorMsg;
            boolean reachedAnExpectedTerminatingStatus;
            block13: {
                BatchStatus batchStatus = this.runtimeWorkUnitExecution.getBatchStatus();
                reachedAnExpectedTerminatingStatus = false;
                errorMsg = null;
                if (batchStatus.equals((Object)BatchStatus.COMPLETED) || batchStatus.equals((Object)BatchStatus.STOPPED) || batchStatus.equals((Object)BatchStatus.FAILED)) {
                    reachedAnExpectedTerminatingStatus = true;
                } else {
                    errorMsg = "Not expected to encounter batchStatus of " + batchStatus + " at this point.";
                    this.runtimeWorkUnitExecution.setBatchStatus(BatchStatus.FAILED);
                }
                try {
                    this.runtimeWorkUnitExecution.workEnded(new Date());
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", (String)"321", (Object)this, (Object[])new Object[0]);
                    try {
                        this.runtimeWorkUnitExecution.setBatchStatus(BatchStatus.FAILED);
                        this.runtimeWorkUnitExecution.workEnded(new Date());
                    }
                    catch (Throwable throwable2) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", (String)"328", (Object)this, (Object[])new Object[0]);
                        if (this.runtimeWorkUnitExecution instanceof RuntimeJobExecution) {
                            JoblogUtil.logToJobLogAndTrace(Level.SEVERE, "error.persisting.jobExecution", new Object[]{this.getExceptionString((Throwable)t)}, logger);
                            break block13;
                        }
                        JoblogUtil.logRawMsgToJobLogAndTraceOnly(Level.SEVERE, this.getExceptionString((Throwable)t), logger);
                    }
                }
            }
            if (!reachedAnExpectedTerminatingStatus) {
                logger.fine(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "persistWorkUnitBatchAndExitStatus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void transitionToFinalBatchStatus() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "transitionToFinalBatchStatus", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            BatchStatus currentBatchStatus = this.runtimeWorkUnitExecution.getBatchStatus();
            if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
                this.updateJobBatchStatus(BatchStatus.COMPLETED);
            } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(BatchStatus.STOPPED);
            } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
                this.updateJobBatchStatus(BatchStatus.FAILED);
            } else {
                throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "transitionToFinalBatchStatus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void updateJobBatchStatus(BatchStatus batchStatus) {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "updateJobBatchStatus", new Object[]{batchStatus});
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            this.runtimeWorkUnitExecution.setBatchStatus(batchStatus);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "updateJobBatchStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void batchStatusStopping() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "batchStatusStopping", new Object[0]);
        }
        this.runtimeWorkUnitExecution.workStopping(new Date());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "batchStatusStopping");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setupListeners() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "setupListeners", new Object[0]);
        }
        JSLJob jobModel = this.runtimeWorkUnitExecution.getJobNavigator().getRootModelElement();
        InjectionReferences injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), null, null);
        this.listenerFactory = new ListenerFactory(jobModel, injectionRef);
        this.runtimeWorkUnitExecution.setListenerFactory(this.listenerFactory);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "setupListeners");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected RuntimeWorkUnitExecution.StopLock getStopLock() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getStopLock", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock = this.runtimeWorkUnitExecution.getStopLock();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stopLock = stopLock;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getStopLock", stopLock);
        }
        return stopLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "stop", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            BatchStatus batchStatus = this.runtimeWorkUnitExecution.getBatchStatus();
            switch (batchStatus) {
                case STARTING: 
                case STARTED: {
                    IController stoppableElementController;
                    this.batchStatusStopping();
                    if (this.transitioner == null || (stoppableElementController = this.transitioner.getCurrentStoppableElementController()) == null) break;
                    stoppableElementController.stop();
                    break;
                }
                case ABANDONED: 
                case COMPLETED: 
                case FAILED: 
                case STOPPED: {
                    logger.fine("Stop unsuccessful since batch status for job is already set to: " + batchStatus);
                    throw new JobExecutionNotRunningException();
                }
                default: {
                    logger.fine("Stop ignored since batch status for job is already set to: " + batchStatus);
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void jobListenersBeforeJob() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "jobListenersBeforeJob", new Object[0]);
        }
        List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
        for (JobListenerProxy listenerProxy : jobListeners) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Invoking beforeJob() on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
            }
            listenerProxy.beforeJob();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "jobListenersBeforeJob");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void jobListenersAfterJob() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "jobListenersAfterJob", new Object[0]);
        }
        List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
        for (JobListenerProxy listenerProxy : jobListeners) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Invoking afterJob() on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
            }
            listenerProxy.afterJob();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "jobListenersAfterJob");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getLastRunStepExecutions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getLastRunStepExecutions", new Object[0]);
        }
        List<Long> list = this.transitioner.getStepExecIds();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getLastRunStepExecutions", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getExceptionString(Throwable t) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getExceptionString", new Object[]{t});
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String string = sw.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl", "getExceptionString", string);
        }
        return string;
    }

    private static interface ControllerHelper {
        public void jslStop();

        public ExecutionStatus runExecutionOnThread();

        public void batchStatusFailedFromException();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ThreadTypeBasedHelperFactory {
        static final long serialVersionUID = 2493450129492089871L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ThreadTypeBasedHelperFactory() {
        }

        private ControllerHelper createControllerHelper() {
            if (WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution instanceof RuntimeSplitFlowExecution) {
                return new SplitFlowControllerHelper();
            }
            if (WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution instanceof RuntimePartitionExecution) {
                return new PartitionControllerHelper();
            }
            return new JobControllerHelper();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl$ThreadTypeBasedHelperFactory", ThreadTypeBasedHelperFactory.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class SplitFlowControllerHelper
    extends AbstractControllerHelper {
        RuntimeSplitFlowExecution flowInSplitExecution;
        static final long serialVersionUID = -2187995027100449688L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SplitFlowControllerHelper() {
            this.flowInSplitExecution = (RuntimeSplitFlowExecution)WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution;
        }

        @Override
        public void jslStop() {
            throw new IllegalStateException("Don't support stopping within flow.");
        }

        @Override
        public ExecutionStatus runExecutionOnThread() {
            ExecutionStatus status = super.runExecutionOnThread();
            this.flowInSplitExecution.setFlowStatus(status);
            return status;
        }

        @Override
        public void batchStatusFailedFromException() {
            super.batchStatusFailedFromException();
            this.flowInSplitExecution.getFlowStatus().setExtendedBatchStatus(ExtendedBatchStatus.EXCEPTION_THROWN);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl$SplitFlowControllerHelper", SplitFlowControllerHelper.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class PartitionControllerHelper
    extends AbstractControllerHelper {
        static final long serialVersionUID = -8533998721266368045L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PartitionControllerHelper() {
        }

        @Override
        public void jslStop() {
            throw new IllegalStateException("Don't support stopping from within a partition \"subjob\".");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl$PartitionControllerHelper", PartitionControllerHelper.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobControllerHelper
    extends AbstractControllerHelper {
        static final long serialVersionUID = 8525135872123200390L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobControllerHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void jslStop() {
            RuntimeWorkUnitExecution.StopLock stopLock;
            String restartOn = WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution.getRestartOnForNextExecution();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Logging JSL stop(): exitStatus = " + WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution.getExitStatus() + ", restartOn = " + restartOn);
            }
            RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = WorkUnitThreadControllerImpl.this.getStopLock();
            synchronized (stopLock2) {
                BatchStatus batchStatus = WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution.getBatchStatus();
                if (batchStatus.equals((Object)BatchStatus.STARTING) || batchStatus.equals((Object)BatchStatus.STARTED)) {
                    WorkUnitThreadControllerImpl.this.batchStatusStopping();
                }
            }
            WorkUnitThreadControllerImpl.this.getPersistenceManagerService().updateJobInstanceWithRestartOn(WorkUnitThreadControllerImpl.this.runtimeWorkUnitExecution.getTopLevelInstanceId(), restartOn);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl$JobControllerHelper", JobControllerHelper.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private abstract class AbstractControllerHelper
    implements ControllerHelper {
        static final long serialVersionUID = 6709141047742523140L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AbstractControllerHelper() {
        }

        @Override
        public abstract void jslStop();

        @Override
        public ExecutionStatus runExecutionOnThread() {
            return WorkUnitThreadControllerImpl.this.executeWorkUnit();
        }

        @Override
        public void batchStatusFailedFromException() {
            WorkUnitThreadControllerImpl.this.updateJobBatchStatus(BatchStatus.FAILED);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl$AbstractControllerHelper", AbstractControllerHelper.class, (String)"wsbatch", null);
        }
    }
}

