/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.yoko.orb.OB.BootManager;
import org.apache.yoko.orb.OB.ClientManager;
import org.apache.yoko.orb.OB.CoreTraceLevels;
import org.apache.yoko.orb.OB.DispatchStrategyFactory;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.MultiRequestSender;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.OrbAsyncHandler;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.PolicyFactoryManager;
import org.apache.yoko.orb.OB.RecursiveMutex;
import org.apache.yoko.orb.OB.URLRegistry;
import org.apache.yoko.orb.OB.UnknownExceptionStrategy;
import org.apache.yoko.orb.OB.ValueFactoryManager;
import org.apache.yoko.orb.OBPortableServer.POAManagerFactory;
import org.apache.yoko.orb.OCI.AccFactoryRegistry;
import org.apache.yoko.orb.OCI.ConFactoryRegistry;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Cache;
import org.apache.yoko.util.concurrent.WeakCountedCache;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.IOP.CodecFactory;

public final class ORBInstance {
    private final Cache<ConnectorInfo, GIOPConnection> outboundConnectionCache = new WeakCountedCache(GIOPConnection::destroy, 0, 100);
    private final ORB orb;
    private final int nativeCodeSet;
    private final int nativeWcharCodeSet;
    private final int defaultWcharCodeSet;
    private final String orbId;
    private final String serverID;
    private final String serverInstanceID;
    private ObjectFactory objectFactory;
    private ClientManager clientManager;
    private PolicyFactoryManager policyFactoryManager;
    private PIManager interceptorManager;
    private InitialServiceManager initServiceManager;
    private ValueFactoryManager valueFactoryManager;
    private CodecFactory codecFactory;
    private POAManagerFactory pmFactory;
    private MultiRequestSender multiRequestSender;
    private final Properties properties;
    private DispatchStrategyFactory dispatchStrategyFactory;
    private BootManager bootManager;
    private final Logger logger;
    private final CoreTraceLevels coreTraceLevels;
    private final RecursiveMutex orbSyncMutex = new RecursiveMutex();
    private final ExecutorService serverExecutor;
    private final Phaser serverPhaser = new Phaser(1);
    private final ExecutorService clientExecutor;
    private final Phaser clientPhaser = new Phaser(1);
    private ConFactoryRegistry conFactoryRegistry;
    private AccFactoryRegistry accFactoryRegistry;
    private UnknownExceptionStrategy unknownExceptionStrategy;
    private final URLRegistry urlRegistry;
    private final boolean useTypeCodeCache;
    private final boolean extendedWchar;
    private OrbAsyncHandler asyncHandler;
    private final AtomicBoolean destroyCalled = new AtomicBoolean();

    protected void finalize() throws Throwable {
        Assert.ensure((boolean)this.destroyCalled.get());
        super.finalize();
    }

    public ORBInstance(ORB orb, String orbId, String serverID, String serverInstance, ObjectFactory objectFactory, ClientManager clientManager, PolicyFactoryManager policyFactoryManager, PIManager piManager, InitialServiceManager initServiceManager, ValueFactoryManager valueFactoryManager, CodecFactory codecFactory, POAManagerFactory pmFactory, MultiRequestSender multiRequestSender, Properties properties, DispatchStrategyFactory dispatchStrategyFactory, BootManager bootManager, Logger logger, CoreTraceLevels coreTraceLevels, ConFactoryRegistry conFactoryRegistry, AccFactoryRegistry accFactoryRegistry, UnknownExceptionStrategy unknownExceptionStrategy, URLRegistry urlRegistry, int nativeCs, int nativeWcs, int defaultWcs) {
        this.orb = orb;
        this.orbId = orbId;
        this.serverID = serverID;
        this.serverInstanceID = serverInstance;
        this.objectFactory = objectFactory;
        this.clientManager = clientManager;
        this.policyFactoryManager = policyFactoryManager;
        this.interceptorManager = piManager;
        this.initServiceManager = initServiceManager;
        this.valueFactoryManager = valueFactoryManager;
        this.codecFactory = codecFactory;
        this.pmFactory = pmFactory;
        this.multiRequestSender = multiRequestSender;
        this.properties = properties;
        this.dispatchStrategyFactory = dispatchStrategyFactory;
        this.bootManager = bootManager;
        this.logger = logger;
        this.coreTraceLevels = coreTraceLevels;
        this.conFactoryRegistry = conFactoryRegistry;
        this.accFactoryRegistry = accFactoryRegistry;
        this.unknownExceptionStrategy = unknownExceptionStrategy;
        this.urlRegistry = urlRegistry;
        this.nativeCodeSet = nativeCs;
        this.nativeWcharCodeSet = nativeWcs;
        this.defaultWcharCodeSet = defaultWcs;
        this.clientExecutor = Executors.newCachedThreadPool(r -> {
            Thread result = new Thread(r);
            result.setDaemon(true);
            return result;
        });
        this.serverExecutor = Executors.newCachedThreadPool(r -> {
            Thread result = new Thread(r);
            result.setDaemon(true);
            return result;
        });
        String tcc = this.properties.getProperty("yoko.orb.use_type_code_cache");
        this.useTypeCodeCache = tcc == null || !tcc.equals("false");
        String extWchar = this.properties.getProperty("yoko.orb.extended_wchar");
        this.extendedWchar = extWchar != null && extWchar.equals("true");
        String amiWorkersStr = this.properties.getProperty("yoko.orb.ami_workers");
        int amiWorkers = amiWorkersStr == null ? 1 : Math.max(1, Integer.parseInt(amiWorkersStr));
        this.asyncHandler = new OrbAsyncHandler(amiWorkers);
    }

    public void destroy() {
        boolean firstCallToDestroy = this.destroyCalled.compareAndSet(false, true);
        Assert.ensure((boolean)firstCallToDestroy);
        this.pmFactory.destroy();
        this.pmFactory = null;
        this.initServiceManager.destroy();
        this.initServiceManager = null;
        this.objectFactory.destroy();
        this.objectFactory = null;
        this.clientManager = null;
        this.policyFactoryManager.destroy();
        this.policyFactoryManager = null;
        this.interceptorManager.destroy();
        this.interceptorManager = null;
        this.valueFactoryManager.destroy();
        this.valueFactoryManager = null;
        this.codecFactory = null;
        this.multiRequestSender = null;
        this.dispatchStrategyFactory = null;
        this.bootManager = null;
        this.conFactoryRegistry = null;
        this.accFactoryRegistry = null;
        this.unknownExceptionStrategy = null;
        this.asyncHandler.shutdown();
        this.asyncHandler = null;
    }

    public ORB getORB() {
        return this.orb;
    }

    public int getNativeCs() {
        return this.nativeCodeSet;
    }

    public int getNativeWcs() {
        return this.nativeWcharCodeSet;
    }

    public int getDefaultWcs() {
        return this.defaultWcharCodeSet;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public PolicyFactoryManager getPolicyFactoryManager() {
        return this.policyFactoryManager;
    }

    public PolicyManager getPolicyManager() {
        try {
            return PolicyManagerHelper.narrow((Object)this.orb.resolve_initial_references("ORBPolicyManager"));
        }
        catch (InvalidName invalidName) {
            throw new INTERNAL("Could not find PolicyManager");
        }
    }

    public PIManager getPIManager() {
        return this.interceptorManager;
    }

    public InitialServiceManager getInitialServiceManager() {
        return this.initServiceManager;
    }

    public ValueFactoryManager getValueFactoryManager() {
        return this.valueFactoryManager;
    }

    public CodecFactory getCodecFactory() {
        return this.codecFactory;
    }

    public POAManagerFactory getPOAManagerFactory() {
        return this.pmFactory;
    }

    public MultiRequestSender getMultiRequestSender() {
        return this.multiRequestSender;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public DispatchStrategyFactory getDispatchStrategyFactory() {
        return this.dispatchStrategyFactory;
    }

    public BootManager getBootManager() {
        return this.bootManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CoreTraceLevels getCoreTraceLevels() {
        return this.coreTraceLevels;
    }

    public RecursiveMutex getORBSyncMutex() {
        return this.orbSyncMutex;
    }

    public ExecutorService getServerExecutor() {
        return this.serverExecutor;
    }

    public Phaser getServerPhaser() {
        return this.serverPhaser;
    }

    public ExecutorService getClientExecutor() {
        return this.clientExecutor;
    }

    public Phaser getClientPhaser() {
        return this.clientPhaser;
    }

    public ConFactoryRegistry getConFactoryRegistry() {
        return this.conFactoryRegistry;
    }

    public AccFactoryRegistry getAccFactoryRegistry() {
        return this.accFactoryRegistry;
    }

    public UnknownExceptionStrategy getUnknownExceptionStrategy() {
        return this.unknownExceptionStrategy;
    }

    public UnknownExceptionStrategy setUnknownExceptionStrategy(UnknownExceptionStrategy strategy) {
        UnknownExceptionStrategy result = this.unknownExceptionStrategy;
        this.unknownExceptionStrategy = strategy;
        return result;
    }

    public URLRegistry getURLRegistry() {
        return this.urlRegistry;
    }

    public String getOrbId() {
        return this.orbId;
    }

    public String getServerId() {
        return this.serverID;
    }

    public String getServerInstance() {
        return this.serverInstanceID;
    }

    public boolean useTypeCodeCache() {
        return this.useTypeCodeCache;
    }

    public boolean extendedWchar() {
        return this.extendedWchar;
    }

    public OrbAsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public Cache<ConnectorInfo, GIOPConnection> getOutboundConnectionCache() {
        return this.outboundConnectionCache;
    }
}

