/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.ObjectClassDefinitionImpl;
import org.eclipse.osgi.util.NLS;

public class Designate {
    private final String bundle;
    private final String factoryPid;
    private final boolean merge;
    private final ObjectClassDefinitionImpl ocd;
    private final boolean optional;
    private final String pid;

    Designate(Builder b) {
        this.bundle = b.bundle;
        this.factoryPid = b.factoryPid;
        this.merge = b.merge;
        this.ocd = b.ocd;
        this.optional = b.optional;
        this.pid = b.pid;
    }

    public String getBundle() {
        return this.bundle;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public boolean isFactory() {
        return this.factoryPid != null && this.factoryPid.length() != 0;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public ObjectClassDefinitionImpl getObjectClassDefinition() {
        return this.ocd;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getPid() {
        return this.pid;
    }

    public static class Builder {
        String bundle;
        String factoryPid;
        boolean merge;
        ObjectClassDefinitionImpl ocd;
        boolean optional;
        String pid;

        public Builder(ObjectClassDefinitionImpl ocd) {
            if (ocd == null) {
                throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.MISSING_REQUIRED_PARAMETER, (Object)"ocd"));
            }
            this.ocd = ocd;
        }

        public Designate build() {
            return new Designate(this);
        }

        public Builder bundle(String value) {
            this.bundle = value;
            return this;
        }

        public Builder factoryPid(String value) {
            this.factoryPid = value;
            return this;
        }

        public Builder merge(boolean value) {
            this.merge = value;
            return this;
        }

        public Builder optional(boolean value) {
            this.optional = value;
            return this;
        }

        public Builder pid(String value) {
            this.pid = value;
            return this;
        }
    }
}

