/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.ExtendedBoolean;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.QualifiedDestinationName;
import com.ibm.ws.sib.admin.internal.BaseDestinationDefinitionImpl;
import com.ibm.ws.sib.admin.internal.DestinationConfigType;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;

public class DestinationAliasDefinitionImpl
extends BaseDestinationDefinitionImpl
implements DestinationAliasDefinition {
    private static final TraceComponent tc = SibTr.register(DestinationAliasDefinitionImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private String _bus = null;
    private int _defaultPriority = -1;
    private boolean _delegateAuthorizationCheckToTarget = true;
    private QualifiedDestinationName[] _forwardRoutingPath = null;
    private Reliability _maxReliability = Reliability.NONE;
    private ExtendedBoolean _producerQOSOverrideEnabled = ExtendedBoolean.NONE;
    private ExtendedBoolean _receiveAllowed = ExtendedBoolean.NONE;
    private Reliability _reliability = Reliability.NONE;
    private QualifiedDestinationName _replyDestination = null;
    private ExtendedBoolean _sendAllowed = ExtendedBoolean.NONE;
    private String _targetBus = null;
    private String _targetName = null;
    private SIBUuid8[] scopedQueuePointMEs = null;

    DestinationAliasDefinitionImpl(DestinationType type, String name) {
        super(type, name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationAliasDefinitionImpl", (Object)new Object[]{type, name});
        }
        this.setConfigType(DestinationConfigType.ALIAS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationAliasDefinitionImpl", (Object)this);
        }
    }

    DestinationAliasDefinitionImpl(LWMConfig dest) {
        super(dest);
        this.setUUID(new SIBUuid12());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationAliasDefinitionImpl", (Object)dest);
        }
        this.setConfigType(DestinationConfigType.ALIAS);
        this.setFromConfig(dest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationAliasDefinitionImpl", (Object)this);
        }
    }

    @Override
    protected void setFromConfig(LWMConfig dest) {
        super.setFromConfig(dest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setFromConfig", (Object)dest);
        }
        AliasDestination destConfig = (AliasDestination)dest;
        this._targetBus = null;
        this._targetName = destConfig.getTargetDestination();
        this._delegateAuthorizationCheckToTarget = destConfig.getDelegateAuthCheckToTargetDestination();
        String b = destConfig.isOverrideOfQOSByProducerAllowed();
        this._producerQOSOverrideEnabled = b.equalsIgnoreCase("TRUE") ? ExtendedBoolean.TRUE : (b.equalsIgnoreCase("FALSE") ? ExtendedBoolean.FALSE : ExtendedBoolean.NONE);
        b = destConfig.isReceiveAllowed();
        this._receiveAllowed = b.equalsIgnoreCase("TRUE") ? ExtendedBoolean.TRUE : (b.equalsIgnoreCase("FALSE") ? ExtendedBoolean.FALSE : ExtendedBoolean.NONE);
        String _rs = destConfig.getDefaultReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            this._reliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            this._reliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            this._reliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            this._reliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            this._reliability = Reliability.RELIABLE_PERSISTENT;
        } else if (_rs.equals("INHERIT")) {
            this._reliability = Reliability.NONE;
        }
        _rs = destConfig.getMaximumReliability();
        if (_rs.equals("BEST_EFFORT_NONPERSISTENT")) {
            this._maxReliability = Reliability.BEST_EFFORT_NONPERSISTENT;
        } else if (_rs.equals("ASSURED_PERSISTENT")) {
            this._maxReliability = Reliability.ASSURED_PERSISTENT;
        } else if (_rs.equals("EXPRESS_NONPERSISTENT")) {
            this._maxReliability = Reliability.EXPRESS_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_NONPERSISTENT")) {
            this._maxReliability = Reliability.RELIABLE_NONPERSISTENT;
        } else if (_rs.equals("RELIABLE_PERSISTENT")) {
            this._maxReliability = Reliability.RELIABLE_PERSISTENT;
        } else if (_rs.equals("INHERIT")) {
            this._maxReliability = Reliability.NONE;
        }
        b = destConfig.isSendAllowed();
        if (b.equalsIgnoreCase("TRUE")) {
            this._sendAllowed = ExtendedBoolean.TRUE;
        } else if (b.equalsIgnoreCase("FALSE")) {
            this._sendAllowed = ExtendedBoolean.FALSE;
        } else if (b.equalsIgnoreCase("INHERIT")) {
            this._sendAllowed = ExtendedBoolean.NONE;
        }
    }

    public String getBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBus", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBus", (Object)this._bus);
        }
        return this._bus;
    }

    public void setBus(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBus", (Object)busName);
        }
        this._bus = busName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBus");
        }
    }

    public String getTargetName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetName", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetName", (Object)this._targetName);
        }
        return this._targetName;
    }

    public void setTargetName(String targetName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTargetName", (Object)targetName);
        }
        this._targetName = targetName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTargetName");
        }
    }

    public String getTargetBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBus", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetBus", (Object)this._targetBus);
        }
        return this._targetBus;
    }

    public void setTargetBus(String targetBus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTargetBus", (Object)targetBus);
        }
        this._targetBus = targetBus;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTargetBus");
        }
    }

    public int getDefaultPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultPriority", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = this._defaultPriority;
            SibTr.exit((TraceComponent)tc, (String)"getDefaultPriority", (Object)i);
        }
        return this._defaultPriority;
    }

    public void setDefaultPriority(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = value;
            SibTr.entry((TraceComponent)tc, (String)"setDefaultPriority", (Object)i);
        }
        this._defaultPriority = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefaultPriority");
        }
    }

    public Reliability getMaxReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxReliability", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaxReliability", (Object)this._maxReliability.toString());
        }
        return this._maxReliability;
    }

    public void setMaxReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMaxReliability", (Object)value.toString());
        }
        this._maxReliability = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaxReliability");
        }
    }

    public ExtendedBoolean isOverrideOfQOSByProducerAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isOverrideOfQOSByProducerAllowed", (Object)this._producerQOSOverrideEnabled.toString());
        }
        return this._producerQOSOverrideEnabled;
    }

    public void setOverrideOfQOSByProducerAllowed(ExtendedBoolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setOverrideOfQOSByProducerAllowed", (Object)value.toString());
        }
        this._producerQOSOverrideEnabled = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setOverrideOfQOSByProducerAllowed");
        }
    }

    public ExtendedBoolean isReceiveAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)this._receiveAllowed.toString());
        }
        return this._receiveAllowed;
    }

    public void setReceiveAllowed(ExtendedBoolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReceiveAllowed", (Object)value.toString());
        }
        this._receiveAllowed = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReceiveAllowed");
        }
    }

    public Reliability getDefaultReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultReliability", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = this._reliability.toInt();
            SibTr.exit((TraceComponent)tc, (String)"getDefaultReliability", (Object)(i + " " + this._reliability.toString()));
        }
        return this._reliability;
    }

    public void setDefaultReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = value.toInt();
            SibTr.entry((TraceComponent)tc, (String)"setDefaultReliability", (Object)(i + " " + value.toString()));
        }
        this._reliability = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefaultReliability");
        }
    }

    public ExtendedBoolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed", null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)this._sendAllowed.toString());
        }
        return this._sendAllowed;
    }

    public void setSendAllowed(ExtendedBoolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)value.toString());
        }
        this._sendAllowed = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSendAllowed");
        }
    }

    public QualifiedDestinationName getReplyDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReplyDestination", (Object)this._replyDestination);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (this._replyDestination != null) {
                SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", (Object)this._replyDestination.toString());
            } else {
                SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", (Object)"null");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReplyDestination", (Object)this._replyDestination);
        }
        return this._replyDestination;
    }

    public void setReplyDestination(QualifiedDestinationName value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReplyDestination", (Object)value.toString());
        }
        this._replyDestination = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReplyDestination");
        }
    }

    public QualifiedDestinationName[] getForwardRoutingPath() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardRoutingPath", (Object)this._forwardRoutingPath);
        }
        QualifiedDestinationName[] returnValue = null;
        if (this._forwardRoutingPath != null) {
            returnValue = new QualifiedDestinationName[this._forwardRoutingPath.length];
            System.arraycopy(this._forwardRoutingPath, 0, returnValue, 0, this._forwardRoutingPath.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForwardRoutingPath", (Object)returnValue);
        }
        return returnValue;
    }

    public void setForwardRoutingPath(QualifiedDestinationName[] newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setForwardRoutingPath", (Object)newValue);
        }
        if (newValue == null) {
            this._forwardRoutingPath = null;
        } else {
            this._forwardRoutingPath = new QualifiedDestinationName[newValue.length];
            System.arraycopy(newValue, 0, this._forwardRoutingPath, 0, newValue.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setForwardRoutingPath");
        }
    }

    public boolean getDelegateAuthorizationCheckToTarget() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDelegateAuthorizationCheckToTarget", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDelegateAuthorizationCheckToTarget");
        }
        return this._delegateAuthorizationCheckToTarget;
    }

    public void setDelegateAuthorizationCheckToTarget(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDelegateAuthorizationCheckToTarget", (Object)value);
        }
        this._delegateAuthorizationCheckToTarget = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDelegateAuthorizationCheckToTarget");
        }
    }

    public SIBUuid8[] getScopedQueuePointMEs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getScopedQueuePointMEs", (Object)this);
        }
        SIBUuid8[] returnValue = null;
        if (this.scopedQueuePointMEs != null) {
            returnValue = new SIBUuid8[this.scopedQueuePointMEs.length];
            System.arraycopy(this.scopedQueuePointMEs, 0, returnValue, 0, this.scopedQueuePointMEs.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getScopedQueuePointMEs", (Object)returnValue);
        }
        return returnValue;
    }

    public void setScopedQueuePointMEs(SIBUuid8[] newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setScopedQueuePointMEs", (Object)newValue);
        }
        if (newValue == null) {
            this.scopedQueuePointMEs = null;
        } else {
            this.scopedQueuePointMEs = new SIBUuid8[newValue.length];
            System.arraycopy(newValue, 0, this.scopedQueuePointMEs, 0, newValue.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setScopedQueuePointMEs");
        }
    }
}

