/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.util.lang.Hex;
import org.apache.myfaces.util.token.SessionIdGenerator;

public class KeyFactorySecureRandom
extends KeyFactory<byte[]> {
    private final SessionIdGenerator sessionIdGenerator;
    private final int length;

    public KeyFactorySecureRandom(FacesContext facesContext) {
        String secureRandomAlgorithm;
        String secureRandomProvider;
        MyfacesConfig config = MyfacesConfig.getCurrentInstance((FacesContext)facesContext);
        this.length = config.getRandomKeyInViewStateSessionTokenLength();
        this.sessionIdGenerator = new SessionIdGenerator();
        this.sessionIdGenerator.setSessionIdLength(this.length);
        String secureRandomClass = config.getRandomKeyInViewStateSessionTokenSecureRandomClass();
        if (secureRandomClass != null) {
            this.sessionIdGenerator.setSecureRandomClass(secureRandomClass);
        }
        if ((secureRandomProvider = config.getRandomKeyInViewStateSessionTokenSecureRandomProvider()) != null) {
            this.sessionIdGenerator.setSecureRandomProvider(secureRandomProvider);
        }
        if ((secureRandomAlgorithm = config.getRandomKeyInViewStateSessionTokenSecureRandomAlgorithm()) != null) {
            this.sessionIdGenerator.setSecureRandomAlgorithm(secureRandomAlgorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateCounterKey(FacesContext facesContext) {
        Integer sequence;
        Object sessionObj;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = sessionObj = externalContext.getSession(true);
        synchronized (object) {
            Map map = externalContext.getSessionMap();
            sequence = (Integer)map.get("jsf_sequence");
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence + 1);
            map.put("jsf_sequence", sequence);
        }
        return sequence;
    }

    @Override
    public byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        byte[] key = new byte[this.length + 4];
        this.sessionIdGenerator.getRandomBytes(array);
        System.arraycopy(array, 0, key, 0, array.length);
        int value = this.generateCounterKey(facesContext);
        key[array.length] = (byte)(value >>> 24);
        key[array.length + 1] = (byte)(value >>> 16);
        key[array.length + 2] = (byte)(value >>> 8);
        key[array.length + 3] = (byte)value;
        return key;
    }

    @Override
    public String encode(byte[] key) {
        return new String(Hex.encodeHex(key));
    }

    @Override
    public byte[] decode(String value) {
        try {
            return Hex.decodeHex(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

