/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionManagerMBean;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.management.AttributeChangeNotification;
import javax.management.DynamicMBean;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.StandardEmitterMBean;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(service={SessionManagerMBean.class, DynamicMBean.class}, configurationPid={"com.ibm.ws.session"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.vendor=IBM", "jmx.objectname=WebSphere:name=com.ibm.ws.jmx.mbeans.sessionManagerMBean"})
public class SessionManagerMBeanImpl
extends StandardEmitterMBean
implements SessionManagerMBean {
    private static final String methodClassName = "SessionManagerMBeanImpl";
    private Map<String, Object> sessionManagerProps = null;
    private Map<String, Object> allowedProps = new HashMap<String, Object>();
    static final String CFG_COOKIE_NAME = "cookieName";
    static final String CFG_CLONE_SEPARATOR = "cloneSeparator";
    static final String CFG_CLONE_ID = "cloneId";
    private static final List<String> EXPECTED_KEYS = new ArrayList<String>(Arrays.asList("cookieName", "cloneSeparator", "cloneId"));
    static final String ATTRIBUTE_NAME_COOKIE = "CookieName";
    static final String ATTRIBUTE_NAME_CLONE_SEPARATOR = "CloneSeparator";
    static final String ATTRIBUTE_NAME_CLONE_ID = "CloneID";
    private final AtomicLong sequenceNum = new AtomicLong();
    boolean sessionManagerConfigFound = false;

    public SessionManagerMBeanImpl() throws NotCompliantMBeanException {
        super(SessionManagerMBean.class, new NotificationBroadcasterSupport((Executor)null, new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "")));
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        SessionManagerConfig sessionManagerConfig;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "activate");
        }
        if ((sessionManagerConfig = SessionMgrComponentImpl.getServerSessionManagerConfig()) != null) {
            this.allowedProps.put(CFG_COOKIE_NAME, sessionManagerConfig.getSessionCookieName());
            this.allowedProps.put(CFG_CLONE_SEPARATOR, Character.toString(SessionManagerConfig.getCloneSeparator()));
            this.allowedProps.put(CFG_CLONE_ID, SessionManagerConfig.getCloneId());
            this.sessionManagerConfigFound = true;
        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "activate", "No session manager config found, so no session cookie names are available.");
        }
        this.sessionManagerProps = this.filterUnexpectedKeys(props);
        Set<Map.Entry<String, Object>> entries = this.sessionManagerProps.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            if (!EXPECTED_KEYS.contains(key)) continue;
            this.allowedProps.put(key, entry.getValue());
        }
        this.modified(props);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, Map<String, Object> props) {
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "modified");
        }
        if (!this.sessionManagerConfigFound) {
            SessionManagerConfig sessionManagerConfig = SessionMgrComponentImpl.getServerSessionManagerConfig();
            if (sessionManagerConfig != null) {
                this.allowedProps.put(CFG_COOKIE_NAME, sessionManagerConfig.getSessionCookieName());
                this.allowedProps.put(CFG_CLONE_SEPARATOR, Character.toString(SessionManagerConfig.getCloneSeparator()));
                this.allowedProps.put(CFG_CLONE_ID, SessionManagerConfig.getCloneId());
                this.sessionManagerConfigFound = true;
            } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "modified", "No session manager config found, so no session cookie names are available.");
            }
        }
        String oldCookieName = null;
        String oldSeparatorName = null;
        String oldCloneID = null;
        if (this.sessionManagerProps != null) {
            oldCookieName = (String)this.allowedProps.get(CFG_COOKIE_NAME);
            oldSeparatorName = (String)this.allowedProps.get(CFG_CLONE_SEPARATOR);
            oldCloneID = (String)this.allowedProps.get(CFG_CLONE_ID);
        }
        this.sessionManagerProps = this.filterUnexpectedKeys(props);
        Set<Map.Entry<String, Object>> entries = this.sessionManagerProps.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            if (!EXPECTED_KEYS.contains(key)) continue;
            this.allowedProps.put(key, entry.getValue());
        }
        String newCookieName = (String)this.sessionManagerProps.get(CFG_COOKIE_NAME);
        String newSeparatorName = (String)this.sessionManagerProps.get(CFG_CLONE_SEPARATOR);
        String newCloneID = (String)this.sessionManagerProps.get(CFG_CLONE_ID);
        if (newCloneID == null) {
            newCloneID = SessionManagerConfig.getCloneId();
            this.allowedProps.put(CFG_CLONE_ID, newCloneID);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "modified", "Publishing to repository, oldCloneID = " + oldCloneID + " newCloneID = " + newCloneID);
        }
        this.publishToRepository(ATTRIBUTE_NAME_COOKIE, "java.lang.String", oldCookieName, newCookieName);
        this.publishToRepository(ATTRIBUTE_NAME_CLONE_SEPARATOR, "java.lang.String", oldSeparatorName, newSeparatorName);
        this.publishToRepository(ATTRIBUTE_NAME_CLONE_ID, "java.lang.String", oldCloneID, newCloneID);
    }

    private Map<String, Object> filterUnexpectedKeys(Map<String, Object> inputProps) {
        HashMap<String, Object> outputProps = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = inputProps.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            if (!EXPECTED_KEYS.contains(key)) continue;
            outputProps.put(key, entry.getValue());
        }
        return outputProps;
    }

    private void publishToRepository(String attributeName, String attributeType, Object oldValue, Object newValue) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "publishToRepository");
        }
        super.sendNotification(new AttributeChangeNotification(this, this.sequenceNum.incrementAndGet(), System.currentTimeMillis(), "", attributeName, attributeType, oldValue, newValue));
    }

    @Override
    public String getCloneSeparator() {
        if (this.allowedProps != null) {
            return (String)this.allowedProps.get(CFG_CLONE_SEPARATOR);
        }
        return null;
    }

    @Override
    public String getCookieName() {
        if (this.allowedProps != null) {
            return (String)this.allowedProps.get(CFG_COOKIE_NAME);
        }
        return null;
    }

    @Override
    public String getCloneID() {
        if (this.allowedProps != null) {
            return (String)this.allowedProps.get(CFG_CLONE_ID);
        }
        return null;
    }
}

