/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLinkTransmitterControllable;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamControl;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamSetControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LinkTransmitterControl
extends SourceStreamSetControl
implements SIMPLinkTransmitterControllable {
    private static TraceComponent tc = SibTr.register(LinkTransmitterControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public LinkTransmitterControl(SIBUuid8 remoteMEUuid, StreamSet streamSet, boolean local) {
        super(remoteMEUuid, streamSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkTransmitterControl", (Object)new Object[]{remoteMEUuid, streamSet, local});
        }
        if (local) {
            ((HealthStateListener)this._healthState).updateHealth(HealthStateListener.CONNECTION_UNAVAILABLE_STATE, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkTransmitterControl", (Object)this);
        }
    }

    public long getTimeSinceLastMessageSent() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTimeSinceLastMessageSent");
        }
        long maxTime = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            SourceStreamControl srcStreamControl = (SourceStreamControl)iterator.next();
            long streamTime = srcStreamControl.getLastMsgSentTime();
            if (streamTime <= maxTime) continue;
            maxTime = streamTime;
        }
        maxTime = maxTime == 0L ? -1L : System.currentTimeMillis() - maxTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTimeSinceLastMessageSent", (Object)maxTime);
        }
        return maxTime;
    }

    public boolean isPutInhibited() {
        boolean isPI;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPutInhibited");
        }
        boolean bl = isPI = !this._sourceStreamManager.getDestinationHandler().isSendAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isPutInhibited", (Object)new Boolean(isPI));
        }
        return isPI;
    }

    public String getLinkType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkType");
        }
        String type = ((LinkHandler)this._sourceStreamManager.getDestinationHandler()).getType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkType", (Object)type);
        }
        return type;
    }

    public String getLinkUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkUuid");
        }
        SIBUuid12 uuid = this._sourceStreamManager.getDestinationHandler().getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkUuid", (Object)uuid);
        }
        return uuid.toString();
    }

    public String getLinkName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkName");
        }
        String name = this._sourceStreamManager.getDestinationHandler().getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkName", (Object)name);
        }
        return name;
    }

    public String getTargetBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBusName");
        }
        String name = null;
        DestinationHandler dh = this._sourceStreamManager.getDestinationHandler();
        if (dh.isLink()) {
            name = ((LinkHandler)dh).getBusName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetBusName", (Object)name);
        }
        return name;
    }

    public String getTargetEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTargetEngineUuid", (Object)super.getRemoteEngineUuid());
        }
        return super.getRemoteEngineUuid();
    }

    public String getTargetDestination() {
        return null;
    }

    public boolean isPublicationTransmitter() {
        return false;
    }
}

