/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class MessageProcessorStore
extends SIMPItemStream {
    private static final TraceComponent tc = SibTr.register(MessageProcessorStore.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private SIBUuid8 messagingEngineUuid;

    public MessageProcessorStore() {
    }

    public MessageProcessorStore(SIBUuid8 uuid, MessageStore parentItemStream, SIMPTransactionManager txManager) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorStore", (Object)new Object[]{uuid, parentItemStream, txManager});
        }
        this.setMessagingEngineUuid(uuid);
        parentItemStream.add((ItemStream)this, (Transaction)txManager.createAutoCommitTransaction());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorStore", (Object)((Object)this));
        }
    }

    public SIBUuid8 getMessagingEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineUuid", (Object)this.messagingEngineUuid);
        }
        return this.messagingEngineUuid;
    }

    private void setMessagingEngineUuid(SIBUuid8 uuid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessagingEngineUuid", (Object)new Object[]{uuid});
        }
        this.messagingEngineUuid = uuid;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessagingEngineUuid");
        }
    }

    @Override
    public int getPersistentVersion() {
        return 1;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            oos.writeObject(this.messagingEngineUuid.toByteArray());
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore.getPersistentData", (String)"1:210:1.42", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:217:1.42", e});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:228:1.42", e}, null), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            this.messagingEngineUuid = new SIBUuid8((byte[])ois.readObject());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore.restore", (String)"1:258:1.42", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:265:1.42", e});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:275:1.42", e}, null), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.startTag("messagingEngineUuid");
        writer.write(this.messagingEngineUuid.toString());
        writer.endTag("messagingEngineUuid");
    }
}

