/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.impl.weld.WebSphereCDIDeploymentImpl;
import com.ibm.ws.cdi.impl.weld.validation.LibertyDelegatingValidator;
import com.ibm.ws.cdi.internal.archive.liberty.ExtensionArchiveImpl;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.inject.spi.BeanManager;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.manager.BeanManagerImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyFilteringDelegatingValidator
extends LibertyDelegatingValidator {
    private static final TraceComponent tc = Tr.register(LibertyFilteringDelegatingValidator.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final Set<BeanManager> filteredBeanManagers = new HashSet<BeanManager>();
    static final long serialVersionUID = -7469953321352715090L;

    public LibertyFilteringDelegatingValidator(Validator delegate, WebSphereCDIDeployment webSphereCDIDeployment) {
        super(delegate);
        WebSphereCDIDeploymentImpl deployment = (WebSphereCDIDeploymentImpl)webSphereCDIDeployment;
        for (WebSphereBeanDeploymentArchive bda : deployment.getRuntimeExtensionBDAs()) {
            CDIArchive archive = bda.getArchive();
            if (!(archive instanceof ExtensionArchiveImpl) || !((ExtensionArchiveImpl)archive).applicationBDAsVisible()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{"BeanManager {0} will not be validated", bda.getBeanManager()});
            }
            this.filteredBeanManagers.add(bda.getBeanManager());
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployment deployment) {
        if (!this.filteredBeanManagers.contains(manager)) {
            super.validateDeployment(manager, deployment);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"validateDeployment", (Object[])new Object[]{"Skipping BeanManager {0}", manager});
        }
    }
}

