/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.runtime.listeners;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.ModuleStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webserver.plugin.runtime.interfaces.PluginUtilityConfigGenerator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.webcontainer.osgi.mbeans.GeneratePluginConfig;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import jakarta.servlet.SessionCookieConfig;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class, RuntimeUpdateListener.class, ModuleStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class GeneratePluginConfigListener
implements RuntimeUpdateListener,
ApplicationStateListener,
ModuleStateListener {
    private static final TraceComponent tc = Tr.register(GeneratePluginConfigListener.class, (String)"PluginRuntime", null);
    private int updatesInProgress = 0;
    private int appsInService = 0;
    private volatile ExecutorService executorSrvc;
    private GeneratePluginConfig gpc;
    private ConcurrentHashMap<String, String> cookieNames = new ConcurrentHashMap();
    private SessionManager smgr;
    private WsLocationAdmin locationService;
    private static GeneratePluginConfigListener theListener = null;
    private static final String CHECKPOINT_GEN_PLUGIN = "io.openliberty.checkpoint.generate.plugin";
    private boolean enablePlugin;
    static final long serialVersionUID = 8808161525052262022L;

    public static GeneratePluginConfigListener getGeneratePluginConfigListener() {
        return theListener;
    }

    @Activate
    protected void activate(BundleContext bc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: activate called.", (Object[])new Object[0]);
        }
        theListener = this;
        this.enablePlugin = CheckpointPhase.getPhase() == CheckpointPhase.INACTIVE || Boolean.valueOf(bc.getProperty(CHECKPOINT_GEN_PLUGIN)) != false;
    }

    @Deactivate
    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: deactivate called.", (Object[])new Object[0]);
        }
    }

    @Reference(service=GeneratePluginConfig.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setGeneratePluginConfig(GeneratePluginConfig mb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: GPC set", (Object[])new Object[0]);
        }
        this.gpc = mb;
    }

    protected void unsetGeneratePluginConfig(GeneratePluginConfig mb) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: GPC unset", (Object[])new Object[0]);
        }
        this.gpc = null;
    }

    @Reference(service=ExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutor(ExecutorService executorSrvc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"GPCL: executorService set", (Object[])new Object[0]);
        }
        this.executorSrvc = executorSrvc;
    }

    protected void unsetExecutor(ExecutorService executorSrvc) {
        this.executorSrvc = null;
    }

    @Reference(service=SessionManager.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setSessionManager(SessionManager ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Session Manager set", (Object[])new Object[0]);
        }
        this.smgr = ref;
    }

    protected void unsetSessionManager(SessionManager ref) {
    }

    @Reference(service=WsLocationAdmin.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setLocationService(WsLocationAdmin ref) {
        this.locationService = ref;
    }

    protected void unsetLocationService(WsLocationAdmin ref) {
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        this.setFutureGeneratePluginTask();
        ++this.appsInService;
        if (this.smgr != null) {
            this.cookieNames.put(appInfo.getName(), this.smgr.getDefaultAffinityCookie());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application starting, add app to cookie map. app name : " + appInfo.getName() + ", cookie name : " + this.smgr.getDefaultAffinityCookie()), (Object[])new Object[0]);
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application started : " + appInfo.getName()), (Object[])new Object[0]);
        }
        this.runFutureGeneratePluginTask();
    }

    public void applicationStopping(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application stopping, remove stored cookie name : " + appInfo.getName() + ", cookie name : " + this.cookieNames.get(appInfo.getName())), (Object[])new Object[0]);
        }
        this.setFutureGeneratePluginTask();
        this.cookieNames.remove(appInfo.getName());
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application stopped : " + appInfo.getName()), (Object[])new Object[0]);
        }
        this.runFutureGeneratePluginTask();
        --this.appsInService;
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("GPCL: RuntimeUpdate notification " + notification.getName() + ", apps in service = " + this.appsInService), (Object[])new Object[0]);
        }
        if (this.appsInService > 0 && notification.getName().equals("ConfigUpdatesDelivered")) {
            this.setFutureGeneratePluginTask();
            notification.onCompletion((CompletionListener)new ConfigUpdateListener());
        }
    }

    private synchronized void setFutureGeneratePluginTask() {
        ++this.updatesInProgress;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setFutureGeneratePluginTask : future updates now = " + this.updatesInProgress), (Object[])new Object[0]);
        }
    }

    private synchronized boolean unsetFutureGeneratePluginTask() {
        --this.updatesInProgress;
        if (this.updatesInProgress < 0) {
            this.updatesInProgress = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("unsetFutureGeneratePluginTask : future updates now = " + this.updatesInProgress), (Object[])new Object[0]);
        }
        return this.updatesInProgress == 0;
    }

    private synchronized boolean isFuturePluginTask() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isFuturePluginTask : updates in progress = " + this.updatesInProgress), (Object[])new Object[0]);
        }
        return this.updatesInProgress == 0;
    }

    private synchronized void runFutureGeneratePluginTask() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("runFutureGeneratePluginTask : future updates = " + this.updatesInProgress), (Object[])new Object[0]);
        }
        if (this.unsetFutureGeneratePluginTask()) {
            this.submitGeneratePluginTask();
        }
    }

    private void submitGeneratePluginTask() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("submitGeneratePluginTask : FrameworkState.isStopping() = " + FrameworkState.isStopping()), (Object[])new Object[0]);
        }
        ExecutorService currentExecutor = this.executorSrvc;
        if (!FrameworkState.isStopping() && this.enablePlugin && this.gpc != null && currentExecutor != null) {
            Runnable generatePluginTask = new Runnable(){
                static final long serialVersionUID = -2966232188297880222L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"generating webserver plugin", (Object[])new Object[0]);
                    }
                    WsResource writeDirectory = GeneratePluginConfigListener.this.locationService.getServerOutputResource("logs" + File.separatorChar + "state" + File.separatorChar);
                    ((PluginUtilityConfigGenerator)GeneratePluginConfigListener.this.gpc).generatePluginConfig(null, writeDirectory.asFile());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.webserver.plugin.runtime.listeners.GeneratePluginConfigListener$1", 1.class, (String)"PluginRuntime", null);
                }
            };
            CheckpointPhase.onRestore(() -> currentExecutor.submit(generatePluginTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationInitialized(WebApp webApp, SessionCookieConfig sccfg) {
        String cookieName = this.cookieNames.get(webApp.getApplicationName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("application initialized, app : " + webApp.getApplicationName() + ", old cookie name : " + this.cookieNames.get(webApp.getApplicationName()) + ", new cookie name : " + sccfg == null ? null : sccfg.getName()), (Object[])new Object[0]);
        }
        if (cookieName != null && sccfg != null && !cookieName.equals(sccfg.getName())) {
            GeneratePluginConfigListener generatePluginConfigListener = this;
            synchronized (generatePluginConfigListener) {
                if (this.isFuturePluginTask()) {
                    this.submitGeneratePluginTask();
                }
            }
        }
    }

    public void moduleStarting(ModuleInfo moduleInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module starting: " + moduleInfo.getName()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module starting application name: " + moduleInfo.getApplicationInfo().getName()), (Object[])new Object[0]);
        }
        this.setFutureGeneratePluginTask();
    }

    public void moduleStarted(ModuleInfo moduleInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module started: " + moduleInfo.getName()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module started application name: " + moduleInfo.getApplicationInfo().getName()), (Object[])new Object[0]);
        }
        this.runFutureGeneratePluginTask();
    }

    public void moduleStopping(ModuleInfo moduleInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module stopping: " + moduleInfo.getName()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module stopping application name: " + moduleInfo.getApplicationInfo().getName()), (Object[])new Object[0]);
        }
        this.setFutureGeneratePluginTask();
    }

    public void moduleStopped(ModuleInfo moduleInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module stopped: " + moduleInfo.getName()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("module stopped application name: " + moduleInfo.getApplicationInfo().getName()), (Object[])new Object[0]);
        }
        this.runFutureGeneratePluginTask();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ConfigUpdateListener
    implements CompletionListener {
        GeneratePluginConfigListener gpcl;
        static final long serialVersionUID = 6222996881504892273L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfigUpdateListener() {
            this.gpcl = GeneratePluginConfigListener.this;
        }

        public void successfulCompletion(Future future, Object result) {
            this.gpcl.runFutureGeneratePluginTask();
        }

        public void failedCompletion(Future future, Throwable t) {
            this.gpcl.unsetFutureGeneratePluginTask();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.webserver.plugin.runtime.listeners.GeneratePluginConfigListener$ConfigUpdateListener", ConfigUpdateListener.class, (String)"PluginRuntime", null);
        }
    }
}

