/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.context.ExternalContext;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.Serializable;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.push.cdi.WebsocketScopeManager;

public class WebsocketConfigurator
extends ServerEndpointConfig.Configurator {
    public static final String MAX_IDLE_TIMEOUT = "oam.websocket.maxIdleTimeout";
    public static final String WEBSOCKET_VALID = "oam.websocket.valid";
    public static final String WEBSOCKET_USER = "oam.websocket.user";
    private final Long maxIdleTimeout;

    public WebsocketConfigurator(ExternalContext context) {
        this.maxIdleTimeout = MyfacesConfig.getCurrentInstance((ExternalContext)context).getWebsocketMaxIdleTimeout();
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        BeanManager beanManager;
        WebsocketScopeManager scopeManager;
        WebsocketScopeManager.SessionScope sessionScope;
        String channelToken;
        if (this.maxIdleTimeout != null) {
            sec.getUserProperties().put(MAX_IDLE_TIMEOUT, this.maxIdleTimeout);
        }
        if ((channelToken = request.getQueryString()) == null) {
            String uri = request.getRequestURI().toString();
            channelToken = uri.indexOf(63) >= 0 ? uri.substring(uri.indexOf(63) + 1) : uri.substring(uri.lastIndexOf(47) + 1);
        }
        if ((sessionScope = (scopeManager = CDIUtils.get(beanManager = CDI.current().getBeanManager(), WebsocketScopeManager.class)).getSessionScope(false)) != null) {
            Serializable user = sessionScope.getUserFromChannelToken(channelToken);
            if (user != null) {
                sec.getUserProperties().put(WEBSOCKET_USER, user);
            }
            sec.getUserProperties().put(WEBSOCKET_VALID, sessionScope.isTokenValid(channelToken));
        } else {
            sec.getUserProperties().put(WEBSOCKET_VALID, false);
        }
    }
}

