/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class BackgroundLruEvictionStrategy
implements EvictionStrategy,
Runnable {
    private static final TraceComponent tc = Tr.register(BackgroundLruEvictionStrategy.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final TraceComponent tcOOM = Tr.register((String)(BackgroundLruEvictionStrategy.class.getName() + "2"), BackgroundLruEvictionStrategy.class, (String)"EJBContainer.OOM", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy";
    private Cache ivCache;
    private long ivSweepInterval;
    private volatile long ivNewSweepInterval;
    private long ivDiscardThreshold = 60L;
    private long ivMaxDiscardThreshold;
    private long ivMinDiscardThreshold;
    private long ivUpperLimit;
    private long ivNumBelowSoftLimit = 0L;
    private int ivSoftLimitBuffer;
    private final CacheElementEnumerator ivElements;
    private static final long MINIMUM_SWEEP_INTERVAL = 1000L;
    private static final long MAX_THRESHOLD_MULTIPLIER = 120000L;
    private static final long MIN_THRESHOLD_MULTIPLIER = 9000L;
    private static final int NUM_SWEEPS_PER_OOMTRACE = 300;
    private boolean ivIsCanceled = false;
    private final Object ivCancelLock = new Object();
    private ScheduledFuture<?> ivScheduledFuture;
    private final ScheduledExecutorService ivScheduledExecutorService;
    private final ScheduledExecutorService ivDeferrableScheduledExecutorService;
    protected int ivPreferredMaxSize;
    protected volatile int ivNewPreferredMaxSize;

    public BackgroundLruEvictionStrategy(Cache cache, int preferredMaxSize, long sweepInterval, ScheduledExecutorService scheduledExecutorService, ScheduledExecutorService deferrableScheduledExecutorService) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && (tc.isEntryEnabled() || tcOOM.isEntryEnabled())) {
            Tr.entry((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)"BackgroundLruEvictionStrategy", (Object[])new Object[0]);
        }
        this.ivScheduledExecutorService = scheduledExecutorService;
        this.ivDeferrableScheduledExecutorService = deferrableScheduledExecutorService;
        this.ivCache = cache;
        this.initializeCacheData(preferredMaxSize);
        this.ivNewPreferredMaxSize = preferredMaxSize;
        this.ivElements = (CacheElementEnumerator)this.ivCache.enumerateElements();
        sweepInterval = this.getSweepInterval(sweepInterval);
        this.initializeSweepInterval(sweepInterval);
        this.ivNewSweepInterval = sweepInterval;
        if (isTraceOn && (tc.isEntryEnabled() || tcOOM.isEntryEnabled())) {
            Tr.exit((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)"BackgroundLruEvictionStrategy");
        }
    }

    private void initializeCacheData(int cacheSize) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && (tc.isEntryEnabled() || tcOOM.isEntryEnabled())) {
            Tr.entry((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)("initializeCacheData : " + this.ivCache.getName() + " preferred size = " + this.ivPreferredMaxSize), (Object[])new Object[0]);
        }
        this.ivPreferredMaxSize = cacheSize;
        this.ivUpperLimit = (long)((double)this.ivPreferredMaxSize * 1.1);
        this.ivSoftLimitBuffer = this.ivPreferredMaxSize / 100;
        if (this.ivSoftLimitBuffer > 50) {
            this.ivSoftLimitBuffer = 50;
        }
        if (isTraceOn && (tc.isEntryEnabled() || tcOOM.isEntryEnabled())) {
            Tr.exit((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)("initializeCacheData : " + this.ivCache.getName() + " preferred size = " + this.ivPreferredMaxSize + " limit = " + this.ivUpperLimit + ", buffer = " + this.ivSoftLimitBuffer));
        }
    }

    private void initializeSweepInterval(long sweepInterval) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && (tc.isEntryEnabled() || tcOOM.isEntryEnabled())) {
            Tr.entry((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)("initializeSweepInterval : " + this.ivCache.getName() + " preferred size = " + this.ivPreferredMaxSize + ", sweep = " + sweepInterval), (Object[])new Object[0]);
        }
        this.ivSweepInterval = sweepInterval;
        if (this.ivSweepInterval * this.ivDiscardThreshold > 120000L) {
            this.ivDiscardThreshold = 120000L / this.ivSweepInterval;
            if (this.ivDiscardThreshold < 2L) {
                this.ivDiscardThreshold = 2L;
            }
        }
        this.ivMaxDiscardThreshold = this.ivDiscardThreshold;
        this.ivMinDiscardThreshold = 9000L / this.ivSweepInterval;
        if (this.ivMinDiscardThreshold < 2L) {
            this.ivMinDiscardThreshold = 2L;
        }
        if (isTraceOn && (tc.isEntryEnabled() || tcOOM.isEntryEnabled())) {
            Tr.exit((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)("initializeSweepInterval : " + this.ivCache.getName() + " preferred size = " + this.ivPreferredMaxSize + ", sweep = " + this.ivSweepInterval + ", threshold = " + this.ivDiscardThreshold + ", buffer = " + this.ivSoftLimitBuffer));
        }
    }

    private long getSweepInterval(long sweepInterval) {
        return Math.max(sweepInterval, 1000L);
    }

    @Override
    public void setSweepInterval(long sweepInterval) {
        this.ivNewSweepInterval = this.getSweepInterval(sweepInterval);
    }

    @Override
    public void setPreferredMaxSize(int maxSize) {
        this.ivNewPreferredMaxSize = maxSize;
    }

    @Override
    public int getPreferredMaxSize() {
        return this.ivPreferredMaxSize;
    }

    public boolean preferredSizeReached() {
        return this.ivCache.getSize() >= this.ivPreferredMaxSize;
    }

    private boolean isTraceEnabled(boolean debug) {
        if (debug ? tc.isDebugEnabled() : tc.isEntryEnabled()) {
            return true;
        }
        return this.ivCache.numSweeps % 300L == 1L && (debug ? tcOOM.isDebugEnabled() : tcOOM.isEntryEnabled());
    }

    public void start() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        this.ivScheduledFuture = this.ivDeferrableScheduledExecutorService.schedule(this, this.ivSweepInterval, TimeUnit.MILLISECONDS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.ivCancelLock;
        synchronized (object) {
            ScheduledExecutorService executor;
            int newPreferredCacheSize;
            if (this.ivIsCanceled) {
                return;
            }
            long newSweepInterval = this.ivNewSweepInterval;
            if (this.ivSweepInterval != newSweepInterval) {
                this.initializeSweepInterval(newSweepInterval);
            }
            if (this.ivPreferredMaxSize != (newPreferredCacheSize = this.ivNewPreferredMaxSize)) {
                this.initializeCacheData(newPreferredCacheSize);
            }
            try {
                if (this.ivDiscardThreshold < this.ivMaxDiscardThreshold && this.ivNumBelowSoftLimit > this.ivMaxDiscardThreshold) {
                    ++this.ivDiscardThreshold;
                    this.ivNumBelowSoftLimit = 0L;
                }
                this.ivCache.numSweeps = this.ivCache.numSweeps == Long.MAX_VALUE ? 1L : ++this.ivCache.numSweeps;
                if (this.preferredSizeReached()) {
                    this.sweep();
                    if (this.preferredSizeReached()) {
                        this.ivNumBelowSoftLimit = 0L;
                        if ((long)this.ivCache.getSize() > this.ivUpperLimit && this.ivDiscardThreshold > this.ivMinDiscardThreshold) {
                            --this.ivDiscardThreshold;
                            this.sweep();
                        }
                    } else {
                        ++this.ivNumBelowSoftLimit;
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && this.isTraceEnabled(true)) {
                        Tr.debug((TraceComponent)(tc.isDebugEnabled() ? tc : tcOOM), (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ") - Cache limit not reached : " + this.ivCache.getSize() + "/" + this.ivPreferredMaxSize), (Object[])new Object[0]);
                    }
                    ++this.ivNumBelowSoftLimit;
                }
                executor = this.preferredSizeReached() ? this.ivScheduledExecutorService : this.ivDeferrableScheduledExecutorService;
            }
            catch (Throwable e) {
                ScheduledExecutorService executor2;
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.alarm", (String)"446", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", (Object[])new Object[]{this, e});
                    executor2 = this.preferredSizeReached() ? this.ivScheduledExecutorService : this.ivDeferrableScheduledExecutorService;
                }
                catch (Throwable throwable) {
                    ScheduledExecutorService executor3 = this.preferredSizeReached() ? this.ivScheduledExecutorService : this.ivDeferrableScheduledExecutorService;
                    this.ivScheduledFuture = executor3.schedule(this, this.ivSweepInterval, TimeUnit.MILLISECONDS);
                    throw throwable;
                }
                this.ivScheduledFuture = executor2.schedule(this, this.ivSweepInterval, TimeUnit.MILLISECONDS);
            }
            this.ivScheduledFuture = executor.schedule(this, this.ivSweepInterval, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && this.isTraceEnabled(false)) {
            Tr.entry((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ") - Cache limit exceeded : " + this.ivCache.getSize() + "/" + this.ivPreferredMaxSize), (Object[])new Object[0]);
        }
        int numEvicted = 0;
        int numEvictedBelowSoftLimit = 0;
        long sweepCount = 0L;
        try {
            while (this.ivElements.hasMoreElements() && (numEvictedBelowSoftLimit < this.ivSoftLimitBuffer || this.preferredSizeReached())) {
                Element element = this.ivElements.nextElement();
                if (!this.canBeDiscarded(element)) continue;
                boolean evicted = false;
                if (this.ivCache.ivEvictionLocks != null) {
                    Object object = this.ivCache.ivEvictionLocks.getLock(element.key);
                    synchronized (object) {
                        evicted = this.ivCache.evictObject(element.key);
                    }
                } else {
                    evicted = this.ivCache.evictObject(element.key);
                }
                if (!evicted) continue;
                ++numEvicted;
                if (this.preferredSizeReached()) {
                    numEvictedBelowSoftLimit = 0;
                    continue;
                }
                ++numEvictedBelowSoftLimit;
            }
        }
        catch (NoSuchElementException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.sweep", (String)"526", (Object)this);
            if (isTraceOn && this.isTraceEnabled(false)) {
                Tr.exit((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ") - Evicted = " + numEvicted + " : " + this.ivCache.getSize() + " : NoSuchElementException"));
            }
            return;
        }
        finally {
            this.ivElements.reset();
        }
        if (isTraceOn && this.isTraceEnabled(false)) {
            Tr.exit((TraceComponent)(tc.isEntryEnabled() ? tc : tcOOM), (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ") - Evicted = " + numEvicted + " : " + this.ivCache.getSize() + "/" + this.ivPreferredMaxSize));
        }
    }

    @Override
    public boolean canBeDiscarded(Element element) {
        if (element.pinned != 0 || element.ivEvictionIneligible) {
            return false;
        }
        if (ContainerProperties.StrictMaxCacheSize) {
            return true;
        }
        long sweepCount = 0L;
        sweepCount = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
        return sweepCount > this.ivDiscardThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.ivCancelLock;
        synchronized (object) {
            this.ivIsCanceled = true;
            if (this.ivScheduledFuture != null) {
                this.ivScheduledFuture.cancel(false);
            }
            this.ivCache = null;
        }
    }
}

