/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.Attribute;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.LinkedBlockingQueue;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final TraceComponent tc = Tr.register(LibertyHttpRequestHandler.class, null, null);
    private static final int DEFAULT_MAX_QUEUE = 50;
    private final Object lock = new Object();
    private final LinkedBlockingQueue<FullHttpRequest> requestQueue;
    private boolean peerClosedConnection = false;
    private ChannelHandlerContext requestHandlerContext;
    private final int maxRequests;
    private final int maxQueuedRequests;
    private final boolean hasMaxRequests;
    private int acceptedRequests = 0;
    private int completedRequests = 0;
    private boolean closeAfterDrain = false;
    static final long serialVersionUID = -2918035842541727428L;

    public LibertyHttpRequestHandler(HttpChannelConfig config) {
        super(false);
        int queueMax;
        int configMaxRequests = config.getMaximumPersistentRequests();
        this.hasMaxRequests = configMaxRequests > 0;
        this.maxRequests = this.hasMaxRequests ? configMaxRequests : -1;
        this.maxQueuedRequests = queueMax = this.hasMaxRequests ? Math.min(configMaxRequests, 50) : 50;
        this.requestQueue = new LinkedBlockingQueue(this.maxQueuedRequests);
    }

    public void handlerAdded(ChannelHandlerContext context) {
        context.channel().attr(NettyHttpConstants.HANDLING_REQUEST).set((Object)false);
        this.requestHandlerContext = context;
    }

    public void handlerRemoved(ChannelHandlerContext context) {
        FullHttpRequest request;
        while ((request = this.requestQueue.poll()) != null) {
            ReferenceCountUtil.safeRelease((Object)request);
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        FullHttpRequest request;
        while ((request = this.requestQueue.poll()) != null) {
            ReferenceCountUtil.safeRelease((Object)request);
        }
        super.channelInactive(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext context, FullHttpRequest request) throws Exception {
        if (!request.decoderResult().isFinished() || !request.decoderResult().isSuccess()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Bad decode result, close connection. Cause: " + request.decoderResult().cause()), (Object[])new Object[0]);
            }
            ReferenceCountUtil.safeRelease((Object)request);
            context.close();
            return;
        }
        Attribute attribute = context.channel().attr(NettyHttpConstants.HANDLING_REQUEST);
        synchronized (attribute) {
            boolean handlingRequest;
            if (this.closeAfterDrain || this.hasMaxRequests && this.acceptedRequests >= this.maxRequests) {
                ReferenceCountUtil.safeRelease((Object)request);
                this.closeAfterDrain = true;
                LibertyHttpRequestHandler.pauseReading(context);
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Reading Full HTTP Request for channel: " + context.channel()), (Object[])new Object[0]);
            }
            if (handlingRequest = Boolean.TRUE.equals(context.channel().attr(NettyHttpConstants.HANDLING_REQUEST).get())) {
                if (!this.requestQueue.offer(request)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Queue full. Dropping new requests and draining to close.", (Object[])new Object[0]);
                    }
                    ReferenceCountUtil.safeRelease((Object)request);
                    this.closeAfterDrain = true;
                    LibertyHttpRequestHandler.pauseReading(context);
                    return;
                }
                ++this.acceptedRequests;
                if (this.requestQueue.remainingCapacity() == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Queue reached capacity. Reads are paused.", (Object[])new Object[0]);
                    }
                    LibertyHttpRequestHandler.pauseReading(context);
                }
                if (this.hasMaxRequests && this.acceptedRequests >= this.maxRequests) {
                    this.closeAfterDrain = true;
                    LibertyHttpRequestHandler.pauseReading(context);
                }
                return;
            }
            context.channel().attr(NettyHttpConstants.HANDLING_REQUEST).set((Object)true);
            ++this.acceptedRequests;
            if (this.hasMaxRequests && this.acceptedRequests >= this.maxRequests) {
                this.closeAfterDrain = true;
                LibertyHttpRequestHandler.pauseReading(context);
            }
            context.fireChannelRead((Object)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (!this.peerClosedConnection && (event instanceof ChannelInputShutdownEvent || event instanceof ChannelInputShutdownReadComplete)) {
            Attribute attribute = context.channel().attr(NettyHttpConstants.HANDLING_REQUEST);
            synchronized (attribute) {
                if (Boolean.TRUE.equals(context.channel().attr(NettyHttpConstants.HANDLING_REQUEST).get())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Peer closed the connection while we were handling a request, ending the connection after finishing processing", (Object[])new Object[0]);
                    }
                    this.peerClosedConnection = true;
                    LibertyHttpRequestHandler.pauseReading(context);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Peer closed the connection and there was no request being handled, closing the channel", (Object[])new Object[0]);
                    }
                    context.close();
                }
                return;
            }
        }
        super.userEventTriggered(context, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNextRequest() {
        ChannelHandlerContext context = this.requestHandlerContext;
        if (context == null) {
            return;
        }
        Attribute attribute = context.channel().attr(NettyHttpConstants.HANDLING_REQUEST);
        synchronized (attribute) {
            boolean draining;
            ++this.completedRequests;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Processing next available request in request queue. Completed requests: " + this.completedRequests + " of max " + this.maxRequests + ". Queued requests: " + this.requestQueue.size()), (Object[])new Object[0]);
            }
            boolean bl = draining = this.peerClosedConnection || this.closeAfterDrain || this.hasMaxRequests && this.completedRequests >= this.maxRequests;
            if (draining && this.requestQueue.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Closing connection: " + this.requestHandlerContext.channel() + " because peer ended the connection and we have finished processing."), (Object[])new Object[0]);
                }
                this.requestHandlerContext.close();
                return;
            }
            FullHttpRequest nextRequest = this.requestQueue.poll();
            if (nextRequest == null) {
                this.requestHandlerContext.channel().attr(NettyHttpConstants.HANDLING_REQUEST).set((Object)false);
                if (draining) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"No additional requests remaining. Closing channel.", (Object[])new Object[0]);
                    }
                    context.close();
                } else if (!context.channel().config().isAutoRead()) {
                    LibertyHttpRequestHandler.resumeReading(context);
                }
                return;
            }
            if (!draining && !context.channel().config().isAutoRead() && this.requestQueue.remainingCapacity() > 0) {
                LibertyHttpRequestHandler.resumeReading(context);
            }
            this.requestHandlerContext.channel().attr(NettyHttpConstants.HANDLING_REQUEST).set((Object)true);
            this.requestHandlerContext.fireChannelRead((Object)nextRequest);
        }
    }

    private static void pauseReading(ChannelHandlerContext context) {
        ChannelConfig config = context.channel().config();
        if (config.isAutoRead()) {
            config.setAutoRead(false);
        }
    }

    private static void resumeReading(ChannelHandlerContext context) {
        ChannelConfig config = context.channel().config();
        if (!config.isAutoRead()) {
            config.setAutoRead(true);
        }
    }
}

