/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.spi;

import io.openliberty.checkpoint.spi.CheckpointHook;
import java.lang.constant.Constable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public enum CheckpointPhase {
    AFTER_APP_START,
    BEFORE_APP_START,
    INACTIVE(true);

    public static final String CHECKPOINT_PROPERTY = "io.openliberty.checkpoint";
    public static final String CHECKPOINT_ACTIVE_FILTER = "(!(io.openliberty.checkpoint=INACTIVE))";
    public static final String CHECKPOINT_RESTORED_PROPERTY = "io.openliberty.checkpoint.restored";
    public static final String CONDITION_PROCESS_RUNNING_ID = "io.openliberty.process.running";
    public static final String CONDITION_BEFORE_CHECKPOINT_ID = "io.openliberty.before.checkpoint";
    private static final String SERVICE_RANKING = "service.ranking";
    private volatile boolean restored = false;
    private boolean blockAddHooks = false;
    final Map<Integer, StaticCheckpointHook> singleThreadedHooks = new HashMap<Integer, StaticCheckpointHook>();
    final Map<Integer, StaticCheckpointHook> multiThreadedHooks = new HashMap<Integer, StaticCheckpointHook>();
    WeakReference<Object> contextRef = new WeakReference<Object>(null);
    Method registerService;
    Method unregisterService;
    static CheckpointPhase THE_PHASE;
    private static final boolean DEBUG;
    private static final ReentrantReadWriteLock checkpointLock;

    private CheckpointPhase() {
        this(false);
    }

    private CheckpointPhase(boolean inactive) {
        if (inactive) {
            this.restored = true;
        }
    }

    static synchronized void setPhase(String p) {
        if (THE_PHASE != INACTIVE) {
            return;
        }
        CheckpointPhase.debug(() -> "phase set to: " + p);
        CheckpointPhase phase = INACTIVE;
        if (p != null) {
            try {
                phase = CheckpointPhase.valueOf(p.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        THE_PHASE = phase;
        if (phase != INACTIVE) {
            phase.addMultiThreadedHook(Integer.MIN_VALUE, new CheckpointHook(){

                @Override
                public void prepare() {
                    CheckpointPhase.debug(() -> "Locking checkpoint write lock for prepare");
                    checkpointLock.writeLock().lock();
                }

                @Override
                public void restore() {
                    CheckpointPhase.debug(() -> "Unlocking checkpoint write lock for restore");
                    try {
                        checkpointLock.writeLock().unlock();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                }

                @Override
                public void checkpointFailed() {
                    CheckpointPhase.debug(() -> "Unlocking checkpoint write lock for checkpointFailed");
                    try {
                        checkpointLock.writeLock().unlock();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public final boolean restored() {
        return this == INACTIVE || this.restored;
    }

    public final boolean addSingleThreadedHook(CheckpointHook hook) {
        return this.addHook(hook, false, 0);
    }

    public final boolean addSingleThreadedHook(int rank, CheckpointHook hook) {
        return this.addHook(hook, false, rank);
    }

    public final boolean addMultiThreadedHook(CheckpointHook hook) {
        return this.addHook(hook, true, 0);
    }

    public final boolean addMultiThreadedHook(int rank, CheckpointHook hook) {
        return this.addHook(hook, true, rank);
    }

    private synchronized boolean addHook(CheckpointHook hook, boolean multiThreaded, int rank) {
        if (this != THE_PHASE) {
            throw new IllegalStateException("Cannot add hooks to a checkpoint phase that is not in progress.");
        }
        if (this == INACTIVE) {
            return false;
        }
        if (this.restored) {
            return false;
        }
        if (this.blockAddHooks) {
            return false;
        }
        StaticCheckpointHook unregisterStaticHooks = this.multiThreadedHooks.computeIfAbsent(Integer.MAX_VALUE, r -> this.createStaticCheckpointHook(Integer.MAX_VALUE, true, null));
        CheckpointPhase.debug(() -> "Adding hook: " + hook + (multiThreaded ? " multi-threaded" : " single-threaded") + " rank: " + rank);
        Map<Integer, StaticCheckpointHook> addToHooks = multiThreaded ? this.multiThreadedHooks : this.singleThreadedHooks;
        StaticCheckpointHook staticCheckpointHook = addToHooks.computeIfAbsent(rank, r -> this.createStaticCheckpointHook(rank, multiThreaded, unregisterStaticHooks));
        return staticCheckpointHook.addHook(hook);
    }

    private StaticCheckpointHook createStaticCheckpointHook(int rank, boolean multiThreaded, StaticCheckpointHook unregisterStaticHooks) {
        StaticCheckpointHook newHook = new StaticCheckpointHook(rank, multiThreaded);
        Object context = this.contextRef.get();
        if (context != null) {
            newHook.register(context, unregisterStaticHooks);
        }
        return newHook;
    }

    public static synchronized CheckpointPhase getPhase() {
        return THE_PHASE;
    }

    public static <T extends Throwable> void onRestore(OnRestore<T> toRun) throws T {
        CheckpointPhase.onRestore(0, toRun);
    }

    public static <T extends Throwable> void onRestore(int rank, final OnRestore<T> toRun) throws T {
        CheckpointPhase phase = CheckpointPhase.getPhase();
        if (phase.restored()) {
            CheckpointPhase.debug(() -> "Already restored, calling hook now: " + toRun);
            toRun.call();
            return;
        }
        if (!phase.addMultiThreadedHook(rank, new CheckpointHook(){

            @Override
            public void restore() {
                try {
                    toRun.call();
                }
                catch (Throwable e) {
                    CheckpointPhase.sneakyThrow(e);
                }
            }

            public String toString() {
                return toRun.toString();
            }
        })) {
            CheckpointPhase.debug(() -> "Hook not added, calling hook now: " + toRun);
            toRun.call();
        }
    }

    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    private static boolean debugEnabled() {
        return System.getProperty("io.openliberty.checkpoint.debug") != null;
    }

    private static void debug(Supplier<String> message) {
        if (DEBUG) {
            System.out.println("DEBUG CheckpointPhase:" + message.get());
        }
    }

    final synchronized void setContext(Object context) throws NoSuchMethodException {
        if (this == INACTIVE) {
            return;
        }
        this.contextRef = new WeakReference<Object>(context);
        this.registerService = context.getClass().getMethod("registerService", Class.class, Object.class, Dictionary.class);
        this.unregisterService = this.registerService.getReturnType().getMethod("unregister", new Class[0]);
        if (this.multiThreadedHooks.isEmpty() && this.singleThreadedHooks.isEmpty()) {
            return;
        }
        StaticCheckpointHook unregisterStaticHooks = this.multiThreadedHooks.get(Integer.MAX_VALUE);
        if (unregisterStaticHooks == null) {
            throw new IllegalStateException("Expected max rank multi-thread hook to exist already.");
        }
        for (Map.Entry<Integer, StaticCheckpointHook> hook : this.multiThreadedHooks.entrySet()) {
            hook.getValue().register(context, unregisterStaticHooks);
        }
        for (Map.Entry<Integer, StaticCheckpointHook> hook : this.singleThreadedHooks.entrySet()) {
            hook.getValue().register(context, unregisterStaticHooks);
        }
    }

    final synchronized void blockAddHooks() {
        this.blockAddHooks = true;
    }

    public <R, T extends Throwable> R runWithCheckpointLock(WithCheckpointLock<R, T> withCheckpointLock) throws T {
        if (this.restored()) {
            CheckpointPhase.debug(() -> "Calling with no checkpoint lock: " + withCheckpointLock);
            return withCheckpointLock.call();
        }
        checkpointLock.readLock().lock();
        try {
            CheckpointPhase.debug(() -> "Calling with checkpoint lock: " + withCheckpointLock);
            R r = withCheckpointLock.call();
            return r;
        }
        finally {
            checkpointLock.readLock().unlock();
        }
    }

    static {
        THE_PHASE = INACTIVE;
        DEBUG = CheckpointPhase.debugEnabled();
        checkpointLock = new ReentrantReadWriteLock();
    }

    final class StaticCheckpointHook
    implements CheckpointHook {
        private final List<CheckpointHook> addedHooks = new ArrayList<CheckpointHook>();
        private final int rank;
        private final boolean multiThreaded;
        private volatile List<CheckpointHook> preparedHooks = Collections.emptyList();
        private boolean lockHooks = false;
        private final List<Object> registrations = new ArrayList<Object>(0);

        public StaticCheckpointHook(int rank, boolean multiThreaded) {
            this.rank = rank;
            this.multiThreaded = multiThreaded;
        }

        void addRegistration(Object serviceRegistration) {
            this.registrations.add(serviceRegistration);
        }

        void register(Object context, StaticCheckpointHook unregisterStaticHooks) {
            Hashtable<String, Constable> props = new Hashtable<String, Constable>();
            ((Dictionary)props).put(CheckpointPhase.SERVICE_RANKING, this.rank);
            ((Dictionary)props).put("io.openliberty.checkpoint.hook.multi.threaded", this.multiThreaded);
            try {
                CheckpointPhase.debug(() -> "Registering CheckpointHook service for rank :" + props.get(CheckpointPhase.SERVICE_RANKING) + (props.get("io.openliberty.checkpoint.hook.multi.threaded") == Boolean.TRUE ? " multi-threaded" : " single-threaded"));
                Object serviceRegistration = CheckpointPhase.this.registerService.invoke(context, CheckpointHook.class, this, props);
                if (unregisterStaticHooks != null) {
                    unregisterStaticHooks.addRegistration(serviceRegistration);
                } else {
                    if (this.rank != Integer.MAX_VALUE || !this.multiThreaded) {
                        throw new IllegalStateException("Missing unregisterStaticHook to add registration.");
                    }
                    this.addRegistration(serviceRegistration);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                CheckpointPhase.sneakyThrow(e.getTargetException());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addHook(CheckpointHook hook) {
            List<CheckpointHook> list = this.addedHooks;
            synchronized (list) {
                if (this.lockHooks) {
                    CheckpointPhase.debug(() -> "Did not add hook: " + hook);
                    return false;
                }
                boolean added = this.addedHooks.add(hook);
                CheckpointPhase.debug(() -> "Added hook: " + added + " - " + this.addedHooks.size());
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void prepare() {
            Iterator<CheckpointHook> iterator = this.addedHooks;
            synchronized (iterator) {
                this.preparedHooks = new ArrayList<CheckpointHook>(this.addedHooks);
                this.addedHooks.clear();
                this.lockHooks = true;
            }
            for (Object e : this.registrations) {
                try {
                    CheckpointPhase.debug(() -> "unregistering static hook in prepare: " + serviceRegistration);
                    CheckpointPhase.this.unregisterService.invoke(e, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException e2) {
                    throw new RuntimeException(e2);
                }
                catch (InvocationTargetException e3) {
                    throw new RuntimeException(e3.getTargetException());
                }
            }
            iterator = CheckpointPhase.this;
            synchronized (iterator) {
                Map<Integer, StaticCheckpointHook> map = this.multiThreaded ? CheckpointPhase.this.multiThreadedHooks : CheckpointPhase.this.singleThreadedHooks;
                map.remove(this.rank);
                CheckpointPhase.debug(() -> "removed static " + (this.multiThreaded ? "multi-threaded" : "single-threaded") + " hook rank: " + this.rank + " number hooks left: " + toRemoveMap.size());
            }
            for (CheckpointHook checkpointHook : this.preparedHooks) {
                CheckpointPhase.debug(() -> "prepare operation on static " + (this.multiThreaded ? "multi-threaded" : "single-threaded") + " rank: " + this.rank + " hook: " + hook);
                checkpointHook.prepare();
            }
            Collections.reverse(this.preparedHooks);
        }

        @Override
        public void checkpointFailed() {
            for (CheckpointHook hook : this.preparedHooks) {
                CheckpointPhase.debug(() -> "checkpointFailed operation on static hook: " + hook);
                try {
                    hook.checkpointFailed();
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public void restore() {
            for (CheckpointHook hook : this.preparedHooks) {
                CheckpointPhase.debug(() -> "restore operation on static " + (this.multiThreaded ? "multi-threaded" : "single-threaded") + " rank: " + this.rank + " hook: " + hook);
                hook.restore();
            }
            this.preparedHooks = Collections.emptyList();
        }
    }

    @FunctionalInterface
    public static interface OnRestore<T extends Throwable> {
        public void call() throws T;
    }

    @FunctionalInterface
    public static interface WithCheckpointLock<R, T extends Throwable> {
        public R call() throws T;
    }
}

