/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.rest.client40.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LibertyProxyClassLoader
extends ClassLoader {
    private final Class<?>[] classes;
    private final Set<ClassLoader> loaders = new HashSet<ClassLoader>();
    private boolean checkSystem;
    static final long serialVersionUID = -1720118530404176303L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LibertyProxyClassLoader(ClassLoader parent) {
        super(parent);
        this.classes = null;
    }

    public LibertyProxyClassLoader(ClassLoader parent, Class<?>[] cls) {
        super(parent);
        this.classes = cls;
    }

    public void addLoader(ClassLoader loader) {
        if (loader == null) {
            this.checkSystem = true;
        } else if (!this.loaders.contains(loader)) {
            this.loaders.add(loader);
        }
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class, NoClassDefFoundError.class})
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classes != null) {
            for (Class<?> c : this.classes) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
        }
        for (ClassLoader loader : this.loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            }
        }
        if (this.checkSystem) {
            try {
                return LibertyProxyClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader loader : this.loaders) {
            URL url = loader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.rest.client40.internal.LibertyProxyClassLoader", LibertyProxyClassLoader.class, null, null);
    }
}

