/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class AOProtocolItemStream
extends SIMPItemStream {
    private static TraceComponent tc = SibTr.register(AOProtocolItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 2;
    private static final String NULL = "null";
    private SIBUuid8 remoteMEId;
    private SIBUuid12 gatheringTargetDestUuid;
    private SIBUuid12 streamId;
    private DestinationHandler destinationHandler;

    public AOProtocolItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOProtocolItemStream");
        }
        this.gatheringTargetDestUuid = null;
        this.streamId = null;
        this.remoteMEId = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOProtocolItemStream", (Object)((Object)this));
        }
    }

    public AOProtocolItemStream(SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId, DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOProtocolItemStream", (Object)new Object[]{remoteMEId, gatheringTargetDestUuid, streamId, destinationHandler});
        }
        this.remoteMEId = remoteMEId;
        this.gatheringTargetDestUuid = gatheringTargetDestUuid;
        this.streamId = streamId;
        this.destinationHandler = destinationHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOProtocolItemStream", (Object)((Object)this));
        }
    }

    public final SIBUuid12 getStreamId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamId");
            SibTr.exit((TraceComponent)tc, (String)"getStreamId", (Object)this.streamId);
        }
        return this.streamId;
    }

    public final SIBUuid12 getGatheringTargetDestUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGatheringTargetDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"getGatheringTargetDestUuid", (Object)this.gatheringTargetDestUuid);
        }
        return this.gatheringTargetDestUuid;
    }

    public final SIBUuid8 getRemoteMEId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEId");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEId", (Object)this.remoteMEId);
        }
        return this.remoteMEId;
    }

    @Override
    public int getPersistentVersion() {
        return 2;
    }

    @Override
    public void getPersistentData(ObjectOutputStream dout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)dout);
        }
        try {
            dout.writeUTF(this.remoteMEId.toString());
            dout.writeUTF(this.streamId.toString());
            String id = NULL;
            if (this.gatheringTargetDestUuid != null) {
                id = this.gatheringTargetDestUuid.toString();
            }
            dout.writeUTF(id);
        }
        catch (IOException e) {
            SIErrorException e2 = new SIErrorException((Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    @Override
    public void restore(ObjectInputStream din, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{din, dataVersion});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            String id;
            this.remoteMEId = new SIBUuid8(din.readUTF());
            this.streamId = new SIBUuid12(din.readUTF());
            if (dataVersion > 1 && !(id = din.readUTF()).equals(NULL)) {
                this.gatheringTargetDestUuid = new SIBUuid12(id);
            }
        }
        catch (Exception e) {
            SIErrorException e2 = new SIErrorException((Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("remoteMEId", (Object)this.remoteMEId);
        writer.newLine();
        writer.taggedValue("streamId", (Object)this.streamId);
        writer.newLine();
        writer.taggedValue("gatheringTargetDestUuid", (Object)this.gatheringTargetDestUuid);
    }

    public void eventPostRollbackRemove(Transaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        super.eventPostRollbackRemove(transaction);
        try {
            this.unlock(this.getLockID());
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream.eventPostRollbackRemove", (String)"1:255:1.25", (Object)((Object)this));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    public DestinationHandler getDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)this.destinationHandler);
        }
        return this.destinationHandler;
    }

    @Override
    protected void checkPersistentVersionId(int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)new Integer(dataVersion));
        }
        if (dataVersion > this.getPersistentVersion()) {
            super.checkPersistentVersionId(dataVersion);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId");
        }
    }
}

