/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class JAXBAttachmentSchemaValidationHack
extends AbstractPhaseInterceptor<Message> {
    public static final JAXBAttachmentSchemaValidationHack INSTANCE = new JAXBAttachmentSchemaValidationHack();
    private static final String SAVED_DATASOURCES = JAXBAttachmentSchemaValidationHack.class.getName() + ".SAVED_DATASOURCES";
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBAttachmentSchemaValidationHack.class);
    static final long serialVersionUID = 397140049462401846L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private JAXBAttachmentSchemaValidationHack() {
        super("post-protocol");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack", "handleMessage", new Object[]{message});
        }
        if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.IN, (Message)message) && message.getAttachments() != null) {
            ArrayList<AttachmentDataSource> dss = new ArrayList<AttachmentDataSource>();
            for (Attachment at : message.getAttachments()) {
                if (!(at.getDataHandler().getDataSource() instanceof AttachmentDataSource)) continue;
                AttachmentDataSource ds = (AttachmentDataSource)at.getDataHandler().getDataSource();
                try {
                    ds.hold(message);
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adding AttachmentDataSource: " + ds.getName());
                }
                dss.add(ds);
            }
            if (!dss.isEmpty()) {
                message.put((Object)SAVED_DATASOURCES, dss);
                message.getInterceptorChain().add((Interceptor)EndingInterceptor.INSTANCE);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack", "handleMessage");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class EndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        static final EndingInterceptor INSTANCE;
        static final long serialVersionUID = 1876468706128414171L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        EndingInterceptor() {
            super("pre-logical");
        }

        public void handleMessage(Message message) throws Fault {
            List dss = CastUtils.cast((List)((List)message.get((Object)SAVED_DATASOURCES)));
            for (AttachmentDataSource ds : dss) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Releasing AttachmentDataSource: " + ds.getName());
                }
                ds.release();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.attachment.JAXBAttachmentSchemaValidationHack$EndingInterceptor", EndingInterceptor.class, null, null);
            INSTANCE = new EndingInterceptor();
        }
    }
}

