/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.FormParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInvoker.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private static final String SERVICE_LOADER_AS_CONTEXT = "org.apache.cxf.serviceloader-context";
    private static final String SERVICE_OBJECT_SCOPE = "org.apache.cxf.service.scope";
    private static final String REQUEST_SCOPE = "request";
    private static final String LAST_SERVICE_OBJECT = "org.apache.cxf.service.object.last";
    private static final String PROXY_INVOCATION_ERROR_FRAGMENT = "object is not an instance of declaring class";
    static final long serialVersionUID = 624087382983917112L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JAXRSInvoker() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Throwable.class, WebApplicationException.class})
    public Object invoke(Exchange exchange, Object request) {
        Object object;
        block20: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", new Object[]{exchange, request});
            }
            MessageContentsList responseList = this.checkExchangeForResponse(exchange);
            if (responseList != null) {
                MessageContentsList messageContentsList = responseList;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    messageContentsList = messageContentsList;
                    LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", messageContentsList);
                }
                return messageContentsList;
            }
            AsyncResponse asyncResp = (AsyncResponse)exchange.get(AsyncResponse.class);
            if (asyncResp != null) {
                Object object2;
                block19: {
                    AsyncResponseImpl asyncImpl = (AsyncResponseImpl)asyncResp;
                    asyncImpl.prepareContinuation();
                    try {
                        asyncImpl.handleTimeout();
                        object2 = this.handleAsyncResponse(exchange, asyncImpl);
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block19;
                    }
                    catch (Throwable t) {
                        Object object3 = this.handleAsyncFault(exchange, asyncImpl, t);
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            object3 = object3;
                            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object3);
                        }
                        return object3;
                    }
                    object2 = object2;
                    LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object2);
                }
                return object2;
            }
            ResourceProvider provider = this.getResourceProvider(exchange);
            Object rootInstance = null;
            Message inMessage = exchange.getInMessage();
            try {
                rootInstance = this.getServiceObject(exchange);
                Object serviceObject = this.getActualServiceObject(exchange, rootInstance);
                Object object4 = this.invoke(exchange, request, serviceObject);
                object = object4;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block20;
            }
            catch (WebApplicationException ex) {
                responseList = this.checkExchangeForResponse(exchange);
                if (responseList != null) {
                    MessageContentsList messageContentsList = responseList;
                    MessageContentsList messageContentsList2 = messageContentsList;
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        messageContentsList2 = messageContentsList2;
                        LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", messageContentsList2);
                    }
                    return messageContentsList2;
                }
                Object object5 = this.handleFault(ex, inMessage);
                Object object6 = object5;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    object6 = object6;
                    LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object6);
                }
                return object6;
            }
            finally {
                boolean suspended = this.isSuspended(exchange);
                if (suspended || exchange.isOneWay() || inMessage.get((Object)"thread.context.switched") != null) {
                    ServerProviderFactory.clearThreadLocalProxies(inMessage);
                }
                if (suspended || this.isServiceObjectRequestScope(inMessage)) {
                    this.persistRoots(exchange, rootInstance, provider);
                } else {
                    provider.releaseInstance(inMessage, rootInstance);
                }
            }
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSuspended(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "isSuspended", new Object[]{exchange});
        }
        boolean bl = exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "isSuspended", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object handleAsyncResponse(Exchange exchange, AsyncResponseImpl ar) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "handleAsyncResponse", new Object[]{exchange, ar});
        }
        Object asyncObj = ar.getResponseObject();
        if (asyncObj instanceof Throwable) {
            Throwable throwable;
            Throwable cause = throwable = (Throwable)asyncObj;
            if (throwable instanceof CompletionException) {
                cause = throwable.getCause();
            }
            Object object = this.handleAsyncFault(exchange, ar, cause != null ? cause : throwable);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "handleAsyncResponse", object);
            }
            return object;
        }
        this.setResponseContentTypeIfNeeded(exchange.getInMessage(), asyncObj);
        MessageContentsList messageContentsList = new MessageContentsList(new Object[]{asyncObj});
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContentsList = messageContentsList;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "handleAsyncResponse", messageContentsList);
        }
        return messageContentsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Fault.class})
    private Object handleAsyncFault(Exchange exchange, AsyncResponseImpl ar, Throwable t) {
        Object object;
        block5: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "handleAsyncFault", new Object[]{exchange, ar, t});
            }
            try {
                object = this.handleFault(new Fault(t), exchange.getInMessage(), null, null);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
            }
            catch (Fault ex) {
                ar.setUnmappedThrowable(ex.getCause() == null ? ex : ex.getCause());
                if (this.isSuspended(exchange)) {
                    ar.reset();
                    exchange.getInMessage().getInterceptorChain().unpause();
                }
                MessageContentsList messageContentsList = new MessageContentsList(new Object[]{Response.serverError().build()});
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    messageContentsList = messageContentsList;
                    LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "handleAsyncFault", messageContentsList);
                }
                return messageContentsList;
            }
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "handleAsyncFault", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void persistRoots(Exchange exchange, Object rootInstance, Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "persistRoots", new Object[]{exchange, rootInstance, provider});
        }
        exchange.put((Object)"service.root.instance", rootInstance);
        exchange.put((Object)"service.root.provider", provider);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "persistRoots");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={Fault.class, IOException.class, WebApplicationException.class})
    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        ApplicationInfo appProvider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", new Object[]{exchange, request, resourceObject});
        }
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Message inMessage = exchange.getInMessage();
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(inMessage);
        cri.injectContexts(resourceObject, ori, inMessage);
        if (cri.isRoot() && (appProvider = providerFactory.getApplicationProvider()) != null) {
            InjectionUtils.injectContexts(appProvider.getProvider(), appProvider, inMessage);
        }
        Method methodToInvoke = this.getMethodToInvoke(cri, ori, resourceObject);
        MessageContentsList params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)((List)request));
        } else if (request != null) {
            params = new MessageContentsList(new Object[]{request});
        }
        params = this.reprocessFormParams(methodToInvoke, (List<Object>)params, inMessage);
        Object result = null;
        ClassLoaderUtils.ClassLoaderHolder contextLoader = null;
        AsyncResponseImpl asyncResponse = null;
        try {
            if (this.setServiceLoaderAsContextLoader(inMessage)) {
                contextLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)resourceObject.getClass().getClassLoader());
            }
            if (!ori.isSubResourceLocator()) {
                asyncResponse = (AsyncResponseImpl)inMessage.get(AsyncResponse.class);
            }
            result = this.invoke(exchange, resourceObject, methodToInvoke, (List)params);
            if (asyncResponse == null && !ori.isSubResourceLocator()) {
                asyncResponse = this.checkFutureResponse(inMessage, JAXRSInvoker.checkResultObject(result));
            }
            if (asyncResponse != null) {
                if (!asyncResponse.suspendContinuationIfNeeded()) {
                    result = this.handleAsyncResponse(exchange, asyncResponse);
                } else {
                    providerFactory.clearThreadLocalProxies();
                }
            }
        }
        catch (Fault ex) {
            Object faultResponse = asyncResponse != null ? this.handleAsyncFault(exchange, asyncResponse, ex.getCause() == null ? ex : ex.getCause()) : this.handleFault(ex, inMessage, cri, methodToInvoke);
            Object object = faultResponse;
            Object object2 = object;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object2 = object2;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object2);
            }
            return object2;
        }
        finally {
            exchange.put((Object)LAST_SERVICE_OBJECT, resourceObject);
            if (contextLoader != null) {
                contextLoader.reset();
            }
        }
        ClassResourceInfo subCri = null;
        if (ori.isSubResourceLocator()) {
            Object object;
            block34: {
                OperationResourceInfo subOri;
                MultivaluedMap<String, String> values;
                block32: {
                    MessageContentsList messageContentsList;
                    block33: {
                        Class<?> subResponseType;
                        values = this.getTemplateValues(inMessage);
                        String subResourcePath = (String)values.getFirst((Object)"FINAL_MATCH_GROUP");
                        String httpMethod = (String)inMessage.get((Object)"org.apache.cxf.request.method");
                        String contentType = (String)inMessage.get((Object)"Content-Type");
                        if (contentType == null) {
                            contentType = "*/*";
                        }
                        List acceptContentType = (List)exchange.get((Object)"Accept");
                        if ((result = JAXRSInvoker.checkSubResultObject(result, subResourcePath)).getClass() == Class.class) {
                            ResourceContextImpl rc = new ResourceContextImpl(inMessage, ori);
                            result = rc.getResource((Class)result);
                            subResponseType = InjectionUtils.getActualType(methodToInvoke.getGenericReturnType());
                        } else {
                            subResponseType = methodToInvoke.getReturnType();
                        }
                        subCri = cri.getSubResource(subResponseType, ClassHelper.getRealClass((Bus)exchange.getBus(), (Object)result), result);
                        if (subCri == null) {
                            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, new Object[]{subResourcePath});
                            LOG.severe(errorM.toString());
                            throw ExceptionUtils.toNotFoundException(null, null);
                        }
                        subOri = JAXRSUtils.findTargetMethod(Collections.singletonMap(subCri, values), inMessage, httpMethod, values, contentType, acceptContentType);
                        exchange.put(OperationResourceInfo.class, (Object)subOri);
                        inMessage.put((Object)"jaxrs.template.parameters", values);
                        inMessage.put((Object)"jaxrs.template.uri", (Object)JAXRSUtils.getUriTemplate(inMessage, subCri, ori, subOri));
                        if (subOri.isSubResourceLocator() || !JAXRSUtils.runContainerRequestFilters(providerFactory, inMessage, false, subOri.getNameBindings())) break block32;
                        messageContentsList = new MessageContentsList(new Object[]{exchange.get(Response.class)});
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block33;
                        messageContentsList = messageContentsList;
                        LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", messageContentsList);
                    }
                    return messageContentsList;
                }
                try {
                    List<Object> newParams = JAXRSUtils.processParameters(subOri, values, inMessage);
                    inMessage.setContent(List.class, newParams);
                    object = this.invoke(exchange, newParams, result);
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block34;
                }
                catch (IOException ex) {
                    Response resp = JAXRSUtils.convertFaultToResponse(ex, inMessage);
                    if (resp == null) {
                        resp = JAXRSUtils.convertFaultToResponse(ex, inMessage);
                    }
                    MessageContentsList messageContentsList = new MessageContentsList(new Object[]{resp});
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        messageContentsList = messageContentsList;
                        LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", messageContentsList);
                    }
                    return messageContentsList;
                }
                catch (WebApplicationException ex) {
                    Response excResponse = JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), (String)inMessage.get((Object)"org.apache.cxf.request.method")) ? JAXRSUtils.createResponse(Collections.singletonList(subCri), null, null, 200, true) : JAXRSUtils.convertFaultToResponse(ex, inMessage);
                    MessageContentsList messageContentsList = new MessageContentsList(new Object[]{excResponse});
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        messageContentsList = messageContentsList;
                        LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", messageContentsList);
                    }
                    return messageContentsList;
                }
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object);
            }
            return object;
        }
        this.setResponseContentTypeIfNeeded(inMessage, result);
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "invoke", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<Object> reprocessFormParams(Method method, List<Object> origParams, Message m) {
        int i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "reprocessFormParams", new Object[]{method, origParams, m});
        }
        Form form = null;
        boolean hasFormParamAnnotations = false;
        Object[] newValues = new Object[origParams.size()];
        Parameter[] methodParams = method.getParameters();
        for (i = 0; i < methodParams.length; ++i) {
            if (Form.class.equals(methodParams[i].getType())) {
                form = (Form)origParams.get(i);
            }
            if (methodParams[i].getAnnotation(FormParam.class) != null) {
                hasFormParamAnnotations = true;
                continue;
            }
            newValues[i] = origParams.get(i);
        }
        if (!hasFormParamAnnotations || form == null) {
            List<Object> list = origParams;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                list = list;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "reprocessFormParams", list);
            }
            return list;
        }
        for (i = 0; i < newValues.length; ++i) {
            if (newValues[i] != null) continue;
            String formFieldName = methodParams[i].getAnnotation(FormParam.class).value();
            List values = (List)form.asMap().get((Object)formFieldName);
            newValues[i] = InjectionUtils.createParameterObject(values, methodParams[i].getType(), methodParams[i].getParameterizedType(), methodParams[i].getAnnotations(), (String)origParams.get(i), false, ParameterType.FORM, m);
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.log(Level.FINEST, "replacing @FormParam value of {0} with {1}", new Object[]{origParams.get(i), newValues[i]});
        }
        List<Object> list = Arrays.asList(newValues);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "reprocessFormParams", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected AsyncResponseImpl checkFutureResponse(Message inMessage, Object result) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "checkFutureResponse", new Object[]{inMessage, result});
        }
        if (result instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)result;
            AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
            stage.whenComplete((v, t) -> {
                if (t instanceof CancellationException) {
                    asyncResponse.cancel();
                } else {
                    asyncResponse.resume(v != null ? v : t);
                }
            });
            AsyncResponseImpl asyncResponseImpl = asyncResponse;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                asyncResponseImpl = asyncResponseImpl;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "checkFutureResponse", asyncResponseImpl);
            }
            return asyncResponseImpl;
        }
        AsyncResponseImpl asyncResponseImpl = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            asyncResponseImpl = asyncResponseImpl;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "checkFutureResponse", asyncResponseImpl);
        }
        return asyncResponseImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Method getMethodToInvoke(ClassResourceInfo cri, OperationResourceInfo ori, Object resourceObject) {
        Method methodToInvoke;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "getMethodToInvoke", new Object[]{cri, ori, resourceObject});
        }
        Method resourceMethod = cri.getMethodDispatcher().getMethod(ori);
        if (Proxy.class.isInstance(resourceObject)) {
            methodToInvoke = cri.getMethodDispatcher().getProxyMethod(resourceMethod);
            if (methodToInvoke == null) {
                methodToInvoke = InjectionUtils.checkProxy(resourceMethod, resourceObject);
                cri.getMethodDispatcher().addProxyMethod(resourceMethod, methodToInvoke);
            }
        } else {
            methodToInvoke = resourceMethod;
        }
        Method method = methodToInvoke;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            method = method;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getMethodToInvoke", method);
        }
        return method;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private MessageContentsList checkExchangeForResponse(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "checkExchangeForResponse", new Object[]{exchange});
        }
        Response r = (Response)exchange.get(Response.class);
        if (r != null) {
            JAXRSUtils.setMessageContentType(exchange.getInMessage(), r);
            MessageContentsList messageContentsList = new MessageContentsList(new Object[]{r});
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                messageContentsList = messageContentsList;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "checkExchangeForResponse", messageContentsList);
            }
            return messageContentsList;
        }
        MessageContentsList messageContentsList = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContentsList = messageContentsList;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "checkExchangeForResponse", messageContentsList);
        }
        return messageContentsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setResponseContentTypeIfNeeded(Message inMessage, Object response) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "setResponseContentTypeIfNeeded", new Object[]{inMessage, response});
        }
        if (response instanceof Response) {
            JAXRSUtils.setMessageContentType(inMessage, (Response)response);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "setResponseContentTypeIfNeeded");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object handleFault(Throwable ex, Message inMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "handleFault", new Object[]{ex, inMessage});
        }
        Object object = this.handleFault(new Fault(ex), inMessage, null, null);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "handleFault", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object handleFault(Fault ex, Message inMessage, ClassResourceInfo cri, Method methodToInvoke) {
        Response excResponse;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "handleFault", new Object[]{ex, inMessage, cri, methodToInvoke});
        }
        String errorMessage = ex.getMessage();
        if (errorMessage != null && cri != null && errorMessage.contains(PROXY_INVOCATION_ERROR_FRAGMENT)) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("PROXY_INVOCATION_FAILURE", BUNDLE, new Object[]{methodToInvoke, cri.getServiceClass().getName()});
            LOG.severe(errorM.toString());
        }
        if ((excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause() == null ? ex : ex.getCause(), inMessage)) == null) {
            inMessage.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)ExceptionUtils.propogateException(inMessage));
            throw ex;
        }
        MessageContentsList messageContentsList = new MessageContentsList(new Object[]{excResponse});
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            messageContentsList = messageContentsList;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "handleFault", messageContentsList);
        }
        return messageContentsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected MultivaluedMap<String, String> getTemplateValues(Message msg) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "getTemplateValues", new Object[]{msg});
        }
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        MultivaluedMap oldValues = (MultivaluedMap)msg.get((Object)"jaxrs.template.parameters");
        if (oldValues != null) {
            values.putAll((Map)oldValues);
        }
        MetadataMap<String, String> metadataMap = values;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            metadataMap = metadataMap;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getTemplateValues", metadataMap);
        }
        return metadataMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean setServiceLoaderAsContextLoader(Message inMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "setServiceLoaderAsContextLoader", new Object[]{inMessage});
        }
        Object en = inMessage.getContextualProperty(SERVICE_LOADER_AS_CONTEXT);
        boolean bl = Boolean.TRUE.equals(en) || "true".equals(en);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "setServiceLoaderAsContextLoader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isServiceObjectRequestScope(Message inMessage) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "isServiceObjectRequestScope", new Object[]{inMessage});
        }
        Object scope = inMessage.getContextualProperty(SERVICE_OBJECT_SCOPE);
        boolean bl = REQUEST_SCOPE.equals(scope);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "isServiceObjectRequestScope", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ResourceProvider getResourceProvider(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "getResourceProvider", new Object[]{exchange});
        }
        Object provider = exchange.remove((Object)"service.root.provider");
        if (provider == null) {
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
            ClassResourceInfo cri = ori.getClassResourceInfo();
            ResourceProvider resourceProvider = cri.getResourceProvider();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                resourceProvider = resourceProvider;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getResourceProvider", resourceProvider);
            }
            return resourceProvider;
        }
        ResourceProvider resourceProvider = (ResourceProvider)provider;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            resourceProvider = resourceProvider;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getResourceProvider", resourceProvider);
        }
        return resourceProvider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Object getServiceObject(Exchange exchange) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "getServiceObject", new Object[]{exchange});
        }
        Object root = exchange.remove((Object)"service.root.instance");
        if (root != null) {
            Object object = root;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getServiceObject", object);
            }
            return object;
        }
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Object object = cri.getResourceProvider().getInstance(exchange.getInMessage());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getServiceObject", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object getActualServiceObject(Exchange exchange, Object rootInstance) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "getActualServiceObject", new Object[]{exchange, rootInstance});
        }
        Object last = exchange.get((Object)LAST_SERVICE_OBJECT);
        Object object = last != null ? last : rootInstance;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "getActualServiceObject", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object checkResultObject(Object result) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "checkResultObject", new Object[]{result});
        }
        if (result != null) {
            if (result instanceof MessageContentsList) {
                result = ((MessageContentsList)result).get(0);
            } else if (result instanceof List) {
                result = ((List)result).get(0);
            } else if (result.getClass().isArray()) {
                result = ((Object[])result)[0];
            }
        }
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "checkResultObject", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object checkSubResultObject(Object result, String subResourcePath) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.JAXRSInvoker", "checkSubResultObject", new Object[]{result, subResourcePath});
        }
        result = JAXRSInvoker.checkResultObject(result);
        if (result == null) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NULL_SUBRESOURCE", BUNDLE, new Object[]{subResourcePath});
            LOG.info(errorM.toString());
            throw ExceptionUtils.toNotFoundException(null, null);
        }
        Object object = result;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.JAXRSInvoker", "checkSubResultObject", object);
        }
        return object;
    }
}

