/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.DeserializationObjectInputStream;
import com.ibm.ws.sib.comms.client.AsyncCallbackSynchronizer;
import com.ibm.ws.sib.comms.client.BaseSIXAResourceProxy;
import com.ibm.ws.sib.comms.client.BifurcatedConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.BrowserSessionProxy;
import com.ibm.ws.sib.comms.client.CatConnectionListenerGroup;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.LocalTransactionProxy;
import com.ibm.ws.sib.comms.client.MSSIXAResourceProvidingConnectionProxy;
import com.ibm.ws.sib.comms.client.OptimizedSIXAResourceProxy;
import com.ibm.ws.sib.comms.client.OptimizedUncoordinatedTransactionProxy;
import com.ibm.ws.sib.comms.client.OrderingContextProxy;
import com.ibm.ws.sib.comms.client.ProducerSessionProxy;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.comms.client.ProxyReceiveListener;
import com.ibm.ws.sib.comms.client.SIXAResourceProxy;
import com.ibm.ws.sib.comms.client.SuspendableXAResource;
import com.ibm.ws.sib.comms.client.Transaction;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroupFactory;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsLightTrace;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.comms.common.DestinationConfigurationImpl;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SICommandInvocationFailedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConnectionProxy
extends Proxy
implements SICoreConnection {
    private static String CLASS_NAME;
    private static final TraceComponent tc;
    private static final TraceNLS nls;
    public static final String $sccsid = "@(#) 1.217 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ConnectionProxy.java, SIB.comms, WASX.SIB, uu1215.01 11/09/15 07:55:15 [4/12/12 22:14:06]";
    private static final boolean defaultStrictRedeliveryOrdering;
    private volatile boolean strictRedeliveryOrdering;
    private final Object generalLock = new Object();
    protected ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private static final int HIGH_QUEUE_BYTES;
    private byte[] initialUniqueId = null;
    private final List<Short> orderContextPool = Collections.synchronizedList(new ArrayList());
    private String meUuid = null;
    private String resolvedUserId = null;
    private String meName = null;
    private static final boolean exchangeTransactedSends;
    private static final boolean exchangeExpressSends;
    private final boolean requiresOptimizedTransactions;
    private final HashMap<Short, ConsumerSessionProxy> consumerSessions = new HashMap();
    private List<DataSlice> pendingMessageSlices = null;
    private final Object pendingMessageSliceLock = new Object();
    private final AsyncCallbackSynchronizer asyncCallbackSynchronizer = new AsyncCallbackSynchronizer();
    private final ConnectionProxy parent;
    private static final int MAX_CACHED_CLOSE_CONNECTIONS = 2;
    private final Set<ConnectionProxy> cachedCloneConnections = new HashSet<ConnectionProxy>();

    public ConnectionProxy(Conversation con) {
        this(con, null);
    }

    public ConnectionProxy(Conversation con, ConnectionProxy parent) {
        super(con, null);
        HandshakeProperties handshakeProperties;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("con=" + con + ", parent=" + parent));
        }
        this.requiresOptimizedTransactions = (handshakeProperties = this.getConversation().getHandshakeProperties()).getFapLevel() >= 5 && (handshakeProperties.getCapabilites() & 0x40) != 0;
        this.parent = parent;
        this.strictRedeliveryOrdering = defaultStrictRedeliveryOrdering;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public BrowserSession createBrowserSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowserSession", (Object)new Object[]{destAddress, destType, criteria, alternateUser});
        }
        BrowserSession browserSession = this._createBrowserSession(destAddress, destType, criteria, alternateUser, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBrowserSession", (Object)browserSession);
        }
        return browserSession;
    }

    public BrowserSession createBrowserSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, String alternateUser, boolean allowMessageGathering) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBrowserSession", (Object)new Object[]{destAddress, destType, criteria, alternateUser, allowMessageGathering});
        }
        if (allowMessageGathering) {
            HandshakeProperties props = this.getConversation().getHandshakeProperties();
            CommsUtils.checkFapLevel(props, (short)9);
        }
        BrowserSession browserSession = this._createBrowserSession(destAddress, destType, criteria, alternateUser, allowMessageGathering);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBrowserSession", (Object)browserSession);
        }
        return browserSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserSession _createBrowserSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, String alternateUser, boolean allowMessageGathering) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_createBrowserSession", (Object)new Object[]{destAddress, destType, criteria, alternateUser, allowMessageGathering});
        }
        BrowserSessionProxy browserSession = null;
        Object object = this.generalLock;
        synchronized (object) {
            this.closeLock.readLock().lock();
            try {
                boolean fap9OrAbove;
                this.checkAlreadyClosed();
                ProxyQueueConversationGroup pqcg = this.getProxyQueueConversationGroup();
                BrowserProxyQueue proxyQueue = pqcg.createBrowserProxyQueue();
                CommsByteBuffer request = this.getCommsByteBuffer();
                request.putShort(this.getConnectionObjectID());
                if (proxyQueue != null) {
                    request.putShort(proxyQueue.getId());
                } else {
                    request.putShort(0);
                }
                request.putInt(HIGH_QUEUE_BYTES);
                if (destType == null) {
                    request.putShort((short)-1);
                } else {
                    request.putShort((short)destType.toInt());
                }
                boolean bl = fap9OrAbove = this.getConversation().getHandshakeProperties().getFapLevel() >= 9;
                if (fap9OrAbove) {
                    short browserFlags = 0;
                    if (allowMessageGathering) {
                        browserFlags = (short)(browserFlags | 1);
                    }
                    request.putShort(browserFlags);
                }
                request.putSIDestinationAddress(destAddress, this.getConversation().getHandshakeProperties().getFapLevel());
                request.putSelectionCriteria(criteria);
                request.putString(alternateUser);
                CommsByteBuffer reply = this.jfapExchange(request, 95, 7, true);
                try {
                    short err = 0;
                    try {
                        err = reply.getCommandCompletionCode(223);
                        if (err != 0) {
                            this.checkFor_SIConnectionUnavailableException(reply, err);
                            this.checkFor_SIConnectionDroppedException(reply, err);
                            this.checkFor_SIResourceException(reply, err);
                            this.checkFor_SIConnectionLostException(reply, err);
                            this.checkFor_SILimitExceededException(reply, err);
                            this.checkFor_SINotAuthorizedException(reply, err);
                            this.checkFor_SIIncorrectCallException(reply, err);
                            this.checkFor_SISelectorSyntaxException(reply, err);
                            this.checkFor_SIDiscriminatorSyntaxException(reply, err);
                            this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                            this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                            this.checkFor_SIErrorException(reply, err);
                            this.defaultChecker(reply, err);
                        }
                    }
                    finally {
                        if (err != 0) {
                            ClientConversationState convState = (ClientConversationState)this.getConversation().getAttachment();
                            convState.getProxyQueueConversationGroup().bury(proxyQueue);
                        }
                    }
                    browserSession = new BrowserSessionProxy(this.getConversation(), this, reply, proxyQueue, destAddress);
                    proxyQueue.setBrowserSession(browserSession);
                }
                finally {
                    reply.release();
                }
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_createBrowserSession", (Object)browserSession);
        }
        return browserSession;
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddr, DestinationType destType, OrderingContext extendedMessageOrderingContext, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SITemporaryDestinationNotFoundException {
        return this.createProducerSession(destAddr, null, destType, extendedMessageOrderingContext, alternateUser);
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddress, String discriminator, DestinationType destType, OrderingContext orderContext, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createProducerSession", (Object)new Object[]{destAddress, discriminator, destType, orderContext, alternateUser});
        }
        ProducerSession ps = this._createProducerSession(destAddress, discriminator, destType, orderContext, alternateUser, false, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createProducerSession", (Object)ps);
        }
        return ps;
    }

    public ProducerSession createProducerSession(SIDestinationAddress destAddress, String discriminator, DestinationType destType, OrderingContext orderContext, String alternateUser, boolean bindToQueuePoint, boolean preferLocalQueuePoint) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createProducerSession", (Object)new Object[]{destAddress, discriminator, destType, orderContext, alternateUser, bindToQueuePoint, preferLocalQueuePoint});
        }
        if (bindToQueuePoint || !preferLocalQueuePoint) {
            HandshakeProperties props = this.getConversation().getHandshakeProperties();
            CommsUtils.checkFapLevel(props, (short)9);
        }
        ProducerSession ps = this._createProducerSession(destAddress, discriminator, destType, orderContext, alternateUser, bindToQueuePoint, preferLocalQueuePoint);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createProducerSession", (Object)ps);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProducerSession _createProducerSession(SIDestinationAddress destAddress, String discriminator, DestinationType destType, OrderingContext orderContext, String alternateUser, boolean bindToQueuePoint, boolean preferLocalQueuePoint) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_createProducerSession", (Object)new Object[]{destAddress, discriminator, destType, orderContext, alternateUser, bindToQueuePoint, preferLocalQueuePoint});
        }
        ProducerSessionProxy ps = null;
        OrderingContextProxy oc = null;
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    boolean fap9OrAbove;
                    this.checkAlreadyClosed();
                    if (orderContext != null) {
                        oc = (OrderingContextProxy)orderContext;
                        oc.incrementUseCount();
                    }
                    CommsByteBuffer request = this.getCommsByteBuffer();
                    request.putShort(this.getConnectionObjectID());
                    if (orderContext != null) {
                        oc = (OrderingContextProxy)orderContext;
                        request.putShort(oc.getId());
                    } else {
                        request.putShort((short)0);
                    }
                    if (destType == null) {
                        request.putShort((short)-1);
                    } else {
                        request.putShort(destType.toInt());
                    }
                    boolean bl = fap9OrAbove = this.getConversation().getHandshakeProperties().getFapLevel() >= 9;
                    if (fap9OrAbove) {
                        short producerFlags = 0;
                        if (bindToQueuePoint) {
                            producerFlags = (short)(producerFlags | 1);
                        }
                        if (preferLocalQueuePoint) {
                            producerFlags = (short)(producerFlags | 2);
                        }
                        request.putShort(producerFlags);
                    }
                    request.putSIDestinationAddress(destAddress, this.getConversation().getHandshakeProperties().getFapLevel());
                    request.putString(discriminator);
                    request.putString(alternateUser);
                    CommsByteBuffer reply = this.jfapExchange(request, 72, 7, true);
                    try {
                        short err = reply.getCommandCompletionCode(200);
                        if (err != 0) {
                            if (oc != null) {
                                oc.decrementUseCount();
                            }
                            this.checkFor_SIConnectionUnavailableException(reply, err);
                            this.checkFor_SIConnectionDroppedException(reply, err);
                            this.checkFor_SIResourceException(reply, err);
                            this.checkFor_SIConnectionLostException(reply, err);
                            this.checkFor_SILimitExceededException(reply, err);
                            this.checkFor_SINotAuthorizedException(reply, err);
                            this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                            this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                            this.checkFor_SIIncorrectCallException(reply, err);
                            this.checkFor_SIDiscriminatorSyntaxException(reply, err);
                            this.checkFor_SIErrorException(reply, err);
                            this.defaultChecker(reply, err);
                        }
                        ps = new ProducerSessionProxy(this.getConversation(), this, oc, reply, destAddress, destType);
                    }
                    finally {
                        reply.release();
                    }
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_createProducerSession", ps);
        }
        return ps;
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)new Object[]{destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser});
        }
        ConsumerSession sess = this._createConsumerSession(null, destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, true, false, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)sess);
        }
        return sess;
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)new Object[]{destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts});
        }
        if (!ignoreInitialIndoubts) {
            HandshakeProperties props = this.getConversation().getHandshakeProperties();
            CommsUtils.checkFapLevel(props, (short)5);
        }
        ConsumerSession sess = this._createConsumerSession(null, destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, false, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)sess);
        }
        return sess;
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)new Object[]{destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering});
        }
        if (allowMessageGathering) {
            HandshakeProperties props = this.getConversation().getHandshakeProperties();
            CommsUtils.checkFapLevel(props, (short)9);
        }
        ConsumerSession sess = this._createConsumerSession(null, destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)sess);
        }
        return sess;
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering, Map<String, String> messageControlProperties) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)new Object[]{destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties});
        }
        if (messageControlProperties != null && !messageControlProperties.isEmpty()) {
            HandshakeProperties props = this.getConversation().getHandshakeProperties();
            CommsUtils.checkFapLevel(props, (short)9);
        }
        ConsumerSession sess = this._createConsumerSession(null, destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)sess);
        }
        return sess;
    }

    public ConsumerSession createSharedConsumerSession(String subscriptionName, SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean supportsMultipleConsumers, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering, Map<String, String> messageControlProperties) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        HandshakeProperties props;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSharedConsumerSession", (Object)new Object[]{subscriptionName, destAddress, destType, criteria, reliability, enableReadAhead, supportsMultipleConsumers, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties});
        }
        if (messageControlProperties != null && !messageControlProperties.isEmpty()) {
            props = this.getConversation().getHandshakeProperties();
            CommsUtils.checkFapLevel(props, (short)9);
        }
        props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)20);
        ConsumerSession sess = this._createConsumerSession(subscriptionName, destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumerSession", (Object)sess);
        }
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerSession _createConsumerSession(String subscriptionName, SIDestinationAddress destAddress, DestinationType destType, SelectionCriteria criteria, Reliability reliability, boolean enableReadAhead, boolean nolocal, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser, boolean ignoreInitialIndoubts, boolean allowMessageGathering, Map<String, String> messageControlProperties) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_createConsumerSession", (Object)new Object[]{subscriptionName, destAddress, destType, criteria, reliability, enableReadAhead, nolocal, unrecoverableReliability, bifurcatable, alternateUser, ignoreInitialIndoubts, allowMessageGathering, messageControlProperties});
        }
        Proxy cs = null;
        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
        if (bifurcatable) {
            enableReadAhead = false;
        }
        HashMap<Short, ConsumerSessionProxy> hashMap = this.generalLock;
        synchronized (hashMap) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    boolean fap20OrAbove;
                    boolean fap9OrAbove;
                    boolean fap5OrAbove;
                    this.checkAlreadyClosed();
                    AsynchConsumerProxyQueue proxyQueue = null;
                    ProxyQueueConversationGroup pqcg = null;
                    if (enableReadAhead) {
                        pqcg = this.getProxyQueueConversationGroup();
                        proxyQueue = pqcg.createReadAheadProxyQueue(unrecoverableReliability);
                    }
                    CommsByteBuffer request = this.getCommsByteBuffer();
                    request.putShort(this.getConnectionObjectID());
                    if (proxyQueue != null) {
                        request.putShort(proxyQueue.getId());
                    } else {
                        request.putShort(0);
                    }
                    short consumerFlags = 0;
                    if (enableReadAhead) {
                        consumerFlags = (short)(consumerFlags | 1);
                    }
                    if (nolocal) {
                        consumerFlags = (short)(consumerFlags | 2);
                    }
                    if (bifurcatable) {
                        consumerFlags = (short)(consumerFlags | 0x40);
                    }
                    consumerFlags = (short)(consumerFlags | 8);
                    boolean bl = fap5OrAbove = this.getConversation().getHandshakeProperties().getFapLevel() >= 5;
                    if (ignoreInitialIndoubts && fap5OrAbove) {
                        consumerFlags = (short)(consumerFlags | 0x80);
                    }
                    boolean bl2 = fap9OrAbove = this.getConversation().getHandshakeProperties().getFapLevel() >= 9;
                    if (allowMessageGathering && fap9OrAbove) {
                        consumerFlags = (short)(consumerFlags | 0x100);
                    }
                    boolean bl3 = fap20OrAbove = this.getConversation().getHandshakeProperties().getFapLevel() >= 20;
                    if (null != subscriptionName && fap20OrAbove) {
                        consumerFlags = (short)(consumerFlags | 4);
                    }
                    request.putShort(consumerFlags);
                    if (reliability != null) {
                        request.putShort(reliability.toInt());
                    } else {
                        request.putShort(-1);
                    }
                    request.putInt(HIGH_QUEUE_BYTES);
                    if (destType == null) {
                        request.putShort((short)-1);
                    } else {
                        request.putShort(destType.toInt());
                    }
                    if (unrecoverableReliability == null) {
                        unrecoverableReliability = Reliability.NONE;
                    }
                    request.putShort(unrecoverableReliability.toInt());
                    request.putSIDestinationAddress(destAddress, this.getConversation().getHandshakeProperties().getFapLevel());
                    if (null != subscriptionName && fap20OrAbove) {
                        request.putString(subscriptionName);
                    }
                    request.putSelectionCriteria(criteria);
                    request.putString(alternateUser);
                    if (fap9OrAbove) {
                        request.putMap(messageControlProperties);
                    }
                    CommsByteBuffer reply = this.jfapExchange(request, 77, 7, true);
                    try {
                        short err = 0;
                        try {
                            err = reply.getCommandCompletionCode(205);
                            if (err != 0) {
                                this.checkFor_SIConnectionUnavailableException(reply, err);
                                this.checkFor_SIConnectionDroppedException(reply, err);
                                this.checkFor_SIResourceException(reply, err);
                                this.checkFor_SIConnectionLostException(reply, err);
                                this.checkFor_SILimitExceededException(reply, err);
                                this.checkFor_SINotAuthorizedException(reply, err);
                                this.checkFor_SIIncorrectCallException(reply, err);
                                this.checkFor_SIDestinationLockedException(reply, err);
                                this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                                this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                                this.checkFor_SISelectorSyntaxException(reply, err);
                                this.checkFor_SIDiscriminatorSyntaxException(reply, err);
                                this.checkFor_SIErrorException(reply, err);
                                this.defaultChecker(reply, err);
                            }
                        }
                        finally {
                            if (err != 0 && proxyQueue != null) {
                                state.getProxyQueueConversationGroup().bury(proxyQueue);
                            }
                        }
                        long messageProcessorId = reply.getLong();
                        short flags = reply.getShort();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message Processor Id", (Object)("" + messageProcessorId));
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Consumer flags", (Object)("" + flags));
                        }
                        if ((flags & 0x10) != 0) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"The server told us to go multicast even though we did not ask for it");
                            }
                            throw new SIErrorException(nls.getFormattedMessage("SERVER_REQUESTED_MULTICAST_SICO1026", null, null));
                        }
                        cs = new ConsumerSessionProxy(this.getConversation(), this, reply, proxyQueue, unrecoverableReliability, destAddress, destType, messageProcessorId);
                    }
                    finally {
                        reply.release();
                    }
                    if (proxyQueue != null) {
                        proxyQueue.setConsumerSession((ConsumerSessionProxy)cs);
                    }
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        hashMap = this.consumerSessions;
        synchronized (hashMap) {
            this.consumerSessions.put(cs.getProxyID(), (ConsumerSessionProxy)cs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_createConsumerSession", (Object)cs);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BifurcatedConsumerSession createBifurcatedConsumerSession(long id) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createBifurcatedConsumerSession", (Object)("" + id));
        }
        BifurcatedConsumerSessionProxy bcs = null;
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    this.checkAlreadyClosed();
                    CommsByteBuffer request = this.getCommsByteBuffer();
                    request.putShort(this.getConnectionObjectID());
                    request.putLong(id);
                    CommsByteBuffer reply = this.jfapExchange(request, 103, 7, true);
                    try {
                        short err = reply.getCommandCompletionCode(232);
                        if (err != 0) {
                            this.checkFor_SISessionUnavailableException(reply, err);
                            this.checkFor_SISessionDroppedException(reply, err);
                            this.checkFor_SIConnectionUnavailableException(reply, err);
                            this.checkFor_SIConnectionDroppedException(reply, err);
                            this.checkFor_SIResourceException(reply, err);
                            this.checkFor_SIConnectionLostException(reply, err);
                            this.checkFor_SILimitExceededException(reply, err);
                            this.checkFor_SINotAuthorizedException(reply, err);
                            this.checkFor_SIIncorrectCallException(reply, err);
                            this.checkFor_SIErrorException(reply, err);
                            this.defaultChecker(reply, err);
                        }
                        bcs = new BifurcatedConsumerSessionProxy(this.getConversation(), this, reply);
                    }
                    finally {
                        reply.release();
                    }
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createBifurcatedConsumerSession", bcs);
        }
        return bcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destAddr, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException, SIDurableSubscriptionAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDurableSubscription", (Object)new Object[]{subscriptionName, durableSubscriptionHome, destAddr, criteria, "" + supportsMultipleConsumers, "" + nolocal, alternateUser});
        }
        Object object = this.generalLock;
        synchronized (object) {
            block16: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.checkAlreadyClosed();
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putShort(this.getConnectionObjectID());
                        int consumerFlags = 0;
                        if (nolocal) {
                            consumerFlags |= 2;
                        }
                        if (supportsMultipleConsumers) {
                            consumerFlags |= 4;
                        }
                        request.putShort(consumerFlags);
                        request.putSIDestinationAddress(destAddr, this.getConversation().getHandshakeProperties().getFapLevel());
                        request.putString(subscriptionName);
                        request.putString(durableSubscriptionHome);
                        request.putSelectionCriteria(criteria);
                        request.putString(alternateUser);
                        CommsByteBuffer reply = this.jfapExchange(request, 67, 7, true);
                        try {
                            short err = reply.getCommandCompletionCode(195);
                            if (err != 0) {
                                this.checkFor_SIConnectionUnavailableException(reply, err);
                                this.checkFor_SIConnectionDroppedException(reply, err);
                                this.checkFor_SIResourceException(reply, err);
                                this.checkFor_SIConnectionLostException(reply, err);
                                this.checkFor_SILimitExceededException(reply, err);
                                this.checkFor_SINotAuthorizedException(reply, err);
                                this.checkFor_SIIncorrectCallException(reply, err);
                                this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                                this.checkFor_SIDurableSubscriptionAlreadyExistsException(reply, err);
                                this.checkFor_SISelectorSyntaxException(reply, err);
                                this.checkFor_SIDiscriminatorSyntaxException(reply, err);
                                this.checkFor_SIErrorException(reply, err);
                                this.defaultChecker(reply, err);
                            }
                        }
                        finally {
                            reply.release();
                        }
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Interrupted", (Object)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDurableSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerSession createConsumerSessionForDurableSubscription(String subscriptionName, String durableSubscriptionHome, SIDestinationAddress destAddr, SelectionCriteria criteria, boolean supportsMultipleConsumers, boolean nolocal, Reliability reliability, boolean enableReadAhead, Reliability unrecoverableReliability, boolean bifurcatable, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription", (Object)new Object[]{subscriptionName, durableSubscriptionHome, destAddr, criteria, reliability, "" + enableReadAhead, "" + supportsMultipleConsumers, "" + nolocal, unrecoverableReliability, "" + bifurcatable, alternateUser});
        }
        Proxy cs = null;
        HashMap<Short, ConsumerSessionProxy> hashMap = this.generalLock;
        synchronized (hashMap) {
            block35: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.checkAlreadyClosed();
                        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
                        if (bifurcatable) {
                            enableReadAhead = false;
                        }
                        AsynchConsumerProxyQueue proxyQueue = null;
                        if (enableReadAhead) {
                            ProxyQueueConversationGroup pqcg = this.getProxyQueueConversationGroup();
                            proxyQueue = pqcg.createReadAheadProxyQueue(unrecoverableReliability);
                        }
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putShort(this.getConnectionObjectID());
                        if (proxyQueue != null) {
                            request.putShort(proxyQueue.getId());
                        } else {
                            request.putShort(0);
                        }
                        int consumerFlags = 0;
                        if (enableReadAhead) {
                            consumerFlags = 1;
                        }
                        if (nolocal) {
                            consumerFlags |= 2;
                        }
                        if (supportsMultipleConsumers) {
                            consumerFlags |= 4;
                        }
                        if (bifurcatable) {
                            consumerFlags |= 0x40;
                        }
                        request.putShort(consumerFlags);
                        if (reliability != null) {
                            request.putShort(reliability.toInt());
                        } else {
                            request.putShort(-1);
                        }
                        request.putInt(HIGH_QUEUE_BYTES);
                        if (unrecoverableReliability == null) {
                            unrecoverableReliability = Reliability.NONE;
                        }
                        request.putShort(unrecoverableReliability.toInt());
                        request.putSIDestinationAddress(destAddr, this.getConversation().getHandshakeProperties().getFapLevel());
                        request.putString(subscriptionName);
                        request.putString(durableSubscriptionHome);
                        request.putSelectionCriteria(criteria);
                        request.putString(alternateUser);
                        CommsByteBuffer reply = this.jfapExchange(request, 102, 7, true);
                        try {
                            short err = 0;
                            try {
                                err = reply.getCommandCompletionCode(231);
                                if (err != 0) {
                                    this.checkFor_SIConnectionUnavailableException(reply, err);
                                    this.checkFor_SIConnectionDroppedException(reply, err);
                                    this.checkFor_SIResourceException(reply, err);
                                    this.checkFor_SIConnectionLostException(reply, err);
                                    this.checkFor_SILimitExceededException(reply, err);
                                    this.checkFor_SINotAuthorizedException(reply, err);
                                    this.checkFor_SIIncorrectCallException(reply, err);
                                    this.checkFor_SIDurableSubscriptionNotFoundException(reply, err);
                                    this.checkFor_SIDurableSubscriptionMismatchException(reply, err);
                                    this.checkFor_SIDestinationLockedException(reply, err);
                                    this.checkFor_SIErrorException(reply, err);
                                    this.defaultChecker(reply, err);
                                }
                            }
                            finally {
                                if (err != 0 && proxyQueue != null) {
                                    state.getProxyQueueConversationGroup().bury(proxyQueue);
                                }
                            }
                            long messageProcessorId = reply.getLong();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message processor Id:", (Object)("" + messageProcessorId));
                            }
                            cs = new ConsumerSessionProxy(this.getConversation(), this, reply, proxyQueue, unrecoverableReliability, destAddr, DestinationType.TOPICSPACE, messageProcessorId);
                            if (proxyQueue != null) {
                                proxyQueue.setConsumerSession((ConsumerSessionProxy)cs);
                            }
                        }
                        finally {
                            reply.release();
                        }
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block35;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Interrupted", (Object)e);
                }
            }
        }
        hashMap = this.consumerSessions;
        synchronized (hashMap) {
            this.consumerSessions.put(cs.getProxyID(), (ConsumerSessionProxy)cs);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConsumerSessionForDurableSubscription", (Object)cs);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDurableSubscription(String subscriptionName, String durableSubscriptionHome) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteDurableSubscription", (Object)new Object[]{subscriptionName, durableSubscriptionHome});
        }
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    this.checkAlreadyClosed();
                    CommsByteBuffer request = this.getCommsByteBuffer();
                    request.putShort(this.getConnectionObjectID());
                    request.putString(subscriptionName);
                    request.putString(durableSubscriptionHome);
                    CommsByteBuffer reply = this.jfapExchange(request, 68, 7, true);
                    try {
                        short err = reply.getCommandCompletionCode(196);
                        if (err != 0) {
                            this.checkFor_SIConnectionUnavailableException(reply, err);
                            this.checkFor_SIConnectionDroppedException(reply, err);
                            this.checkFor_SIResourceException(reply, err);
                            this.checkFor_SIConnectionLostException(reply, err);
                            this.checkFor_SINotAuthorizedException(reply, err);
                            this.checkFor_SIIncorrectCallException(reply, err);
                            this.checkFor_SIDurableSubscriptionNotFoundException(reply, err);
                            this.checkFor_SIDestinationLockedException(reply, err);
                            this.checkFor_SIErrorException(reply, err);
                            this.defaultChecker(reply, err);
                        }
                    }
                    finally {
                        reply.release();
                    }
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteDurableSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationConfiguration getDestinationConfiguration(SIDestinationAddress destAddr) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationConfigurationImpl dc = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDestinationConfiguration");
        }
        this.checkAlreadyClosed();
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putSIDestinationAddress(destAddr, this.getConversation().getHandshakeProperties().getFapLevel());
        CommsByteBuffer reply = this.jfapExchange(request, 101, 7, true);
        try {
            short err = reply.getCommandCompletionCode(229);
            if (err != 0) {
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SINotAuthorizedException(reply, err);
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            int defaultPriority = reply.getInt();
            int maxFailedDevliveries = reply.getInt();
            short defaultReliabilityShort = reply.getShort();
            short maxReliabilityShort = reply.getShort();
            short destinationTypeShort = reply.getShort();
            short destinationFlags = reply.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Default Priority     :", (Object)("" + defaultPriority));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Max failed deliveries:", (Object)("" + maxFailedDevliveries));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Default Reliability  :", (Object)("" + defaultReliabilityShort));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Max Reliability      :", (Object)("" + maxReliabilityShort));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination Type     :", (Object)("" + destinationTypeShort));
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Destination Flags    :", (Object)("" + destinationFlags));
            }
            Reliability defaultReliability = null;
            if (defaultReliabilityShort != -1) {
                defaultReliability = Reliability.getReliability((int)defaultReliabilityShort);
            }
            Reliability maxReliability = null;
            if (maxReliabilityShort != -1) {
                maxReliability = Reliability.getReliability((int)maxReliabilityShort);
            }
            DestinationType destType = null;
            if (destinationTypeShort != -1) {
                destType = DestinationType.getDestinationType((int)destinationTypeShort);
            }
            boolean producerQOSOverrideEnabled = (destinationFlags & 1) != 0;
            boolean receiveAllowed = (destinationFlags & 2) != 0;
            boolean receiveExclusive = (destinationFlags & 4) != 0;
            boolean sendAllowed = (destinationFlags & 8) != 0;
            short fapLevel = this.getConversation().getHandshakeProperties().getFapLevel();
            boolean strictOrderingRequired = fapLevel >= 5 ? (destinationFlags & 0x10) != 0 : false;
            String uuid = reply.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"UUID:", (Object)uuid);
            }
            String description = reply.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Description:", (Object)description);
            }
            String exceptionDestination = reply.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"ExceptionDestination name:", (Object)exceptionDestination);
            }
            String name = reply.getString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Name:", (Object)name);
            }
            SIDestinationAddress replyDestAddr = reply.getSIDestinationAddress(this.getConversation().getHandshakeProperties().getFapLevel());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Reply Dest Addr:", (Object)replyDestAddr);
            }
            HashMap<String, String> destContext = new HashMap<String, String>();
            int numberOfValues = reply.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Number of name value pairs: ", (Object)("" + numberOfValues));
            }
            for (int x = 0; x < numberOfValues; ++x) {
                String contextName = reply.getString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Name:", (Object)contextName);
                }
                String contextValue = reply.getString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Value:", (Object)contextValue);
                }
                destContext.put(contextName, contextValue);
            }
            SIDestinationAddress[] frp = null;
            int numberOfFRPAddress = reply.getShort();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Number of SI Destination Address: ", (Object)("" + numberOfFRPAddress));
            }
            if (numberOfFRPAddress != 0) {
                frp = new SIDestinationAddress[numberOfFRPAddress];
                for (int x = 0; x < numberOfFRPAddress; ++x) {
                    frp[x] = reply.getSIDestinationAddress(this.getConversation().getHandshakeProperties().getFapLevel());
                }
            }
            dc = new DestinationConfigurationImpl(defaultPriority, defaultReliability, description, destContext, destType, exceptionDestination, maxFailedDevliveries, maxReliability, name, uuid, producerQOSOverrideEnabled, receiveAllowed, receiveExclusive, sendAllowed, frp, replyDestAddr, strictOrderingRequired);
        }
        finally {
            reply.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDestinationConfiguration", (Object)dc);
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress createTemporaryDestination(Distribution distribution, String destinationPrefix) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIInvalidDestinationPrefixException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTemporaryDestination", (Object)new Object[]{distribution, destinationPrefix});
        }
        this.checkAlreadyClosed();
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putShort(distribution.toInt());
        request.putString(destinationPrefix);
        CommsByteBuffer reply = this.jfapExchange(request, 65, 7, true);
        SIDestinationAddress destAddress = null;
        try {
            short err = reply.getCommandCompletionCode(193);
            if (err != 0) {
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SILimitExceededException(reply, err);
                this.checkFor_SINotAuthorizedException(reply, err);
                this.checkFor_SIInvalidDestinationPrefixException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            destAddress = reply.getSIDestinationAddress(this.getConversation().getHandshakeProperties().getFapLevel());
        }
        finally {
            reply.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTemporaryDestination", (Object)destAddress);
        }
        return destAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryDestination(SIDestinationAddress destAddr) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)destAddr);
        }
        this.checkAlreadyClosed();
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putSIDestinationAddress(destAddr, this.getConversation().getHandshakeProperties().getFapLevel());
        CommsByteBuffer reply = this.jfapExchange(request, 66, 7, true);
        try {
            short err = reply.getCommandCompletionCode(194);
            if (err != 0) {
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SINotAuthorizedException(reply, err);
                this.checkFor_SIDestinationLockedException(reply, err);
                this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
        }
        finally {
            reply.release();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deleteTemporaryDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToExceptionDestination(SIDestinationAddress address, SIBusMessage message, int reason, String[] inserts, SITransaction tran, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendToExceptionDestination", (Object)new Object[]{address, message, "" + reason, inserts == null ? "<null>" : inserts.length + " insert(s)", tran, alternateUser});
        }
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    this.checkAlreadyClosed();
                    HandshakeProperties props = this.getConversation().getHandshakeProperties();
                    if (props.getFapLevel() >= 9) {
                        this.sendChunkedExceptionMessage(address, message, reason, inserts, tran, alternateUser);
                    } else {
                        this.sendEntireExceptionMessage(address, message, reason, inserts, tran, alternateUser);
                    }
                }
                catch (SITemporaryDestinationNotFoundException e) {
                    throw new SIErrorException((Throwable)e);
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendToExceptionDestination");
        }
    }

    private void sendChunkedExceptionMessage(SIDestinationAddress address, SIBusMessage message, int reason, String[] inserts, SITransaction tran, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedExceptionMessage", (Object)new Object[]{address, message, reason, inserts, tran, alternateUser});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        List<DataSlice> messageSlices = null;
        try {
            messageSlices = request.encodeFast((AbstractMessage)((JsMessage)message), this.getCommsConnection(), this.getConversation());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message encoded into " + messageSlices.size() + " slice(s)"));
            }
        }
        catch (SIConnectionDroppedException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"1-002-0009", (Object[])new Object[]{message, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to encode message", (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        int msgLen = 0;
        for (DataSlice slice : messageSlices) {
            msgLen += slice.getLength();
        }
        if (msgLen < 1024000) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
            }
            this.sendEntireExceptionMessage(address, message, reason, inserts, tran, alternateUser);
        } else {
            for (int x = 0; x < messageSlices.size(); ++x) {
                DataSlice slice;
                slice = messageSlices.get(x);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                }
                boolean first = x == 0;
                boolean last = x == messageSlices.size() - 1;
                byte flags = 0;
                if (first) {
                    flags = (byte)(flags | 1);
                }
                if (last) {
                    flags = (byte)(flags | 4);
                } else if (!first) {
                    flags = (byte)(flags | 2);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                }
                if (!first) {
                    request = this.getCommsByteBuffer();
                }
                request.putShort(this.getConnectionObjectID());
                request.putSITransaction(tran);
                request.put(flags);
                if (first) {
                    request.putSIDestinationAddress(address, this.getConversation().getHandshakeProperties().getFapLevel());
                    request.putInt(reason);
                    request.putString(alternateUser);
                    if (inserts == null) {
                        inserts = new String[]{};
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Adding " + inserts.length + " insert(s)"));
                    }
                    request.putShort(inserts.length);
                    for (int y = 0; y < inserts.length; ++y) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Adding insert [" + y + "]: " + inserts[y]));
                        }
                        request.putString(inserts[y]);
                    }
                }
                request.putDataSlice(slice);
                if (!last) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending first / middle chunk");
                    }
                    this.jfapSend(request, 118, 7, false, Conversation.ThrottlingPolicy.BLOCK_THREAD);
                    continue;
                }
                this.sendData(request, (short)7, true, tran, 118, 0, 252);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedExceptionMessage");
        }
    }

    private void sendEntireExceptionMessage(SIDestinationAddress address, SIBusMessage message, int reason, String[] inserts, SITransaction tran, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireExceptionMessage", (Object)new Object[]{address, message, reason, inserts, tran, alternateUser});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putSITransaction(tran);
        request.putSIDestinationAddress(address, this.getConversation().getHandshakeProperties().getFapLevel());
        request.putInt(reason);
        request.putString(alternateUser);
        request.putClientMessage(message, this.getCommsConnection(), this.getConversation());
        if (inserts == null) {
            inserts = new String[]{};
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Adding " + inserts.length + " insert(s)"));
        }
        request.putShort(inserts.length);
        for (int x = 0; x < inserts.length; ++x) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Adding insert [" + x + "]: " + inserts[x]));
            }
            request.putString(inserts[x]);
        }
        this.sendData(request, (short)7, true, tran, 108, 0, 237);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireExceptionMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SICoreConnection cloneConnection() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cloneConnection");
        }
        this.checkAlreadyClosed();
        ConnectionProxy cloneConnection = null;
        Set<ConnectionProxy> set = this.cachedCloneConnections;
        synchronized (set) {
            if (!this.cachedCloneConnections.isEmpty()) {
                Iterator<ConnectionProxy> it = this.cachedCloneConnections.iterator();
                cloneConnection = it.next();
                this.cachedCloneConnections.remove(cloneConnection);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Connection allocated from cache=" + cloneConnection));
                }
                cloneConnection.setOpen();
                cloneConnection.removeAllConnectionListeners();
                this.cloneConnectionListeners(this, cloneConnection);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cache is empty");
            }
        }
        if (cloneConnection == null) {
            cloneConnection = this.prepareNewCloneConnection(this);
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putShort(this.getConversation().getId());
            CommsByteBuffer reply = cloneConnection.jfapExchange(request, 99, 7, true);
            try {
                short err = reply.getCommandCompletionCode(227);
                if (err != 0) {
                    this.checkFor_SIConnectionUnavailableException(reply, err);
                    this.checkFor_SIConnectionDroppedException(reply, err);
                    this.checkFor_SIResourceException(reply, err);
                    this.checkFor_SIConnectionLostException(reply, err);
                    this.checkFor_SILimitExceededException(reply, err);
                    this.checkFor_SIErrorException(reply, err);
                    this.defaultChecker(reply, err);
                }
                this.completeNewCloneConnection(cloneConnection, reply);
                this.cloneConnectionListeners(this, cloneConnection);
            }
            finally {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cloneConnection", (Object)cloneConnection);
        }
        return cloneConnection;
    }

    private ConnectionProxy prepareNewCloneConnection(ConnectionProxy parentConnection) throws SIResourceException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareNewCloneConnection", (Object)("parentConnection=" + parentConnection));
        }
        short fapLevel = this.getConversation().getHandshakeProperties().getFapLevel();
        ConnectionProxy cloneConnection = null;
        cloneConnection = fapLevel >= 5 ? new MSSIXAResourceProvidingConnectionProxy(this.getConversation().cloneConversation(new ProxyReceiveListener()), parentConnection) : new ConnectionProxy(this.getConversation().cloneConversation(new ProxyReceiveListener()));
        cloneConnection.createConversationState();
        cloneConnection.setCommsConnection(this.getCommsConnection());
        cloneConnection.setMeUuid(this.getMeUuid());
        cloneConnection.setResolvedUserId(this.getResolvedUserid());
        cloneConnection.setMeName(this.getMeName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareNewCloneConnection", (Object)("rc=" + cloneConnection));
        }
        return cloneConnection;
    }

    private void completeNewCloneConnection(ConnectionProxy newConnection, CommsByteBuffer reply) throws SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"completeNewCloneConnection", (Object)("newConnection=" + newConnection + ", reply=" + reply));
        }
        short fapLevel = this.getConversation().getHandshakeProperties().getFapLevel();
        newConnection.setConnectionObjectID(reply.getShort());
        newConnection.setSICoreConnection(newConnection);
        if (fapLevel >= 9) {
            byte[] uniqueId = reply.get(reply.getShort());
            newConnection.setInitialUniqueId(uniqueId);
            short orderContext = reply.getShort();
            newConnection.addOrderContext(orderContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"completeNewCloneConnection");
        }
    }

    private void cloneConnectionListeners(ConnectionProxy from, ConnectionProxy to) throws SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cloneConnectionListeners", (Object)("from=" + from + ", to=" + to));
        }
        ClientConversationState convState = (ClientConversationState)from.getConversation().getAttachment();
        SICoreConnectionListener[] listeners = convState.getCatConnectionListeners().getConnectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            to.addConnectionListener(listeners[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cloneConnectionListeners");
        }
    }

    public boolean isEquivalentTo(SICoreConnection rhs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEquivalentTo");
        }
        boolean equivalant = false;
        if (rhs.getMeUuid().equals(this.getMeUuid()) && ((ConnectionProxy)rhs).getConversation().sharesSameLinkAs(this.getConversation())) {
            equivalant = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEquivalentTo", (Object)("" + equivalant));
        }
        return equivalant;
    }

    public SIUncoordinatedTransaction createUncoordinatedTransaction() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createUncoordinatedTransaction");
        }
        SIUncoordinatedTransaction result = this.createUncoordinatedTransaction(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createUncoordinatedTransaction", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIUncoordinatedTransaction createUncoordinatedTransaction(boolean allowSubordinateResources) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createUncoordinatedTransaction", (Object)("" + allowSubordinateResources));
        }
        LocalTransactionProxy localTranProxy = null;
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    this.checkAlreadyClosed();
                    if (this.requiresOptimizedTransactions) {
                        localTranProxy = new OptimizedUncoordinatedTransactionProxy(this.getConversation(), this, allowSubordinateResources);
                    } else {
                        localTranProxy = new LocalTransactionProxy(this.getConversation(), this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Created the transaction proxy. ID: " + localTranProxy.getTransactionId()));
                        }
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putShort(this.getConnectionObjectID());
                        request.putInt(localTranProxy.getTransactionId());
                        if (this.getConversation().getHandshakeProperties().getFapLevel() >= 5) {
                            request.put(allowSubordinateResources ? (byte)1 : 0);
                        }
                        this.jfapSend(request, 80, 11, true, Conversation.ThrottlingPolicy.BLOCK_THREAD);
                    }
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createUncoordinatedTransaction", localTranProxy);
        }
        return localTranProxy;
    }

    public SIXAResource getSIXAResource() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIXAResource");
        }
        SIXAResource xaResource = this._internalGetSIXAResource(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIXAResource", (Object)xaResource);
        }
        return xaResource;
    }

    SIXAResource _internalGetSIXAResource(boolean requiresMSResource) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_internalGetSIXAResource", (Object)requiresMSResource);
        }
        this.checkAlreadyClosed();
        BaseSIXAResourceProxy xaResource = this._createXAResource(requiresMSResource);
        SuspendableXAResource result = new SuspendableXAResource(this.getConversation(), this, xaResource, requiresMSResource);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_internalGetSIXAResource", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BaseSIXAResourceProxy _createXAResource(boolean requiresMSResource) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_createXAResource", (Object)requiresMSResource);
        }
        BaseSIXAResourceProxy result = null;
        if (this.requiresOptimizedTransactions) {
            result = new OptimizedSIXAResourceProxy(this.getConversation(), this, requiresMSResource);
        } else {
            result = new SIXAResourceProxy(this.getConversation(), this, requiresMSResource);
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putShort(this.getConnectionObjectID());
            request.putInt(result.getTransactionId());
            CommsByteBuffer reply = this.jfapExchange(request, 48, 7, true);
            try {
                short err = reply.getCommandCompletionCode(176);
                if (err != 0) {
                    this.checkFor_SIConnectionUnavailableException(reply, err);
                    this.checkFor_SIConnectionDroppedException(reply, err);
                    this.checkFor_SIResourceException(reply, err);
                    this.checkFor_SIConnectionLostException(reply, err);
                    this.checkFor_SIErrorException(reply, err);
                    this.defaultChecker(reply, err);
                }
            }
            finally {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_createXAResource", (Object)result);
        }
        return result;
    }

    public void addConnectionListener(SICoreConnectionListener listener) throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addConnectionListener", (Object)listener);
        }
        this.checkAlreadyClosed();
        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListeners = state.getCatConnectionListeners();
        catConnectionListeners.add(listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addConnectionListener");
        }
    }

    public void removeConnectionListener(SICoreConnectionListener listener) throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeConnectionListener", (Object)listener);
        }
        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListeners = state.getCatConnectionListeners();
        catConnectionListeners.remove(listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeConnectionListener");
        }
    }

    public SICoreConnectionListener[] getConnectionListeners() throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionListeners");
        }
        this.checkAlreadyClosed();
        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListeners = state.getCatConnectionListeners();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionListeners");
        }
        return catConnectionListeners.getConnectionListeners();
    }

    private void removeAllConnectionListeners() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeAllConnectionListeners");
        }
        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
        CatConnectionListenerGroup catConnectionListeners = state.getCatConnectionListeners();
        catConnectionListeners.removeAllElements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeAllConnectionListeners");
        }
    }

    public String getApiLevelDescription() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApiLevelDescription");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApiLevelDescription");
        }
        return this.getApiMajorVersion() + "." + this.getApiMinorVersion();
    }

    public long getApiMajorVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApiMajorVersion");
        }
        HandshakeProperties handshake = this.getConversation().getHandshakeProperties();
        long reportedApiMajor = 6L;
        if ((long)handshake.getMajorVersion() < 6L) {
            reportedApiMajor = handshake.getMajorVersion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApiMajorVersion", (Object)("" + reportedApiMajor));
        }
        return reportedApiMajor;
    }

    public long getApiMinorVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getApiMinorVersion");
        }
        HandshakeProperties handshake = this.getConversation().getHandshakeProperties();
        long reportedApiMinor = 0L;
        reportedApiMinor = (long)handshake.getMajorVersion() < 6L ? (long)handshake.getMinorVersion() : ((long)handshake.getMajorVersion() > 6L ? 0L : ((long)handshake.getMinorVersion() < 0L ? (long)handshake.getMinorVersion() : 0L));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getApiMinorVersion", (Object)("" + reportedApiMinor));
        }
        return reportedApiMinor;
    }

    public String getMeName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMeName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMeName", (Object)this.meName);
        }
        return this.meName;
    }

    public String getMeUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMeUuid");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMeUuid", (Object)this.meUuid);
        }
        return this.meUuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress checkMessagingRequired(SIDestinationAddress requestDestAddr, SIDestinationAddress replyDestAddr, DestinationType destinationType, String alternateUser) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkMessagingRequired", (Object)new Object[]{requestDestAddr, replyDestAddr, destinationType, alternateUser});
        }
        SIDestinationAddress resolvedRequestDestination = null;
        try {
            this.closeLock.readLock().lockInterruptibly();
            try {
                this.checkAlreadyClosed();
                HandshakeProperties props = this.getConversation().getHandshakeProperties();
                CommsUtils.checkFapLevel(props, (short)2);
                CommsByteBuffer request = this.getCommsByteBuffer();
                request.putShort(this.getConnectionObjectID());
                request.putSIDestinationAddress(requestDestAddr, this.getConversation().getHandshakeProperties().getFapLevel());
                request.putSIDestinationAddress(replyDestAddr, this.getConversation().getHandshakeProperties().getFapLevel());
                if (destinationType == null) {
                    request.putShort((short)-1);
                } else {
                    request.putShort(destinationType.toInt());
                }
                request.putString(alternateUser);
                CommsByteBuffer reply = this.jfapExchange(request, 111, 7, true);
                try {
                    short err = reply.getCommandCompletionCode(242);
                    if (err != 0) {
                        this.checkFor_SIConnectionUnavailableException(reply, err);
                        this.checkFor_SIConnectionDroppedException(reply, err);
                        this.checkFor_SIResourceException(reply, err);
                        this.checkFor_SINotAuthorizedException(reply, err);
                        this.checkFor_SIIncorrectCallException(reply, err);
                        this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                        this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                        this.checkFor_SIErrorException(reply, err);
                        this.defaultChecker(reply, err);
                    }
                    if (reply.hasRemaining()) {
                        resolvedRequestDestination = reply.getSIDestinationAddress(this.getConversation().getHandshakeProperties().getFapLevel());
                    }
                }
                finally {
                    reply.release();
                }
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkMessagingRequired", resolvedRequestDestination);
        }
        return resolvedRequestDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderingContext createOrderingContext() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createOrderingContext");
        }
        this.checkAlreadyClosed();
        OrderingContextProxy oc = null;
        Object object = this.generalLock;
        synchronized (object) {
            try {
                this.closeLock.readLock().lockInterruptibly();
                try {
                    this.checkAlreadyClosed();
                    oc = new OrderingContextProxy(this.getConversation(), this);
                }
                finally {
                    this.closeLock.readLock().unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createOrderingContext", (Object)oc);
        }
        return oc;
    }

    public String getResolvedUserid() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        return this.resolvedUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createUniqueId() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createUniqueId");
        }
        this.checkAlreadyClosed();
        byte[] uniqueId = null;
        if (this.initialUniqueId != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Using cached initialUniqueId");
            }
            uniqueId = this.initialUniqueId;
            this.initialUniqueId = null;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"No cached initialUniqueId so requesting a new one");
            }
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putShort(this.getConnectionObjectID());
            CommsByteBuffer reply = this.jfapExchange(request, 100, 7, true);
            try {
                short err = reply.getCommandCompletionCode(228);
                if (err != 0) {
                    this.checkFor_SIConnectionUnavailableException(reply, err);
                    this.checkFor_SIConnectionDroppedException(reply, err);
                    this.checkFor_SIResourceException(reply, err);
                    this.checkFor_SIConnectionLostException(reply, err);
                    this.checkFor_SIErrorException(reply, err);
                    this.defaultChecker(reply, err);
                }
                short uniqueIdLength = reply.getShort();
                uniqueId = reply.get(uniqueIdLength);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])uniqueId, (int)0, (int)uniqueId.length, (String)"ID:");
                }
            }
            finally {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createUniqueId", (Object)uniqueId);
        }
        return uniqueId;
    }

    public Serializable invokeCommand(String key, String commandName, Serializable commandData) throws SINotAuthorizedException, SICommandInvocationFailedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIIncorrectCallException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invokeCommand", (Object)new Object[]{key, commandName, commandData});
        }
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)5);
        Serializable returnObject = this._invokeCommand(key, commandName, commandData, null, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invokeCommand", (Object)returnObject);
        }
        return returnObject;
    }

    public Serializable invokeCommand(String key, String commandName, Serializable commandData, SITransaction tran) throws SINotAuthorizedException, SICommandInvocationFailedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIIncorrectCallException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invokeCommand", (Object)new Object[]{key, commandName, commandData, tran});
        }
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)6);
        Serializable returnObject = this._invokeCommand(key, commandName, commandData, tran, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invokeCommand", (Object)returnObject);
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable _invokeCommand(String key, String commandName, Serializable commandData, SITransaction transaction, boolean callTransactedCallback) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIResourceException, SIIncorrectCallException, SINotAuthorizedException, SICommandInvocationFailedException {
        Serializable returnObject;
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"_invokeCommand", (Object)new Object[]{key, commandName, commandData, transaction, callTransactedCallback});
            }
            returnObject = null;
            ObjectInputStream ois = null;
            byte[] commandDataBytes = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(commandData);
                commandDataBytes = baos.toByteArray();
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "._invokeCommand"), (String)"1-002-0006", (Object[])new Object[]{key, commandName, commandData, transaction, this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to serialize command data", (Object)e);
                }
                throw new SICommandInvocationFailedException(nls.getFormattedMessage("FAILED_TO_SERIALIZE_COMMAND_SICO1062", null, "FAILED_TO_SERIALIZE_COMMAND_SICO1062"), (Throwable)e);
            }
            CommsByteBuffer request = this.getCommsByteBuffer();
            request.putShort(this.getConnectionObjectID());
            if (callTransactedCallback) {
                request.putSITransaction(transaction);
            }
            request.putString(key);
            request.putString(commandName);
            request.putInt(commandDataBytes.length);
            request.put(commandDataBytes);
            CommsByteBuffer reply = null;
            reply = !callTransactedCallback ? this.jfapExchange(request, 112, 7, true) : this.jfapExchange(request, 113, 7, true);
            try {
                short err = reply.getCommandCompletionCode(243);
                if (err != 0) {
                    this.checkFor_SIConnectionDroppedException(reply, err);
                    this.checkFor_SIConnectionUnavailableException(reply, err);
                    this.checkFor_SIIncorrectCallException(reply, err);
                    this.checkFor_SIResourceException(reply, err);
                    this.checkFor_SINotAuthorizedException(reply, err);
                    this.checkFor_SICommandInvocationFailedException(reply, err);
                    this.checkFor_SIErrorException(reply, err);
                    this.defaultChecker(reply, err);
                }
                if (!reply.hasRemaining()) break block18;
                int dataLength = reply.getInt();
                byte[] retData = reply.get(dataLength);
                try {
                    ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    ois = new DeserializationObjectInputStream((InputStream)new ByteArrayInputStream(retData), cl);
                    returnObject = (Serializable)ois.readObject();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "._invokeCommand"), (String)"1-002-0007", (Object[])new Object[]{key, commandName, commandData, transaction, this});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to serialize command data", (Object)e);
                    }
                    throw new SICommandInvocationFailedException(nls.getFormattedMessage("FAILED_TO_DESERIALIZE_COMMAND_SICO1063", null, "FAILED_TO_DESERIALIZE_COMMAND_SICO1063"), (Throwable)e);
                }
            }
            finally {
                block19: {
                    reply.release();
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception closing the ObjectInputStream", (Object)ex);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_invokeCommand", returnObject);
        }
        return returnObject;
    }

    public void close() throws SIResourceException, SIConnectionLostException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this._close(false, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public void close(boolean bForceFlag) throws SIResourceException, SIConnectionLostException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)bForceFlag);
        }
        this._close(bForceFlag, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close", (Object)bForceFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close(boolean force, boolean useCloseLock) throws SIResourceException, SIConnectionLostException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        block62: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"_close", (Object)new Object[]{force, useCloseLock});
            }
            try {
                if (useCloseLock) {
                    this.closeLock.writeLock().lockInterruptibly();
                }
                try {
                    CommsByteBuffer reply;
                    boolean fap9OrAbove;
                    ProxyQueueConversationGroup pqcg;
                    ClientConversationState state;
                    block63: {
                        if (this.isClosed()) break block62;
                        Set<ConnectionProxy> set = this.cachedCloneConnections;
                        synchronized (set) {
                            for (ConnectionProxy cachedConnection : this.cachedCloneConnections) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Closing cached connection=" + cachedConnection));
                                }
                                cachedConnection.setOpen();
                                cachedConnection._close(true, true);
                            }
                        }
                        state = (ClientConversationState)this.getConversation().getAttachment();
                        pqcg = state.getProxyQueueConversationGroup();
                        if (pqcg != null) {
                            pqcg.closeNotification();
                        }
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putShort(this.getConnectionObjectID());
                        boolean bl = fap9OrAbove = this.getConversation().getHandshakeProperties().getFapLevel() >= 9;
                        if (fap9OrAbove) {
                            if (!force) {
                                if (this.parent != null) {
                                    if (!this.parent.isClosed()) {
                                        Set<ConnectionProxy> set2 = this.parent.cachedCloneConnections;
                                        synchronized (set2) {
                                            if (this.parent.cachedCloneConnections.size() <= 2) {
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Requesting that this connection be reset");
                                                }
                                                request.put((byte)1);
                                            } else {
                                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Parent has reached maxmimum number of cached clone connection so not resetting this connection");
                                                }
                                                request.put((byte)0);
                                            }
                                        }
                                    } else {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Parent connection is closed - closing this connection");
                                        }
                                        request.put((byte)0);
                                    }
                                } else {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"This connection has no parent - this is not a clone connection - closing this connection");
                                    }
                                    request.put((byte)0);
                                }
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection is being forced closed");
                                }
                                request.put((byte)0);
                            }
                        }
                        reply = null;
                        try {
                            reply = this.jfapExchange(request, 64, -1, true);
                        }
                        catch (SIConnectionDroppedException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exchange with ME failed");
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
                            }
                        }
                        catch (SIConnectionLostException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exchange with ME failed");
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block63;
                            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                    boolean connectionReset = false;
                    try {
                        if (reply != null) {
                            short err = reply.getCommandCompletionCode(192);
                            if (err != 0) {
                                this.checkFor_SIResourceException(reply, err);
                                this.checkFor_SIConnectionLostException(reply, err);
                                this.checkFor_SIConnectionUnavailableException(reply, err);
                                this.checkFor_SIConnectionDroppedException(reply, err);
                                this.checkFor_SIErrorException(reply, err);
                                this.defaultChecker(reply, err);
                            }
                            if (fap9OrAbove) {
                                connectionReset = reply.get() == 1;
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to receive a reply from the ME");
                        }
                        if (connectionReset) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection was reset");
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection was closed");
                        }
                        this.setClosed();
                        this.orderContextPool.clear();
                        this.removeAllConnectionListeners();
                        if (!connectionReset) {
                            if (fap9OrAbove) {
                                this.getConversation().fastClose();
                            } else {
                                this.getConversation().close();
                            }
                        }
                        if (pqcg != null) {
                            pqcg.close();
                            state.setProxyQueueConversationGroup(null);
                        }
                        if (!connectionReset) break block62;
                        this.completeNewCloneConnection(this, reply);
                        boolean cacheFull = true;
                        Set<ConnectionProxy> set = this.parent.cachedCloneConnections;
                        synchronized (set) {
                            if (this.parent.cachedCloneConnections.size() <= 2) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Size of cachedCloneConnections: " + this.cachedCloneConnections.size()));
                                }
                                this.parent.cachedCloneConnections.add(this);
                                cacheFull = false;
                            }
                        }
                        if (cacheFull) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Cache is full, forcing close.");
                            }
                            this.setOpen();
                            this._close(true, false);
                        }
                    }
                    finally {
                        if (reply != null) {
                            reply.release();
                        }
                    }
                }
                finally {
                    if (useCloseLock) {
                        this.closeLock.writeLock().unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SIBusMessage msg, SITransaction tran, SIDestinationAddress destAddress, DestinationType destType, OrderingContext orderingContext, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{msg, tran, destAddress, destType, orderingContext, alternateUser});
        }
        Object object = this.generalLock;
        synchronized (object) {
            block17: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.checkAlreadyClosed();
                        if (orderingContext != null) {
                            ((OrderingContextProxy)orderingContext).incrementUseCount();
                        }
                        if (tran != null) {
                            SITransaction sITransaction = tran;
                            synchronized (sITransaction) {
                                if (!((Transaction)tran).isValid()) {
                                    throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1067", null, null));
                                }
                                this._send(msg, tran, destAddress, destType, orderingContext, alternateUser);
                                break block17;
                            }
                        }
                        this._send(msg, null, destAddress, destType, orderingContext, alternateUser);
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                        if (orderingContext != null) {
                            ((OrderingContextProxy)orderingContext).decrementUseCount();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send");
        }
    }

    private void _send(SIBusMessage msg, SITransaction tran, SIDestinationAddress destAddress, DestinationType destType, OrderingContext orderContext, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_send");
        }
        boolean sendSuccessful = false;
        short jfapPriority = JFapChannelConstants.getJFAPPriority(msg.getPriority());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Sending with JFAP priority of " + jfapPriority));
        }
        boolean requireReply = tran != null && !exchangeTransactedSends ? false : (exchangeExpressSends ? true : msg.getReliability() != Reliability.BEST_EFFORT_NONPERSISTENT && msg.getReliability() != Reliability.EXPRESS_NONPERSISTENT);
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        if (props.getFapLevel() >= 9) {
            this.sendChunkedMessage(msg, tran, orderContext, destType, destAddress, alternateUser, jfapPriority, requireReply);
        } else {
            this.sendEntireMessage(msg, null, tran, orderContext, destType, destAddress, alternateUser, jfapPriority, requireReply);
        }
        sendSuccessful = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_send");
        }
    }

    private void sendEntireMessage(SIBusMessage msg, List<DataSlice> messageSlices, SITransaction tran, OrderingContext orderContext, DestinationType destType, SIDestinationAddress destAddress, String alternateUser, short jfapPriority, boolean requireReply) throws SIResourceException, SIConnectionUnavailableException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendEntireMessage", (Object)new Object[]{msg, messageSlices, tran, orderContext, destType, destAddress, alternateUser, jfapPriority, requireReply});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        if (orderContext != null) {
            request.putShort(((OrderingContextProxy)orderContext).getId());
        } else {
            request.putShort((short)0);
        }
        request.putSITransaction(tran);
        if (destType != null) {
            request.putShort(destType.toInt());
        } else {
            request.putShort((short)-1);
        }
        request.putString(alternateUser);
        request.putSIDestinationAddress(destAddress, this.getConversation().getHandshakeProperties().getFapLevel());
        if (messageSlices == null) {
            request.putClientMessage(msg, this.getCommsConnection(), this.getConversation());
        } else {
            request.putMessgeWithoutEncode(messageSlices);
        }
        this.sendData(request, jfapPriority, requireReply, tran, 69, 70, 197);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendEntireMessage");
        }
    }

    private void sendChunkedMessage(SIBusMessage msg, SITransaction tran, OrderingContext orderContext, DestinationType destType, SIDestinationAddress destAddress, String alternateUser, short jfapPriority, boolean requireReply) throws SIResourceException, SIConnectionUnavailableException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage", (Object)new Object[]{msg, tran, orderContext, destType, destAddress, alternateUser, jfapPriority, requireReply});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        List<DataSlice> messageSlices = null;
        try {
            messageSlices = request.encodeFast((AbstractMessage)((JsMessage)msg), this.getCommsConnection(), this.getConversation());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message encoded into " + messageSlices.size() + " slice(s)"));
            }
        }
        catch (SIConnectionDroppedException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".sendChunkedMessage"), (String)"1-002-0008", (Object[])new Object[]{msg, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to encode message", (Object)e);
            }
            throw new SIResourceException((Throwable)e);
        }
        int msgLen = 0;
        for (DataSlice slice : messageSlices) {
            msgLen += slice.getLength();
        }
        if (msgLen < 1024000) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is smaller than 1024000");
            }
            this.sendEntireMessage(msg, messageSlices, tran, orderContext, destType, destAddress, alternateUser, jfapPriority, requireReply);
        } else {
            for (int x = 0; x < messageSlices.size(); ++x) {
                DataSlice slice;
                slice = messageSlices.get(x);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending slice:", (Object)slice);
                }
                boolean first = x == 0;
                boolean last = x == messageSlices.size() - 1;
                byte flags = 0;
                if (first) {
                    flags = (byte)(flags | 1);
                }
                if (last) {
                    flags = (byte)(flags | 4);
                } else if (!first) {
                    flags = (byte)(flags | 2);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Flags: " + flags));
                }
                if (!first) {
                    request = this.getCommsByteBuffer();
                }
                request.putShort(this.getConnectionObjectID());
                if (orderContext != null) {
                    request.putShort(((OrderingContextProxy)orderContext).getId());
                } else {
                    request.putShort((short)0);
                }
                request.putSITransaction(tran);
                request.put(flags);
                if (first) {
                    if (destType != null) {
                        request.putShort(destType.toInt());
                    } else {
                        request.putShort((short)-1);
                    }
                    request.putString(alternateUser);
                    request.putSIDestinationAddress(destAddress, this.getConversation().getHandshakeProperties().getFapLevel());
                }
                request.putDataSlice(slice);
                if (!last) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Sending first / middle chunk");
                    }
                    this.jfapSend(request, 117, jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD);
                    continue;
                }
                this.sendData(request, jfapPriority, requireReply, tran, 116, 117, 246);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendChunkedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void sendData(CommsByteBuffer request, short jfapPriority, boolean requireReply, SITransaction tran, int outboundSegmentType, int outboundNoReplySegmentType, int replySegmentType) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && ConnectionProxy.tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)ConnectionProxy.tc, (String)"sendData", (Object)new Object[]{request, jfapPriority, requireReply, tran, outboundSegmentType, outboundNoReplySegmentType, replySegmentType});
        }
        if (requireReply) {
            reply = this.jfapExchange(request, outboundSegmentType, jfapPriority, false);
            try {
                err = reply.getCommandCompletionCode(replySegmentType);
                if (err == 0) ** GOTO lbl26
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIResourceException(reply, err);
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SILimitExceededException(reply, err);
                this.checkFor_SINotAuthorizedException(reply, err);
                this.checkFor_SIIncorrectCallException(reply, err);
                this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
                this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            finally {
                reply.release();
            }
        } else {
            this.jfapSend(request, outboundNoReplySegmentType, jfapPriority, false, Conversation.ThrottlingPolicy.BLOCK_THREAD);
            if (tran != null) {
                ((Transaction)tran).updateLowestMessagePriority(jfapPriority);
            }
        }
lbl26:
        // 5 sources

        if (TraceComponent.isAnyTracingEnabled() && ConnectionProxy.tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)ConnectionProxy.tc, (String)"sendData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveNoWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveNoWait", (Object)new Object[]{tran, unrecoverableReliability, destAddr, destType, criteria, reliability, alternateUser});
        }
        SIBusMessage mess = null;
        Object object = this.generalLock;
        synchronized (object) {
            block15: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.checkAlreadyClosed();
                        if (tran != null) {
                            SITransaction sITransaction = tran;
                            synchronized (sITransaction) {
                                if (!((Transaction)tran).isValid()) {
                                    throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1067", null, null));
                                }
                                mess = this._receive(tran, unrecoverableReliability, destAddr, destType, criteria, reliability, -1L, alternateUser);
                                break block15;
                            }
                        }
                        mess = this._receive(null, unrecoverableReliability, destAddr, destType, criteria, reliability, -1L, alternateUser);
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"receiveNoWait", mess);
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage receiveWithWait(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, long timeout, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"receiveWithWait", (Object)new Object[]{tran, unrecoverableReliability, destAddr, destType, criteria, reliability, "" + timeout, alternateUser});
        }
        SIBusMessage mess = null;
        Object object = this.generalLock;
        synchronized (object) {
            this.checkAlreadyClosed();
            if (tran != null) {
                SITransaction sITransaction = tran;
                synchronized (sITransaction) {
                    if (!((Transaction)tran).isValid()) {
                        throw new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_COMPLETE_SICO1067", null, null));
                    }
                    mess = this._receive(tran, unrecoverableReliability, destAddr, destType, criteria, reliability, timeout, alternateUser);
                }
            } else {
                mess = this._receive(null, unrecoverableReliability, destAddr, destType, criteria, reliability, timeout, alternateUser);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveWithWait", (Object)mess);
        }
        return mess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIBusMessage _receive(SITransaction tran, Reliability unrecoverableReliability, SIDestinationAddress destAddr, DestinationType destType, SelectionCriteria criteria, Reliability reliability, long timeout, String alternateUser) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_receive", (Object)new Object[]{tran, unrecoverableReliability, destAddr, destType, criteria, reliability, "" + timeout, alternateUser});
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.putShort(this.getConnectionObjectID());
        request.putSITransaction(tran);
        if (reliability != null) {
            request.putShort(reliability.toInt());
        } else {
            request.putShort(-1);
        }
        request.putLong(timeout);
        if (destType != null) {
            request.putShort(destType.toInt());
        } else {
            request.putShort((short)-1);
        }
        if (unrecoverableReliability == null) {
            unrecoverableReliability = Reliability.NONE;
        }
        request.putShort(unrecoverableReliability.toInt());
        request.putSIDestinationAddress(destAddr, this.getConversation().getHandshakeProperties().getFapLevel());
        request.putSelectionCriteria(criteria);
        request.putString(alternateUser);
        boolean exchangeSuccessful = false;
        CommsByteBuffer reply = null;
        SIBusMessage mess = null;
        reply = this.jfapExchange(request, 71, 7, true);
        short err = reply.getCommandCompletionCode(199);
        if (err != 0) {
            this.checkFor_SIConnectionUnavailableException(reply, err);
            this.checkFor_SIConnectionDroppedException(reply, err);
            this.checkFor_SIResourceException(reply, err);
            this.checkFor_SIConnectionLostException(reply, err);
            this.checkFor_SILimitExceededException(reply, err);
            this.checkFor_SINotAuthorizedException(reply, err);
            this.checkFor_SIIncorrectCallException(reply, err);
            this.checkFor_SIDestinationLockedException(reply, err);
            this.checkFor_SITemporaryDestinationNotFoundException(reply, err);
            this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
            this.checkFor_SIErrorException(reply, err);
            this.defaultChecker(reply, err);
        }
        exchangeSuccessful = true;
        Object object = this.pendingMessageSliceLock;
        synchronized (object) {
            if (this.pendingMessageSlices == null) {
                reply.getShort();
                mess = reply.getMessage(this.getCommsConnection());
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received the final slice");
                }
                reply.getShort();
                this.addMessagePart(reply);
                try {
                    mess = JsMessageFactory.getInstance().createInboundJsMessage(this.pendingMessageSlices, (Object)this.getCommsConnection());
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + "._receive"), (String)"1-009-0003", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Failed to recreate message", (Object)e);
                    }
                    throw new SIResourceException((Throwable)e);
                }
                this.pendingMessageSlices = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            CommsLightTrace.traceMessageId(tc, "ReceiveMsgTrace", mess);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_receive", (Object)mess);
        }
        return mess;
    }

    private ProxyQueueConversationGroup getProxyQueueConversationGroup() {
        ClientConversationState state;
        ProxyQueueConversationGroup pqcg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProxyQueueConversationGroup");
        }
        if ((pqcg = (state = (ClientConversationState)this.getConversation().getAttachment()).getProxyQueueConversationGroup()) == null) {
            ProxyQueueConversationGroupFactory pqFact = ProxyQueueConversationGroupFactory.getRef();
            pqcg = pqFact.create(this.getConversation());
            state.setProxyQueueConversationGroup(pqcg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProxyQueueConversationGroup", (Object)pqcg);
        }
        return pqcg;
    }

    protected void checkAlreadyClosed() throws SIConnectionUnavailableException {
        if (this.isClosed()) {
            throw new SIConnectionUnavailableException(nls.getFormattedMessage("CONNECTION_CLOSED_SICO1014", null, null));
        }
    }

    void setInitialUniqueId(byte[] id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInitialUnqiueId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"ID Length", (Object)id.length);
            SibTr.debug((TraceComponent)tc, (String)"ID: ");
            SibTr.bytes((TraceComponent)tc, (byte[])id);
        }
        this.initialUniqueId = id;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInitialUniqueId");
        }
    }

    void addOrderContext(Short context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addOrderContext", (Object)("context=" + context));
        }
        this.orderContextPool.add(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addOrderContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Short getOrderContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOrderContext");
        }
        Short rc = null;
        List<Short> list = this.orderContextPool;
        synchronized (list) {
            if (!this.orderContextPool.isEmpty()) {
                rc = this.orderContextPool.remove(0);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOrderContext", (Object)("rc=" + rc));
        }
        return rc;
    }

    void setMeUuid(String meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMeUuid", (Object)meUuid);
        }
        this.meUuid = meUuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMeUuid");
        }
    }

    void setResolvedUserId(String resolvedUserId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setResolvedUserId", (Object)resolvedUserId);
        }
        this.resolvedUserId = resolvedUserId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setResolvedUserId");
        }
    }

    void setMeName(String meName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMeName", (Object)meName);
        }
        this.meName = meName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMeName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consumerClosedNotification(short consumerSessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"consumerClosedNotification", (Object)consumerSessionId);
        }
        HashMap<Short, ConsumerSessionProxy> hashMap = this.consumerSessions;
        synchronized (hashMap) {
            this.consumerSessions.remove(consumerSessionId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"consumerClosedNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessagePart(CommsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addMessagePart", (Object)buffer);
        }
        byte flags = buffer.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Flags: ", (Object)flags);
        }
        Object object = this.pendingMessageSliceLock;
        synchronized (object) {
            if (this.pendingMessageSlices == null) {
                this.pendingMessageSlices = new ArrayList<DataSlice>();
            }
            this.pendingMessageSlices.add(buffer.getDataSlice());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message parts: ", this.pendingMessageSlices);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addMessagePart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsumerSessionProxy getConsumerSessionProxy(short consumerSessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerSessionProxy", (Object)consumerSessionId);
        }
        ConsumerSessionProxy cs = null;
        HashMap<Short, ConsumerSessionProxy> hashMap = this.consumerSessions;
        synchronized (hashMap) {
            cs = this.consumerSessions.get(consumerSessionId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerSessionProxy", (Object)cs);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress[] addDestinationListener(String destinationNamePattern, DestinationListener destinationListener, DestinationType destinationType, DestinationAvailability destinationAvailability) throws SIIncorrectCallException, SICommandInvocationFailedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIConnectionLostException {
        SIDestinationAddress[] rc = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationNamePattern, destinationListener, destinationType, destinationAvailability});
        }
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)9);
        Object object = this.generalLock;
        synchronized (object) {
            block21: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.checkAlreadyClosed();
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putShort(this.getConnectionObjectID());
                        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
                        short destinationListenerId = state.getDestinationListenerCache().add(destinationListener);
                        request.putShort(destinationListenerId);
                        if (destinationType == null) {
                            request.putShort((short)-1);
                        } else {
                            request.putShort((short)destinationType.toInt());
                        }
                        if (destinationAvailability == null) {
                            request.putShort((short)-1);
                        } else {
                            request.putShort((short)destinationAvailability.toInt());
                        }
                        request.putString(destinationNamePattern);
                        CommsByteBuffer reply = this.jfapExchange(request, 119, 7, true);
                        try {
                            short err = 0;
                            err = reply.getCommandCompletionCode(253);
                            if (err != 0) {
                                this.checkFor_SIIncorrectCallException(reply, err);
                                this.checkFor_SICommandInvocationFailedException(reply, err);
                                this.checkFor_SIConnectionUnavailableException(reply, err);
                                this.checkFor_SIConnectionDroppedException(reply, err);
                                this.checkFor_SIConnectionLostException(reply, err);
                                this.defaultChecker(reply, err);
                            } else {
                                reply.getShort();
                                int count = reply.getShort();
                                rc = new SIDestinationAddress[count];
                                for (int i = 0; i < count; ++i) {
                                    rc[i] = reply.getSIDestinationAddress(this.getConversation().getHandshakeProperties().getFapLevel());
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)(count + " SIDestinationAddress objects received"));
                                }
                            }
                        }
                        finally {
                            reply.release();
                        }
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block21;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"interrupted exception");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addDestinationListener", rc);
        }
        return rc;
    }

    public AsyncCallbackSynchronizer getAsyncCallbackSynchronizer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAsyncCallbackSynchronizer");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAsyncCallbackSynchronizer", (Object)this.asyncCallbackSynchronizer);
        }
        return this.asyncCallbackSynchronizer;
    }

    public void setStrictRedeliveryOrdering(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStrictRedeliveryOrdering", (Object)new Boolean(value));
        }
        this.strictRedeliveryOrdering = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setStrictRedeliveryOrdering");
        }
    }

    protected boolean getStrictRedeliveryOrdering() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStrictRedeliveryOrdering");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStrictRedeliveryOrdering", (Object)this.strictRedeliveryOrdering);
        }
        return this.strictRedeliveryOrdering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerConsumerSetMonitor(SIDestinationAddress destinationAddress, String discriminatorExpression, ConsumerSetChangeCallback callback) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIConnectionUnavailableException, SIConnectionDroppedException, SIIncorrectCallException, SICommandInvocationFailedException {
        boolean areConsumers = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)new Object[]{destinationAddress, discriminatorExpression, callback});
        }
        HandshakeProperties props = this.getConversation().getHandshakeProperties();
        CommsUtils.checkFapLevel(props, (short)14);
        if (callback == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_CONSUMERSETCHANGECALLBACK_SICO1069", null, null));
        }
        if (destinationAddress == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_DESTINATIONADDRESS_SICO1070", null, null));
        }
        if (discriminatorExpression == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("NULL_DISCRIMINATOREXPRESSION_SICO1071", null, null));
        }
        Object object = this.generalLock;
        synchronized (object) {
            block22: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.checkAlreadyClosed();
                        CommsByteBuffer request = this.getCommsByteBuffer();
                        request.putShort(this.getConnectionObjectID());
                        request.putSIDestinationAddress(destinationAddress, this.getConversation().getHandshakeProperties().getFapLevel());
                        request.putString(discriminatorExpression);
                        ClientConversationState state = (ClientConversationState)this.getConversation().getAttachment();
                        short consumerMonitorListenerID = state.getConsumerMonitorListenerCache().add(callback);
                        request.putShort(consumerMonitorListenerID);
                        CommsByteBuffer reply = this.jfapExchange(request, 131, 7, true);
                        try {
                            short err = 0;
                            err = reply.getCommandCompletionCode(132);
                            if (err != 0) {
                                this.checkFor_SIResourceException(reply, err);
                                this.checkFor_SINotPossibleInCurrentConfigurationException(reply, err);
                                this.checkFor_SIConnectionUnavailableException(reply, err);
                                this.checkFor_SIConnectionDroppedException(reply, err);
                                this.checkFor_SIIncorrectCallException(reply, err);
                                this.checkFor_SICommandInvocationFailedException(reply, err);
                                this.defaultChecker(reply, err);
                            } else {
                                reply.getShort();
                                areConsumers = reply.getBoolean();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Are there any consumers : " + areConsumers));
                                }
                            }
                        }
                        finally {
                            reply.release();
                        }
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block22;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"interrupted exception");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerConsumerSetMonitor", (Object)areConsumers);
        }
        return areConsumers;
    }

    static {
        boolean propertyValue;
        block4: {
            CLASS_NAME = ConnectionProxy.class.getName();
            tc = SibTr.register(ConnectionProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
            nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.217 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ConnectionProxy.java, SIB.comms, WASX.SIB, uu1215.01 11/09/15 07:55:15 [4/12/12 22:14:06]");
            }
            propertyValue = false;
            try {
                propertyValue = CommsUtils.getRuntimeBooleanProperty("sib.comms.StrictRedeliveryOrdering", "false");
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<clinit>"), (String)"1-002-0010", null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Encountered error querying strict redelivery enablement");
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
        defaultStrictRedeliveryOrdering = propertyValue;
        HIGH_QUEUE_BYTES = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytes", "102400");
        exchangeTransactedSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceTransactedSendExchange", "false");
        exchangeExpressSends = CommsUtils.getRuntimeBooleanProperty("sib.comms.ForceExpressSendExchange", "false");
    }
}

