/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class LogicalUnitOfWork
implements Serializable,
SimplifiedSerialization {
    private static final Class cclass = LogicalUnitOfWork.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = -3343809099276071578L;
    public long identifier;
    protected byte[] XID;
    protected static final int maximumXIDSize = 255;
    private static final byte SimpleSerialVersion = 0;

    protected LogicalUnitOfWork(long identifier) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Long(identifier));
        }
        this.identifier = identifier;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected LogicalUnitOfWork(DataInputStream dataInputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "DataInputStream=" + dataInputStream);
        }
        this.readObject(dataInputStream, null);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected static long maximumSerializedSize() {
        return 265L;
    }

    protected void writeSerializedBytes(ObjectManagerByteArrayOutputStream buffer) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeSerializedBytes", new Object[]{buffer});
        }
        buffer.write(0);
        buffer.writeLong(this.identifier);
        if (this.XID == null) {
            buffer.write(0);
        } else {
            buffer.write((byte)(this.XID.length >>> 0));
            buffer.write(this.XID, 0, this.XID.length);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "writeSerializedBytes", new Object[]{buffer});
        }
    }

    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", "dataOutputStream=" + dataOutputStream);
        }
        try {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeLong(this.identifier);
            if (this.XID == null) {
                dataOutputStream.writeByte(0);
            } else {
                dataOutputStream.writeByte(this.XID.length);
                dataOutputStream.write(this.XID);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:177:1.9");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "writeObject");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "readObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", "version=" + version + "(byte)");
            }
            this.identifier = dataInputStream.readLong();
            int XIDLength = dataInputStream.readUnsignedByte();
            if (XIDLength > 0) {
                this.XID = new byte[XIDLength];
                dataInputStream.read(this.XID);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:217:1.9");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    public String toString() {
        return new String("LogicalUnitOfWork(" + this.identifier + ")/" + Integer.toHexString(this.hashCode()));
    }
}

