/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.IThreadRootController;
import com.ibm.jbatch.container.callback.IJobExecutionEndCallbackService;
import com.ibm.jbatch.container.callback.IJobExecutionStartCallbackService;
import com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class BatchWorkUnit
implements Runnable {
    private final String CLASSNAME = BatchWorkUnit.class.getName();
    private final Logger logger = Logger.getLogger(BatchWorkUnit.class.getName());
    protected RuntimeWorkUnitExecution runtimeWorkUnitExecution = null;
    protected IBatchKernelService batchKernel = null;
    protected IThreadRootController controller;
    protected List<IJobExecutionStartCallbackService> beforeCallbacks;
    protected List<IJobExecutionEndCallbackService> afterCallbacks;
    protected TransactionManager tranMgr;
    protected boolean notifyCallbackWhenDone;
    static final long serialVersionUID = 9010121835254588580L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeWorkUnitExecution runtimeExecution, List<IJobExecutionStartCallbackService> beforeCallbacks, List<IJobExecutionEndCallbackService> afterCallbacks, TransactionManager tranMgr) {
        this(batchKernel, runtimeExecution, beforeCallbacks, afterCallbacks, tranMgr, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeWorkUnitExecution runtimeExecution, List<IJobExecutionStartCallbackService> beforeCallbacks, List<IJobExecutionEndCallbackService> afterCallbacks, TransactionManager tranMgr, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.runtimeWorkUnitExecution = runtimeExecution;
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.controller = new WorkUnitThreadControllerImpl(this.runtimeWorkUnitExecution);
        this.beforeCallbacks = beforeCallbacks;
        this.afterCallbacks = afterCallbacks;
        this.tranMgr = tranMgr;
    }

    public IThreadRootController getController() {
        return this.controller;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        try {
            this.threadBegin();
            this.runtimeWorkUnitExecution.logExecutionStartingMessage();
            this.controller.runExecutionOnThread();
            if (this.runtimeWorkUnitExecution.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) {
                this.runtimeWorkUnitExecution.logExecutionCompletedMessage();
            } else if (this.runtimeWorkUnitExecution.getBatchStatus().equals((Object)BatchStatus.STOPPED)) {
                this.runtimeWorkUnitExecution.logExecutionStoppedMessage();
            } else {
                this.runtimeWorkUnitExecution.logExecutionFailedMessage();
            }
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"122", (Object)this, (Object[])new Object[0]);
            this.runtimeWorkUnitExecution.logExecutionFailedMessage();
            throw new BatchContainerRuntimeException("The job failed unexpectedly.", (Throwable)t);
        }
        finally {
            this.threadEnd();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    protected BatchStatus getBatchStatus() {
        return this.runtimeWorkUnitExecution.getWorkUnitJobContext().getBatchStatus();
    }

    protected String getExitStatus() {
        return this.runtimeWorkUnitExecution.getWorkUnitJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution) {
        this.runtimeWorkUnitExecution = runtimeWorkUnitExecution;
    }

    public RuntimeWorkUnitExecution getRuntimeWorkUnitExecution() {
        return this.runtimeWorkUnitExecution;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }

    /*
     * WARNING - void declaration
     */
    protected void threadBegin() {
        try {
            this.tranMgr.setTransactionTimeout(0);
            if (this.beforeCallbacks != null) {
                for (IJobExecutionStartCallbackService callback : this.beforeCallbacks) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.logp(Level.FINER, this.CLASSNAME, "threadBegin", "Calling before callback", callback);
                    }
                    callback.jobStarted(this.runtimeWorkUnitExecution);
                }
            }
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"191", (Object)this, (Object[])new Object[0]);
            this.runtimeWorkUnitExecution.logExecutionFailedMessage();
            throw new BatchContainerRuntimeException("An error occurred during thread initialization.", (Throwable)t);
        }
    }

    protected void threadEnd() {
        try {
            this.getBatchKernel().workUnitCompleted(this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"217", (Object)this, (Object[])new Object[0]);
        }
        if (this.afterCallbacks != null) {
            for (IJobExecutionEndCallbackService callback : this.afterCallbacks) {
                try {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.logp(Level.FINER, this.CLASSNAME, "threadEnd", "Calling after callback", callback);
                    }
                    callback.jobEnded(this.runtimeWorkUnitExecution);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"228", (Object)this, (Object[])new Object[0]);
                }
            }
        }
        try {
            this.tranMgr.setTransactionTimeout(0);
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"236", (Object)this, (Object[])new Object[0]);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.util.BatchWorkUnit", BatchWorkUnit.class, null, null);
    }
}

