/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.metadata.CollectionMatch;
import com.ibm.ws.webcontainer.security.metadata.ResponseAggregate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MatchResponse {
    public static final MatchResponse NO_MATCH_RESPONSE;
    public static final MatchResponse CUSTOM_NO_MATCH_RESPONSE;
    public static final MatchResponse DENY_MATCH_RESPONSE;
    public static final MatchResponse DENY_MATCH_BY_OMISSION_RESPONSE;
    private final List<String> roles;
    private final boolean sslRequired;
    private final boolean accessPrecluded;
    private CollectionMatch collectionMatch;
    static final long serialVersionUID = 17074771431993823L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MatchResponse(List<String> roles, boolean sslRequired, boolean accessPrecluded) {
        if (accessPrecluded && roles != null && roles.size() > 0) {
            throw new IllegalArgumentException("The roles must be empty when access is precluded.");
        }
        this.roles = roles;
        this.sslRequired = sslRequired;
        this.accessPrecluded = accessPrecluded;
    }

    public MatchResponse(List<String> roles, boolean sslRequired, boolean accessPrecluded, CollectionMatch collectionMatch) {
        this(roles, sslRequired, accessPrecluded);
        this.collectionMatch = collectionMatch;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isSSLRequired() {
        return this.sslRequired;
    }

    public boolean isAccessPrecluded() {
        return this.accessPrecluded;
    }

    public ResponseAggregate aggregateResponse(ResponseAggregate responseAggregate) {
        if (this.collectionMatch.isExactMatch()) {
            MatchResponse exactMatchResponse = this.merge(responseAggregate.getExactMatchResponse());
            responseAggregate.setExactMatchResponse(exactMatchResponse);
        } else if (this.collectionMatch.isPathMatch() && this.collectionMatch.getUrlPattern().length() > responseAggregate.getLongestPathUrlPattern().length()) {
            responseAggregate.setPathMatchResponse(this);
            responseAggregate.setLongestPathUrlPattern(this.collectionMatch.getUrlPattern());
        } else if (this.collectionMatch.isPathMatch() && this.collectionMatch.getUrlPattern().length() == responseAggregate.getLongestPathUrlPattern().length()) {
            MatchResponse pathMatchResponse = this.merge(responseAggregate.getPathMatchResponse());
            responseAggregate.setPathMatchResponse(pathMatchResponse);
            responseAggregate.setLongestPathUrlPattern(this.collectionMatch.getUrlPattern());
        } else if (this.collectionMatch.isExtensionMatch()) {
            MatchResponse extensionMatchResponse = this.merge(responseAggregate.getExtensionMatchResponse());
            responseAggregate.setExtensionMatchResponse(extensionMatchResponse);
        } else if (this.collectionMatch.isDenyMatch()) {
            MatchResponse denyMatchResponse = this.merge(responseAggregate.getDenyMatchResponse());
            responseAggregate.setDenyMatchResponse(denyMatchResponse);
        } else if (this.collectionMatch.isDenyMatchByOmission()) {
            MatchResponse denyMatchByOmissionResponse = this.merge(responseAggregate.getDenyMatchByOmissionResponse());
            responseAggregate.setDenyMatchByOmissionResponse(denyMatchByOmissionResponse);
        }
        return responseAggregate;
    }

    public CollectionMatch getCollectionMatch() {
        return this.collectionMatch;
    }

    public MatchResponse merge(MatchResponse matchResponse) {
        if (matchResponse == null || matchResponse == this) {
            return this;
        }
        boolean mergedSSLRequired = this.mergeSSLRequired(matchResponse.isSSLRequired());
        boolean mergedAccessPrecluded = this.mergeAccessPrecluded(matchResponse.isAccessPrecluded());
        List<String> mergedRoles = this.mergeRoles(matchResponse.getRoles(), mergedAccessPrecluded);
        return new MatchResponse(mergedRoles, mergedSSLRequired, mergedAccessPrecluded);
    }

    protected boolean mergeSSLRequired(boolean otherSSLRequired) {
        boolean mergedSSLRequired = false;
        if (this.collectionMatch.isExactMatch()) {
            mergedSSLRequired = this.sslRequired && otherSSLRequired;
        } else if (this.collectionMatch.isPathMatch() || this.collectionMatch.isExtensionMatch()) {
            mergedSSLRequired = this.sslRequired || otherSSLRequired;
        }
        return mergedSSLRequired;
    }

    protected boolean mergeAccessPrecluded(boolean otherAccessPrecluded) {
        return this.accessPrecluded || otherAccessPrecluded;
    }

    protected List<String> mergeRoles(List<String> otherRoles, boolean mergedAccessPrecluded) {
        if (mergedAccessPrecluded || this.roles.isEmpty() || otherRoles.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet<String> tempRoles = new HashSet<String>();
        tempRoles.addAll(otherRoles);
        tempRoles.addAll(this.roles);
        ArrayList<String> mergedRoles = new ArrayList<String>();
        mergedRoles.addAll(tempRoles);
        return mergedRoles;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.metadata.MatchResponse", MatchResponse.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
        NO_MATCH_RESPONSE = new MatchResponse(Collections.EMPTY_LIST, false, false);
        CUSTOM_NO_MATCH_RESPONSE = new MatchResponse(Collections.EMPTY_LIST, false, true);
        DENY_MATCH_RESPONSE = new MatchResponse(Collections.EMPTY_LIST, false, false);
        DENY_MATCH_BY_OMISSION_RESPONSE = new MatchResponse(Collections.EMPTY_LIST, false, false);
    }
}

