/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ConnectionDescriptor;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.util.HashMap;
import java.util.Map;

public class VirtualConnectionImpl
implements VirtualConnection {
    private static final TraceComponent tc = Tr.register(VirtualConnectionImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private static long ONE_MILLISECOND_IN_NANOSECONDS = 1000000L;
    private Map<Object, Object> stateStore = null;
    private static int READ_PENDING = 4097;
    private static int READ_WAITING = 4098;
    private static int READ_FINISHING = 4100;
    private static int WRITE_PENDING = 4112;
    private static int WRITE_WAITING = 4128;
    private static int WRITE_FINISHING = 4160;
    private static int CLOSE_PENDING = 4352;
    private static int IN_USE_MASK = 4096;
    private static int IN_USE_MASK_CLEAR_OUT = ~IN_USE_MASK;
    private static int READ_PENDING_CLEAR_OUT = ~(READ_FINISHING | READ_WAITING) | IN_USE_MASK;
    private static int READ_FINISHING_CLEAR_OUT = ~(READ_PENDING | READ_WAITING) | IN_USE_MASK;
    private static int READ_WAITING_CLEAR_OUT = ~(READ_PENDING | READ_FINISHING) | IN_USE_MASK;
    private static int READ_DONE_CLEAR_OUT = ~(READ_PENDING | READ_FINISHING | READ_WAITING) | IN_USE_MASK;
    private static int WRITE_PENDING_CLEAR_OUT = ~(WRITE_FINISHING | WRITE_WAITING) | IN_USE_MASK;
    private static int WRITE_FINISHING_CLEAR_OUT = ~(WRITE_PENDING | WRITE_WAITING) | IN_USE_MASK;
    private static int WRITE_WAITING_CLEAR_OUT = ~(WRITE_PENDING | WRITE_FINISHING) | IN_USE_MASK;
    private static int WRITE_DONE_CLEAR_OUT = ~(WRITE_PENDING | WRITE_FINISHING | WRITE_WAITING) | IN_USE_MASK;
    private static int CLOSE_NOT_ALLOWED_MASK = (READ_PENDING | READ_FINISHING | WRITE_PENDING | WRITE_FINISHING | CLOSE_PENDING) & IN_USE_MASK_CLEAR_OUT;
    private static int FINISH_NOT_ALLOWED_MASK = CLOSE_PENDING & IN_USE_MASK_CLEAR_OUT;
    private static int READ_NOT_ALLOWED_MASK = (CLOSE_PENDING | READ_PENDING | READ_WAITING | READ_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private static int WRITE_NOT_ALLOWED_MASK = (CLOSE_PENDING | WRITE_PENDING | WRITE_WAITING | WRITE_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private static int READ_OUTSTANDING = (READ_PENDING | READ_WAITING | READ_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private static int WRITE_OUTSTANDING = (WRITE_PENDING | WRITE_WAITING | WRITE_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private boolean closeWaiting = false;
    private int currentState = 0;
    private boolean readOutWithClosePending = false;
    private boolean writeOutWithClosePending = false;
    private boolean inetAddressingValid = true;
    private ConnectionDescriptor connDesc = null;
    private int fileChannelCapable = 0;

    protected VirtualConnectionImpl() {
    }

    protected void init() {
        this.stateStore = new HashMap<Object, Object>();
        this.fileChannelCapable = 0;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Map<Object, Object> getStateMap() {
        return this.stateStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPermissionToRead() {
        boolean rc = false;
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & READ_NOT_ALLOWED_MASK) == 0) {
                this.currentState = (this.currentState | READ_PENDING) & READ_PENDING_CLEAR_OUT;
                rc = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requestPermissionToRead returning " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPermissionToWrite() {
        boolean rc = false;
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & WRITE_NOT_ALLOWED_MASK) == 0) {
                this.currentState = (this.currentState | WRITE_PENDING) & WRITE_PENDING_CLEAR_OUT;
                rc = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requestPermissionToWrite returning " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public boolean isCloseWithReadOutstanding() {
        if (this.currentState == CLOSE_PENDING) {
            return this.readOutWithClosePending;
        }
        return false;
    }

    @Override
    public boolean isCloseWithWriteOutstanding() {
        if (this.currentState == CLOSE_PENDING) {
            return this.writeOutWithClosePending;
        }
        return false;
    }

    @Override
    public boolean getCloseWaiting() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCloseWaiting returning: " + this.closeWaiting), (Object[])new Object[0]);
        }
        return this.closeWaiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPermissionToClose(long waitForPermission) {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & CLOSE_NOT_ALLOWED_MASK) == 0) {
                this.readOutWithClosePending = (this.currentState & READ_OUTSTANDING) != 0;
                this.writeOutWithClosePending = (this.currentState & WRITE_OUTSTANDING) != 0;
                this.currentState = CLOSE_PENDING;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"requestPermissionToClose returning true", (Object[])new Object[0]);
                }
                return true;
            }
            if (waitForPermission <= 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"requestPermissionToClose returning false", (Object[])new Object[0]);
                }
                return false;
            }
            long waitTillTime = System.nanoTime() / ONE_MILLISECOND_IN_NANOSECONDS + waitForPermission;
            long waitTime = waitForPermission;
            try {
                do {
                    this.closeWaiting = true;
                    this.wait(waitTime);
                    this.closeWaiting = false;
                    if ((this.currentState & CLOSE_NOT_ALLOWED_MASK) != 0) continue;
                    this.readOutWithClosePending = (this.currentState & READ_OUTSTANDING) != 0;
                    this.writeOutWithClosePending = (this.currentState & WRITE_OUTSTANDING) != 0;
                    this.currentState = CLOSE_PENDING;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"requestPermissionToClose returning(2) true", (Object[])new Object[0]);
                    }
                    return true;
                } while ((waitTime = waitTillTime - System.nanoTime() / ONE_MILLISECOND_IN_NANOSECONDS) > 0L);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"requestPermissionToClose returning(2) false", (Object[])new Object[0]);
                }
                return false;
            }
            catch (InterruptedException x) {
                if ((this.currentState & CLOSE_NOT_ALLOWED_MASK) == 0) {
                    this.readOutWithClosePending = (this.currentState & READ_OUTSTANDING) != 0;
                    this.writeOutWithClosePending = (this.currentState & WRITE_OUTSTANDING) != 0;
                    this.currentState = CLOSE_PENDING;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"requestPermissionToClose returning(3) true", (Object[])new Object[0]);
                    }
                    return true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"requestPermissionToClose returning(3) false", (Object[])new Object[0]);
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadStateToDone() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            this.currentState &= READ_DONE_CLEAR_OUT;
            if (this.closeWaiting) {
                this.notify();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setReadStateToDone", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWriteStateToDone() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            this.currentState &= WRITE_DONE_CLEAR_OUT;
            if (this.closeWaiting) {
                this.notify();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setWriteStateToDone", (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInputStateTrackingOperational() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            return this.currentState != 0;
        }
    }

    @Override
    public Object getLockObject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPermissionToFinishRead() {
        boolean rc = true;
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & FINISH_NOT_ALLOWED_MASK) != 0) {
                rc = false;
            } else {
                this.currentState = (this.currentState | READ_FINISHING) & READ_FINISHING_CLEAR_OUT;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requestPermissionToFinishRead returning " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestPermissionToFinishWrite() {
        boolean rc = true;
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & FINISH_NOT_ALLOWED_MASK) != 0) {
                rc = false;
            } else {
                this.currentState = (this.currentState | WRITE_FINISHING) & WRITE_FINISHING_CLEAR_OUT;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requestPermissionToFinishWrite returning " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public void setReadStatetoCloseAllowedNoSync() {
        this.currentState = (this.currentState | READ_WAITING) & READ_WAITING_CLEAR_OUT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadStatetoCloseAllowedNoSync", (Object[])new Object[0]);
        }
    }

    @Override
    public void setWriteStatetoCloseAllowedNoSync() {
        this.currentState = (this.currentState | WRITE_WAITING) & WRITE_WAITING_CLEAR_OUT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setWriteStatetoCloseAllowedNoSync", (Object[])new Object[0]);
        }
    }

    @Override
    public void setInetAddressingValid(boolean _newValue) {
        this.inetAddressingValid = _newValue;
    }

    @Override
    public boolean getInetAddressingValid() {
        return this.inetAddressingValid;
    }

    @Override
    public void setConnectionDescriptor(ConnectionDescriptor _newObject) {
        this.connDesc = _newObject;
    }

    @Override
    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connDesc;
    }

    @Override
    public int attemptToSetFileChannelCapable(int value) {
        if (value == 1) {
            this.fileChannelCapable = 1;
        } else if (value == 2 && this.fileChannelCapable == 0) {
            this.fileChannelCapable = 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set file channel capable: " + this.fileChannelCapable), (Object[])new Object[0]);
        }
        return this.fileChannelCapable;
    }

    @Override
    public int getFileChannelCapable() {
        return this.fileChannelCapable;
    }

    @Override
    public boolean isFileChannelCapable() {
        return this.fileChannelCapable == 2;
    }
}

