/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.cdi.Namespace;
import io.openliberty.data.internal.persistence.provider.PUnitEMBuilder;
import io.openliberty.data.internal.persistence.service.DBStoreEMBuilder;
import jakarta.data.exceptions.DataException;
import jakarta.persistence.EntityManagerFactory;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FutureEMBuilder
extends CompletableFuture<EntityManagerBuilder>
implements DDLGenerationParticipant,
Comparable<FutureEMBuilder> {
    private static final TraceComponent tc = Tr.register(FutureEMBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final long DDLGEN_WAIT_TIME = 15L;
    private final String application;
    private final String module;
    final String dataStore;
    final Set<Class<?>> entityTypes = new HashSet();
    public final boolean inWebModule;
    public final J2EEName jeeName;
    private final Namespace namespace;
    private final DataProvider provider;
    private final ClassLoader repositoryClassLoader;
    private final Set<Class<?>> repositoryInterfaces = new HashSet();
    static final long serialVersionUID = -2343207769620249538L;

    FutureEMBuilder(DataProvider provider, Class<?> repositoryInterface, ClassLoader repositoryClassLoader, String dataStore) {
        this.provider = provider;
        this.repositoryClassLoader = repositoryClassLoader;
        this.dataStore = dataStore;
        this.jeeName = this.getArtifactName(repositoryInterface, repositoryClassLoader, provider);
        this.namespace = Namespace.of(dataStore);
        if (Namespace.APP.isMoreGranularThan(this.namespace)) {
            this.application = null;
            this.module = null;
        } else {
            this.application = this.jeeName.getApplication();
            if (Namespace.MODULE.isMoreGranularThan(this.namespace)) {
                this.module = null;
            } else {
                this.module = this.jeeName.getModule();
                if (this.module == null) {
                    throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1060.name.out.of.scope", new Object[]{repositoryInterface.getName(), this.jeeName.getApplication(), dataStore, "dataStore", this.namespace, "java:app"});
                }
            }
        }
        String clIdentifier = provider.classloaderIdSvc.getClassLoaderIdentifier(repositoryClassLoader);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("class loader identifier: " + clIdentifier), (Object[])new Object[0]);
        }
        this.inWebModule = clIdentifier.startsWith("WebModule:");
        this.addRepositoryInterface(repositoryInterface);
    }

    @Trivial
    void addEntity(Class<?> entityClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("addEntity: " + entityClass.getName()), (Object[])new Object[0]);
        }
        this.entityTypes.add(entityClass);
    }

    @Trivial
    void addRepositoryInterface(Class<?> repositoryInterface) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("addRepositoryInterface: " + repositoryInterface.getName()), (Object[])new Object[0]);
        }
        this.repositoryInterfaces.add(repositoryInterface);
    }

    public void registerDDLGenerationParticipant(String appName) {
        ConcurrentLinkedQueue<ServiceRegistration<DDLGenerationParticipant>> empty;
        BundleContext thisbc = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceRegistration ddlgenreg = thisbc.registerService(DDLGenerationParticipant.class, (Object)this, null);
        ConcurrentLinkedQueue<ServiceRegistration<DDLGenerationParticipant>> ddlgenRegistrations = this.provider.ddlgeneratorsAllApps.get(appName);
        if (ddlgenRegistrations == null && (ddlgenRegistrations = (ConcurrentLinkedQueue<ServiceRegistration<DDLGenerationParticipant>>)this.provider.ddlgeneratorsAllApps.putIfAbsent(appName, empty = new ConcurrentLinkedQueue<ServiceRegistration<DDLGenerationParticipant>>())) == null) {
            ddlgenRegistrations = empty;
        }
        ddlgenRegistrations.add((ServiceRegistration<DDLGenerationParticipant>)ddlgenreg);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public String getDDLFileName() {
        try {
            EntityManagerBuilder builder = (EntityManagerBuilder)this.get(15L, TimeUnit.SECONDS);
            if (builder instanceof DDLGenerationParticipant) {
                return ((DDLGenerationParticipant)builder).getDDLFileName();
            }
        }
        catch (TimeoutException builder) {
            FFDCFilter.processException((Throwable)builder, (String)"io.openliberty.data.internal.persistence.cdi.FutureEMBuilder", (String)"226", (Object)this, (Object[])new Object[0]);
            throw DataExtension.exc(DataException.class, "CWWKD1067.ddlgen.emf.timeout", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.dataStore, 15L, this.entityTypes.stream().map(Class::getName).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.data.internal.persistence.cdi.FutureEMBuilder", (String)"235", (Object)this, (Object[])new Object[0]);
            Throwable cause = ex instanceof ExecutionException ? ex.getCause() : ex;
            DataException dx = DataExtension.exc(DataException.class, "CWWKD1066.ddlgen.failed", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.dataStore, this.entityTypes.stream().map(Class::getName).collect(Collectors.toList()), cause.getMessage());
            throw (DataException)dx.initCause((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public void generate(Writer out) throws Exception {
        try {
            EntityManagerBuilder builder = (EntityManagerBuilder)this.get(15L, TimeUnit.SECONDS);
            if (builder instanceof DDLGenerationParticipant) {
                ((DDLGenerationParticipant)builder).generate(out);
            }
        }
        catch (TimeoutException builder) {
            FFDCFilter.processException((Throwable)builder, (String)"io.openliberty.data.internal.persistence.cdi.FutureEMBuilder", (String)"262", (Object)this, (Object[])new Object[]{out});
            throw DataExtension.exc(DataException.class, "CWWKD1065.ddlgen.timeout", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.dataStore, 15L, this.entityTypes.stream().map(Class::getName).collect(Collectors.toList()));
        }
        catch (Throwable e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.data.internal.persistence.cdi.FutureEMBuilder", (String)"271", (Object)this, (Object[])new Object[]{out});
            Throwable cause = ex instanceof ExecutionException ? ex.getCause() : ex;
            DataException dx = DataExtension.exc(DataException.class, "CWWKD1066.ddlgen.failed", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.dataStore, this.entityTypes.stream().map(Class::getName).collect(Collectors.toList()), cause.getMessage());
            throw (DataException)dx.initCause((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={Throwable.class})
    public EntityManagerBuilder createEMBuilder() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ComponentMetaData metadata = this.provider.componentMetadatasForModules.get(this.jeeName);
        try {
            if (this.namespace == Namespace.COMP && !this.inWebModule && this.jeeName.getModule() != null && !"java:comp/DefaultDataSource".equals(this.dataStore)) {
                throw DataExtension.exc(DataException.class, "CWWKD1061.comp.name.in.ejb", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.jeeName.getModule(), this.jeeName.getApplication(), this.dataStore, "dataStore", "java:comp", List.of("java:app", "java:module"));
            }
            if (metadata == null) {
                String appName = this.jeeName.getApplication();
                String modName = this.jeeName.getModule();
                String metadataIdentifier = null;
                if (modName == null) {
                    metadataIdentifier = this.provider.getMetaDataIdentifier(appName, null, null);
                } else if (this.inWebModule && !this.provider.metadataIdSvc.isMetaDataAvailable(metadataIdentifier = this.provider.metadataIdSvc.getMetaDataIdentifier("WEB", appName, modName, null))) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("not available: " + metadataIdentifier), (Object[])new Object[0]);
                    }
                    metadataIdentifier = null;
                }
                if (metadataIdentifier == null) {
                    metadataIdentifier = this.provider.metadataIdSvc.getMetaDataIdentifier("EJB", appName, modName, null);
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("metadata identifier: " + metadataIdentifier), (Object[])new Object[0]);
                }
                metadata = (ComponentMetaData)this.provider.metadataIdSvc.getMetaData(metadataIdentifier);
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("using metadata: " + String.valueOf(metadata)), (Object[])new Object[0]);
            }
            if (this.namespace != null) {
                ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
                if (metadata == null) {
                    accessor.beginDefaultContext();
                } else {
                    accessor.beginContext(metadata);
                }
                try {
                    Object resource = InitialContext.doLookup(this.dataStore);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)(this.dataStore + " is the JNDI name for " + String.valueOf(resource)), (Object[])new Object[0]);
                    }
                    if (resource instanceof EntityManagerFactory) {
                        PUnitEMBuilder pUnitEMBuilder = new PUnitEMBuilder(this.provider, this.repositoryClassLoader, this.repositoryInterfaces, (EntityManagerFactory)resource, this.dataStore, metadata, this.entityTypes);
                        return pUnitEMBuilder;
                    }
                }
                finally {
                    accessor.endContext();
                }
            }
            boolean javacolon = this.namespace != null;
            return new DBStoreEMBuilder(this.provider, this.repositoryClassLoader, this.repositoryInterfaces, this.dataStore, javacolon, metadata, this.entityTypes);
        }
        catch (Throwable x) {
            if (x instanceof DataException) {
                throw (DataException)x;
            }
            if (!(x instanceof NamingException)) {
                throw (DataException)DataExtension.exc(DataException.class, "CWWKD1080.datastore.general.err", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.jeeName, this.dataStore, x).initCause(x);
            }
            if (this.namespace == null) {
                throw this.excDataStoreNotFound(this.jeeName, metadata, x);
            }
            if (!"java:comp/DefaultDataSource".equals(this.dataStore)) throw this.excJNDINameNotFound(this.jeeName, x);
            throw this.excDefaultDataSourceNotFound(this.jeeName, x);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof FutureEMBuilder)) return false;
        FutureEMBuilder b = (FutureEMBuilder)o;
        if (!this.dataStore.equals(b.dataStore)) return false;
        if (!Objects.equals(this.application, b.application)) return false;
        if (!Objects.equals(this.module, b.module)) return false;
        if (!Objects.equals(this.repositoryClassLoader, b.repositoryClassLoader)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={NamingException.class})
    private DataException excDataStoreNotFound(J2EEName jeeName, ComponentMetaData metadata, Throwable cause) {
        DataException x = null;
        if (metadata != null) {
            ComponentMetaDataAccessorImpl accessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            accessor.beginContext(metadata);
            try {
                String javaCompName = "java:comp/env/" + this.dataStore;
                Object resource = InitialContext.doLookup(javaCompName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(javaCompName + " is the JNDI name for " + String.valueOf(resource)), (Object[])new Object[0]);
                }
                if (resource instanceof DataSource || resource instanceof EntityManagerFactory) {
                    x = DataExtension.exc(DataException.class, "CWWKD1027.datastore.lacks.java.comp", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), jeeName, this.dataStore, "dataStore = \"" + javaCompName + "\"");
                }
            }
            catch (NamingException javaCompName) {
            }
            finally {
                accessor.endContext();
            }
        }
        if (x == null) {
            Class repoInterface = (Class)this.repositoryInterfaces.stream().findFirst().get();
            Class<?> primary = DataExtension.getPrimaryEntityType(repoInterface);
            String exampleEntityClassName = primary == null ? "org.example.MyEntity" : primary.getName();
            String persistenceUnitExample = "\n<persistence-unit name=\"MyPersistenceUnit\">\n  <jta-data-source>jdbc/ds</jta-data-source>\n  <class>" + exampleEntityClassName + "</class>\n  <properties>\n    <property name=\"jakarta.persistence.schema-generation.database.action\" value=\"create\"/>\n  </properties>\n</persistence-unit>\n";
            String dataSourceConfigExample = "\n<dataSource id=\"MyDataSource\" jndiName=\"jdbc/ds\">\n  <jdbcDriver libraryRef=\"PostgresLib\"/>\n  <properties.postgresql databaseName=\"exampledb\" serverName=\"localhost\" portNumber=\"5432\"/>\n  <containerAuthData user=*** password=***/>\n</dataSource>\n<library id=\"PostgresLib\">\n  <fileset dir=\"${server.config.dir}/lib/postgres\" includes=\"*.jar\"/>\n</library>\n";
            String databaseStoreConfigExample = "\n<databaseStore id=\"MyDatabaseStore\" dataSourceRef=\"MyDataSource\" createTables=\"true\" tablePrefix=\"\">\n  <authData user=\"***\" password=\"***\"/>\n</databaseStore>\n";
            x = DataExtension.exc(DataException.class, "CWWKD1078.datastore.not.found", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), jeeName, this.dataStore, dataSourceConfigExample, databaseStoreConfigExample, "@Resource(name=\"java:app/env/jdbc/dsRef\",lookup=\"jdbc/ds\")", "jndiName=\"jdbc/ds\"", "@PersistenceUnit(name=\"java:app/env/MyPersistenceUnitRef\",unitName=\"MyPersistenceUnit\")", persistenceUnitExample);
        }
        return (DataException)x.initCause(cause);
    }

    @Trivial
    private DataException excDefaultDataSourceNotFound(J2EEName jeeName, Throwable cause) {
        Class<?> primary = DataExtension.getPrimaryEntityType((Class)this.repositoryInterfaces.stream().findFirst().get());
        String exampleEntityClassName = primary == null ? "org.example.MyEntity" : primary.getName();
        String persistenceUnitExample = "\n<persistence-unit name=\"MyPersistenceUnit\">\n  <jta-data-source>jdbc/ds</jta-data-source>\n  <class>" + exampleEntityClassName + "</class>\n  <properties>\n    <property name=\"jakarta.persistence.schema-generation.database.action\" value=\"create\"/>\n  </properties>\n</persistence-unit>\n";
        String dataSourceConfigExample = "\n<dataSource id=\"DefaultDataSource\" jndiName=\"jdbc/ds\">\n  <jdbcDriver libraryRef=\"PostgresLib\"/>\n  <properties.postgresql databaseName=\"exampledb\" serverName=\"localhost\" portNumber=\"5432\"/>\n  <containerAuthData user=*** password=***/>\n</dataSource>\n<library id=\"PostgresLib\">\n  <fileset dir=\"${server.config.dir}/lib/postgres\" includes=\"*.jar\"/>\n</library>\n";
        String databaseStoreConfigExample = "\n<databaseStore id=\"MyDatabaseStore\" dataSourceRef=\"DefaultDataSource\" createTables=\"true\" tablePrefix=\"\">\n  <authData user=\"***\" password=\"***\"/>\n</databaseStore>\n";
        DataException x = DataExtension.exc(DataException.class, "CWWKD1077.defaultds.not.found", jeeName, EntityManagerBuilder.getClassNames(this.repositoryInterfaces), this.dataStore, dataSourceConfigExample, databaseStoreConfigExample, "@Resource(name=\"java:app/env/jdbc/dsRef\",lookup=\"jdbc/ds\")", "jndiName=\"jdbc/ds\"", "@PersistenceUnit(name=\"java:app/env/MyPersistenceUnitRef\",unitName=\"MyPersistenceUnit\")", persistenceUnitExample);
        return (DataException)x.initCause(cause);
    }

    @Trivial
    private DataException excJNDINameNotFound(J2EEName jeeName, Throwable cause) {
        Class<?> primary = DataExtension.getPrimaryEntityType((Class)this.repositoryInterfaces.stream().findFirst().get());
        String exampleEntityClassName = primary == null ? "org.example.MyEntity" : primary.getName();
        String persistenceUnitExample = "\n<persistence-unit name=\"MyPersistenceUnit\">\n  <jta-data-source>jdbc/ds</jta-data-source>\n  <class>" + exampleEntityClassName + "</class>\n  <properties>\n    <property name=\"jakarta.persistence.schema-generation.database.action\" value=\"create\"/>\n  </properties>\n</persistence-unit>\n";
        String dataSourceConfigExample = "\n<dataSource jndiName=\"jdbc/ds\">\n  <jdbcDriver libraryRef=\"PostgresLib\"/>\n  <properties.postgresql databaseName=\"exampledb\" serverName=\"localhost\" portNumber=\"5432\"/>\n  <containerAuthData user=*** password=***/>\n</dataSource>\n<library id=\"PostgresLib\">\n  <fileset dir=\"${server.config.dir}/lib/postgres\" includes=\"*.jar\"/>\n</library>\n";
        DataException x = DataExtension.exc(DataException.class, "CWWKD1079.jndi.not.found", EntityManagerBuilder.getClassNames(this.repositoryInterfaces), jeeName, this.dataStore, "@Resource(name=\"java:app/env/jdbc/dsRef\",lookup=\"jdbc/ds\")", "jndiName=\"jdbc/ds\"", "@PersistenceUnit(name=\"java:app/env/MyPersistenceUnitRef\",unitName=\"MyPersistenceUnit\")", persistenceUnitExample, dataSourceConfigExample);
        return (DataException)x.initCause(cause);
    }

    private J2EEName getArtifactName(Class<?> repositoryInterface, ClassLoader repositoryClassLoader, DataProvider provider) {
        J2EEName artifactName;
        Optional moduleNameOptional = provider.cdiService.getModuleNameForClass(repositoryInterface);
        if (moduleNameOptional.isPresent()) {
            artifactName = (J2EEName)moduleNameOptional.get();
        } else {
            ComponentMetaData cdata = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cdata == null) {
                throw new IllegalStateException();
            }
            ApplicationMetaData adata = cdata.getModuleMetaData().getApplicationMetaData();
            cdata = provider.createComponentMetadata(adata, repositoryClassLoader);
            artifactName = cdata.getModuleMetaData().getJ2EEName();
        }
        return artifactName;
    }

    @Trivial
    public int hashCode() {
        return this.dataStore.hashCode() + (this.application == null ? 0 : this.application.hashCode()) + (this.module == null ? 0 : this.module.hashCode());
    }

    @Trivial
    @FFDCIgnore(value={Throwable.class})
    public Optional<EntityManagerBuilder> introspect(PrintWriter writer, String indent) {
        writer.println(indent + "FutureEMBuilder@" + Integer.toHexString(this.hashCode()));
        writer.println(indent + "  dataStore: " + this.dataStore);
        writer.println(indent + "  namespace: " + String.valueOf((Object)this.namespace));
        writer.println(indent + "    application: " + this.application);
        writer.println(indent + "    module: " + this.module);
        writer.println(indent + "  defining artifact: " + String.valueOf(this.jeeName));
        writer.println(indent + "  repository class loader: " + String.valueOf(this.repositoryClassLoader));
        this.repositoryInterfaces.forEach(r -> writer.println(indent + "  repository: " + (r == null ? null : r.getName())));
        this.entityTypes.forEach(e -> writer.println(indent + "  entity: " + (e == null ? null : e.getName())));
        EntityManagerBuilder builder = null;
        writer.print(indent + "  state: ");
        if (this.isCancelled()) {
            writer.println("cancelled");
        } else if (this.isDone()) {
            try {
                builder = (EntityManagerBuilder)this.join();
                writer.println("completed");
            }
            catch (Throwable x) {
                writer.println("failed");
                Util.printStackTrace(x, writer, indent + "  ", null);
            }
        } else {
            writer.println("not completed");
        }
        writer.println(indent + "  builder: " + String.valueOf(builder));
        return Optional.ofNullable(builder);
    }

    @Override
    @Trivial
    public String toString() {
        int len = 40 + this.dataStore.length() + (this.application == null ? 4 : this.application.length()) + (this.module == null ? 4 : this.module.length());
        StringBuilder b = new StringBuilder(len).append("FutureEMBuilder@").append(Integer.toHexString(this.hashCode())).append("(id=").append(Integer.toHexString(System.identityHashCode(this))).append(") ").append(this.dataStore).append(' ').append(this.application).append('#').append(this.module);
        return b.toString();
    }

    @Override
    @Trivial
    public int compareTo(FutureEMBuilder o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.application != null && o.application != null && !this.application.equals(o.application)) {
            return this.application.compareTo(o.application);
        }
        if (this.module != null && o.module != null && !this.module.equals(o.module)) {
            return this.module.compareTo(o.module);
        }
        if (!this.dataStore.equals(o.dataStore)) {
            return this.dataStore.compareTo(o.dataStore);
        }
        String r0 = this.repositoryInterfaces.stream().map(c -> c.getCanonicalName()).sorted().collect(Collectors.joining());
        String r1 = o.repositoryInterfaces.stream().map(c -> c.getCanonicalName()).sorted().collect(Collectors.joining());
        return r0.compareTo(r1);
    }
}

