/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ws.logging.hpel.LogRepositoryManager;
import com.ibm.ws.logging.hpel.LogRepositorySubProcessCommunication;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogRepositorySubManagerImpl
extends LogRepositoryBaseImpl
implements LogRepositoryManager {
    private static final long MAX_LOG_FILE_SIZE = 0x500000L;
    private String ivProcessLabel;
    private String ivSuperPid;
    private String ivPid;
    private long ivMaxListSize = -1L;
    private ArrayList<File> createdFiles = new ArrayList();
    private static String thisClass = LogRepositorySubManagerImpl.class.getName();
    private static Logger debugLogger = LogRepositoryBaseImpl.getLogger();
    private File ivSubDirectory = null;
    private final HashSet<Long> unsentFileNotifications = new HashSet();
    private boolean purgeFiles = false;
    private LogRepositorySubProcessCommunication ivSubProcessCommAgent = null;
    private long maxLogFileSize = 0x500000L;
    private static final long FAILED_WAIT_TIME = 1000L;
    private static final long FAILED_MAX_COUNT = 5L;

    public LogRepositorySubManagerImpl(File directory, String pid, String label, String superPid) {
        super(directory);
        if (!AccessHelper.canMakeDirectories(directory)) {
            throw new IllegalArgumentException("Specified location can't be used as a log repository: " + directory);
        }
        this.ivPid = pid;
        this.ivProcessLabel = label;
        this.ivSuperPid = superPid;
    }

    public synchronized void setSubProcessCommunicationAgent(LogRepositorySubProcessCommunication subProcessCommAgent) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "setSubProcessCommAg", "type: " + this.managedType + " unSentSz: " + this.unsentFileNotifications.size() + " pid: " + this.ivPid + " parent pid: " + this.ivSuperPid);
        }
        this.ivSubProcessCommAgent = subProcessCommAgent;
    }

    public synchronized void configure(long maxRepositorySize) {
        this.maxLogFileSize = LogRepositoryManagerImpl.calculateFileSplit(maxRepositorySize);
        long l = this.ivMaxListSize = maxRepositorySize < 0L ? -1L : maxRepositorySize / this.maxLogFileSize;
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "configure", "inMax: " + maxRepositorySize + " outMax: " + this.maxLogFileSize + " Tp: " + this.managedType + " MaxFilesInList: " + this.ivMaxListSize);
        }
    }

    @Override
    public synchronized File checkForNewFile(long total, long timestamp) {
        if (total <= this.maxLogFileSize) {
            return null;
        }
        return this.startNewFile(timestamp);
    }

    public void inactivateSubProcess() {
        if (this.ivSubProcessCommAgent != null) {
            this.sendNotifications();
            this.ivSubProcessCommAgent.inactivateSubProcess(this.ivPid);
        }
    }

    @Override
    public synchronized boolean purgeOldFiles() {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "purgeOldFiles", "Comm: " + this.ivSubProcessCommAgent + " Tp: " + this.managedType);
        }
        this.purgeFiles = true;
        return false;
    }

    public boolean purgeOldFilesAsync() {
        if (!this.purgeFiles) {
            return false;
        }
        boolean wasAnyFileRemoved = false;
        if (this.ivSubProcessCommAgent == null) {
            return false;
        }
        wasAnyFileRemoved = this.ivSubProcessCommAgent.removeFiles(this.managedType);
        this.purgeFiles = false;
        return wasAnyFileRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized File startNewFile(long timestamp) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "startNewFile", "unsentEmpty: " + this.unsentFileNotifications.isEmpty() + " tstamp: " + timestamp + " Tp: " + this.managedType + " subProcCommAgent: " + this.ivSubProcessCommAgent);
        }
        HashSet<Long> hashSet = this.unsentFileNotifications;
        synchronized (hashSet) {
            this.unsentFileNotifications.add(timestamp);
        }
        File file = null;
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "startNewFile", "Add tstamp: " + timestamp + " is unsent entry: " + this.unsentFileNotifications.size() + " FileNm: xx");
        }
        int count = 0;
        while (this.ivSubDirectory == null) {
            File parentDir = this.makeLogDirectory(timestamp, this.ivSuperPid);
            if (parentDir == null) {
                if ((long)(++count) > 5L) {
                    throw new RuntimeException("Failed to create instance log repository. See SystemOut.log for details.");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.ivSubDirectory = new File(parentDir, this.getLogDirectoryName(-1L, this.ivPid, this.ivProcessLabel));
        }
        file = this.getLogFile(this.ivSubDirectory, timestamp);
        File dir = file.getParentFile();
        if (!AccessHelper.isDirectory(dir)) {
            AccessHelper.makeDirectories(dir);
        }
        if (this.ivMaxListSize >= 0L) {
            this.createdFiles.add(file);
            if ((long)this.createdFiles.size() > this.ivMaxListSize) {
                AccessHelper.deleteFile(this.createdFiles.remove(0));
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendNotifications() {
        long[] fileCre8TimeStamps;
        Object object = this.unsentFileNotifications;
        synchronized (object) {
            int unsentSize = this.unsentFileNotifications.size();
            if (this.ivSubProcessCommAgent == null || unsentSize == 0) {
                return false;
            }
            fileCre8TimeStamps = new long[unsentSize];
            Iterator<Long> unsentIter = this.unsentFileNotifications.iterator();
            int curIdx = 0;
            while (unsentIter.hasNext()) {
                fileCre8TimeStamps[curIdx++] = unsentIter.next();
            }
            this.unsentFileNotifications.clear();
        }
        object = this.ivSubProcessCommAgent;
        synchronized (object) {
            for (long thisTstamp : fileCre8TimeStamps) {
                String tempStr = this.ivSubProcessCommAgent.notifyOfFileCreation(this.managedType, thisTstamp, this.ivPid, this.ivProcessLabel);
                if (!LogRepositoryBaseImpl.isDebugEnabled()) continue;
                debugLogger.logp(Level.FINE, thisClass, "setSubProcessCommAg", "Notifying of past timestamp: " + thisTstamp + " got file: " + tempStr);
            }
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        this.inactivateSubProcess();
    }
}

