/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.compat.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.concurrent.Flow;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContextualProcessor<T, R>
implements Flow.Processor<T, R>,
ContextualAction<Flow.Processor<T, R>> {
    private final Flow.Processor<T, R> action;
    private final ThreadContextDescriptor threadContextDescriptor;
    static final long serialVersionUID = -4929606487861596707L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ContextualProcessor(ThreadContextDescriptor threadContextDescriptor, Flow.Processor<T, R> action) {
        this.action = action;
        this.threadContextDescriptor = threadContextDescriptor;
    }

    @Trivial
    public Flow.Processor<T, R> getAction() {
        return this.action;
    }

    @Trivial
    public ThreadContextDescriptor getContextDescriptor() {
        return this.threadContextDescriptor;
    }

    @Override
    public void onComplete() {
        ArrayList contextApplied = this.threadContextDescriptor.taskStarting();
        try {
            this.action.onComplete();
        }
        finally {
            this.threadContextDescriptor.taskStopping(contextApplied);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        ArrayList contextApplied = this.threadContextDescriptor.taskStarting();
        try {
            this.action.onError(throwable);
        }
        finally {
            this.threadContextDescriptor.taskStopping(contextApplied);
        }
    }

    @Override
    public void onNext(T item) {
        ArrayList contextApplied = this.threadContextDescriptor.taskStarting();
        try {
            this.action.onNext(item);
        }
        finally {
            this.threadContextDescriptor.taskStopping(contextApplied);
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        ArrayList contextApplied = this.threadContextDescriptor.taskStarting();
        try {
            this.action.onSubscribe(subscription);
        }
        finally {
            this.threadContextDescriptor.taskStopping(contextApplied);
        }
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        ArrayList contextApplied = this.threadContextDescriptor.taskStarting();
        try {
            this.action.subscribe(subscriber);
        }
        finally {
            this.threadContextDescriptor.taskStopping(contextApplied);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.concurrent.internal.compat.impl.ContextualProcessor", ContextualProcessor.class, (String)"concurrent", null);
    }
}

