/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.ras.SibTr;

public class AIBrowseCursor
implements BrowseCursor,
AlarmListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(AIBrowseCursor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AnycastInputHandler parent;
    private long browseId;
    private Filter filter;
    private long seqNum;
    private MessageItem nextItem;
    private boolean browseClosed;
    private boolean browseFailed;
    private int failureReason;
    private Alarm keepAliveAlarmHandle;
    private MPAlarmManager am;

    public AIBrowseCursor(AnycastInputHandler parent, Filter filter, long browseId, MPAlarmManager am) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIBrowseCursor", (Object)new Object[]{parent, filter, new Long(browseId), am});
        }
        this.am = am;
        this.parent = parent;
        this.filter = filter;
        this.browseId = browseId;
        this.seqNum = -1L;
        this.nextItem = null;
        this.browseClosed = false;
        this.browseFailed = false;
        this.failureReason = 0;
        this.keepAliveAlarmHandle = am.create(parent.getMessageProcessor().getCustomProperties().get_browse_liveness_timeout(), this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIBrowseCursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        AIBrowseCursor aIBrowseCursor = this;
        synchronized (aIBrowseCursor) {
            this.parent.sendBrowseStatus(1, this.browseId);
            if (this.keepAliveAlarmHandle != null) {
                this.keepAliveAlarmHandle.cancel();
                this.keepAliveAlarmHandle = null;
            }
            this.parent.removeBrowseCursor(this.browseId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsMessage next() throws SIResourceException {
        MessageItem item;
        block15: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            item = null;
            AIBrowseCursor aIBrowseCursor = this;
            synchronized (aIBrowseCursor) {
                if (!this.browseClosed && !this.browseFailed) {
                    this.keepAliveAlarmHandle.cancel();
                    ++this.seqNum;
                    Filter nextFilter = this.seqNum == 0L ? this.filter : null;
                    this.parent.sendBrowseGet(this.browseId, this.seqNum, nextFilter);
                    try {
                        this.wait(this.parent.getMessageProcessor().getCustomProperties().get_browse_get_timeout());
                    }
                    catch (InterruptedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AIBrowseCursor.next", (String)"1:179:1.25", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"next", (Object)item);
                        }
                        return null;
                    }
                }
                if (this.nextItem == null) {
                    this.keepAliveAlarmHandle = null;
                    if (this.browseClosed) {
                        item = null;
                        break block15;
                    } else {
                        SIResourceException e;
                        if (this.browseFailed) {
                            e = new SIResourceException(nls.getFormattedMessage("BROWSE_FAILED_CWSIP0533", new Object[]{this.parent.getDestName(), this.failureReasonToString(this.failureReason)}, null));
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AIBrowseCursor.next", (String)"1:215:1.25", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)e));
                            }
                            throw e;
                        }
                        e = new SIResourceException(nls.getFormattedMessage("BROWSE_TIMEOUT_CWSIP0532", new Object[]{this.parent.getDestName()}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AIBrowseCursor.next", (String)"1:236:1.25", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)e));
                        }
                        throw e;
                    }
                }
                item = this.nextItem;
                this.nextItem = null;
                this.keepAliveAlarmHandle = this.am.create(this.parent.getMessageProcessor().getCustomProperties().get_browse_liveness_timeout(), this);
            }
        }
        JsMessage returnMessage = null;
        if (item != null) {
            returnMessage = item.getMessage();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)returnMessage);
        }
        return returnMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object handle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)handle);
        }
        AIBrowseCursor aIBrowseCursor = this;
        synchronized (aIBrowseCursor) {
            this.keepAliveAlarmHandle = this.am.create(this.parent.getMessageProcessor().getCustomProperties().get_browse_liveness_timeout(), this);
            this.parent.sendBrowseStatus(0, this.browseId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public synchronized void put(MessageItem message) {
        JsMessage jsMsg;
        long msgSeqNum;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)message);
        }
        if ((msgSeqNum = (jsMsg = message.getMessage()).getGuaranteedRemoteBrowseSequenceNumber()) != this.seqNum) {
            this.nextItem = null;
            this.browseFailed = true;
            this.failureReason = 2;
        } else {
            this.nextItem = message;
        }
        this.notify();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    public synchronized void endBrowse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"endBrowse");
        }
        this.browseClosed = true;
        this.notify();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"endBrowse");
        }
    }

    public synchronized void browseFailed(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"browseFailed");
        }
        this.browseFailed = true;
        this.failureReason = reason;
        this.notify();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"browseFailed");
        }
    }

    private String failureReasonToString(int failureReason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"failureReasonToString", (Object)new Integer(failureReason));
        }
        String frString = "";
        switch (failureReason) {
            case 1: {
                frString = "browse store exception";
                break;
            }
            case 2: {
                frString = "browse out of order";
                break;
            }
            case 3: {
                frString = "browse bad filter";
                break;
            }
            default: {
                frString = "";
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"failureReasonToString", (Object)frString);
        }
        return frString;
    }
}

