/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

public class Base64Utils {
    public static final char HEADER = '!';
    private static final String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789*-";
    private static final String padding = "=";

    public static String encodeBase64(byte[] data) {
        byte threeA = 0;
        StringBuilder retval = new StringBuilder(data.length * 2);
        retval.append('!');
        for (int i = 0; i < data.length; i += 3) {
            byte oneA;
            retval.append(digits.charAt((byte)(data[i] >>> 2 & 0x3F)));
            if (i + 1 < data.length) {
                byte twoB;
                oneA = (byte)(data[i] & 3);
                byte oneB = (byte)(oneA << 4);
                byte twoA = (byte)(data[i + 1] >>> 4 & 0xF);
                retval.append(digits.charAt((byte)((oneB | twoA) & 0x3F)));
                if (i + 2 < data.length) {
                    twoA = (byte)(data[i + 1] & 0xF);
                    twoB = (byte)(twoA << 2);
                    threeA = (byte)(data[i + 2] >>> 6 & 3);
                    retval.append(digits.charAt((byte)((twoB | threeA) & 0x3F)));
                    retval.append(digits.charAt((byte)(data[i + 2] & 0x3F)));
                    continue;
                }
                twoA = (byte)(data[i + 1] & 0xF);
                twoB = (byte)(twoA << 2);
                retval.append(digits.charAt((byte)(twoB & 0x3F)));
                retval.append(padding);
                continue;
            }
            oneA = (byte)(data[i] & 3);
            retval.append(digits.charAt((byte)(oneA << 4 & 0x3F)));
            retval.append(padding);
            retval.append(padding);
        }
        return retval.toString();
    }

    public static byte[] decodeBase64(String data) {
        byte fourA = 0;
        int paddingCount = data.length() - data.indexOf(padding);
        int length = paddingCount < 3 ? (data.length() - 1) / 4 * 3 - paddingCount : (data.length() - 1) / 4 * 3;
        byte[] retval = new byte[length];
        int position = 0;
        for (int i = 1; i < data.length(); i += 4) {
            byte oneA = (byte)(digits.indexOf(data.charAt(i)) << 2 & 0xFF);
            byte twoA = (byte)(digits.indexOf(data.charAt(i + 1)) >>> 4 & 3);
            retval[position] = (byte)(oneA | twoA);
            ++position;
            if (data.charAt(i + 2) == '=') continue;
            twoA = (byte)(digits.indexOf(data.charAt(i + 1)) << 4 & 0xFF);
            byte threeA = (byte)(digits.indexOf(data.charAt(i + 2)) >>> 2 & 0xF);
            retval[position] = (byte)(twoA | threeA);
            ++position;
            if (data.charAt(i + 3) == '=') continue;
            threeA = (byte)(digits.indexOf(data.charAt(i + 2)) << 6 & 0xFF);
            fourA = (byte)(digits.indexOf(data.charAt(i + 3)) & 0x3F);
            retval[position] = (byte)(threeA | fourA);
            ++position;
        }
        return retval;
    }
}

