/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.filter.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.authentication.filter.internal.AuthFilterConfig;
import com.ibm.ws.security.authentication.filter.internal.CommonFilter;
import com.ibm.ws.security.authentication.filter.internal.RealRequestInfo;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.security.authentication.filter"}, service={AuthenticationFilter.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class AuthenticationFilterImpl
implements AuthenticationFilter {
    public static final TraceComponent tc = Tr.register(AuthenticationFilterImpl.class, (String)"filter", (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages");
    protected AuthFilterConfig authFilterConfig = null;
    protected CommonFilter commonFilter = null;
    static final long serialVersionUID = -1057001607413803263L;

    @Activate
    protected void activate(Map<String, Object> properties) {
        String id = this.getAuthFilterConfig(properties);
        if (id != null) {
            Tr.info((TraceComponent)tc, (String)"AUTH_FILTER_CONFIG_PROCESSED", (Object[])new Object[]{id});
        }
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
        String id = this.getAuthFilterConfig(properties);
        if (id != null) {
            Tr.info((TraceComponent)tc, (String)"AUTH_FILTER_CONFIG_MODIFIED", (Object[])new Object[]{id});
        }
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
        this.authFilterConfig = null;
        this.commonFilter = null;
    }

    @Override
    public boolean init(String filter) {
        return true;
    }

    @Override
    public boolean isAccepted(HttpServletRequest request) {
        if (this.commonFilter != null) {
            return this.commonFilter.isAccepted(new RealRequestInfo(request));
        }
        return true;
    }

    @Override
    public void setProcessAll(boolean all) {
    }

    protected String getAuthFilterConfig(Map<String, Object> properties) {
        this.authFilterConfig = new AuthFilterConfig(properties);
        if (this.authFilterConfig.hasFilterConfig()) {
            this.commonFilter = new CommonFilter(this.authFilterConfig);
            return this.authFilterConfig.getId();
        }
        this.commonFilter = null;
        this.authFilterConfig = null;
        return null;
    }
}

