/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.Collections;
import java.util.List;

public final class HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpServerAttributesGetter<REQUEST, RESPONSE> getter;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();

    HttpServerAttributesExtractorBuilder(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = requestHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = responseHeaders;
        return this;
    }

    public HttpServerAttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpServerAttributesExtractor<REQUEST, RESPONSE>(this.getter, this.capturedRequestHeaders, this.capturedResponseHeaders);
    }
}

