/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi40.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelOperationsImpl;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.JsonIO;
import java.util.List;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPI31ModelOperations
extends OpenAPIModelOperationsImpl {
    private static final TraceComponent tc = Tr.register(OpenAPI31ModelOperations.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -705797719472523863L;

    public OpenAPI shallowCopy(OpenAPI model) {
        OpenAPI copy = super.shallowCopy(model);
        copy.setWebhooks(model.getWebhooks());
        return copy;
    }

    public Info parseInfo(String infoJson) {
        return this.parseInfo(infoJson, IOContext.forJson((JsonIO)JsonIO.newInstance(null)));
    }

    private <V, A extends V, O extends V, AB, OB> Info parseInfo(String infoJson, IOContext<V, A, O, AB, OB> io) {
        Object infoNode = io.jsonIO().fromString(infoJson, Format.JSON);
        Info result = null;
        if (io.jsonIO().isObject(infoNode)) {
            result = (Info)io.infoIO().readObject(Info.class, infoNode);
        }
        if (result == null) {
            throw new OpenApiRuntimeException("Unable to parse info JSON: " + infoJson);
        }
        return result;
    }

    public boolean isDefaultOpenApiModel(OpenAPI model) {
        boolean isDefault = false;
        if (model.getOpenapi().equals("3.1.0") && model.getInfo() != null && model.getInfo().getContact() == null && model.getInfo().getDescription() == null && model.getInfo().getLicense() == null && model.getInfo().getTermsOfService() == null && model.getInfo().getTitle().equals("Generated API") && model.getInfo().getVersion().equals("1.0") && model.getPaths() != null && model.getPaths().getPathItems().isEmpty() && model.getComponents() == null && model.getExtensions() == null && model.getExternalDocs() == null && model.getSecurity() == null && model.getServers() == null && model.getTags() == null && model.getWebhooks() == null) {
            isDefault = true;
        }
        return isDefault;
    }

    @Trivial
    public OpenAPI createDefaultOpenApiModel() {
        OpenAPI openAPI = OASFactory.createOpenAPI();
        openAPI.setOpenapi("3.1.0");
        openAPI.paths(OASFactory.createPaths());
        openAPI.info(OASFactory.createInfo().title("Generated API").version("1.0"));
        if (LoggingUtils.isEventEnabled((TraceComponent)tc)) {
            Tr.event((Object)((Object)this), (TraceComponent)tc, (String)"Created base OpenAPI document", (Object[])new Object[0]);
        }
        return openAPI;
    }

    public List<Schema.SchemaType> getTypes(Schema schema) {
        return schema.getType();
    }
}

