/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health40.internal.AppTracker40Impl;
import io.openliberty.microprofile.health40.internal.HealthFileUtils;
import java.io.File;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileHealthCheckBuilder {
    private HealthCheckResponse.Status overallStatus = HealthCheckResponse.Status.UP;
    private final File file;
    private static final TraceComponent tc = Tr.register(AppTracker40Impl.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    static final long serialVersionUID = -6086574795233316542L;

    private FileHealthCheckBuilder() {
        this.file = null;
    }

    public FileHealthCheckBuilder(File file) {
        this.file = file;
    }

    public void addResponses(Set<HealthCheckResponse> hcResponseSet) {
        for (HealthCheckResponse hcr : hcResponseSet) {
            if (!hcr.getStatus().equals((Object)HealthCheckResponse.Status.DOWN)) continue;
            this.overallStatus = HealthCheckResponse.Status.DOWN;
            return;
        }
    }

    public void handleUndeterminedResponse() {
        this.overallStatus = HealthCheckResponse.Status.DOWN;
    }

    public void setOverallStatus(HealthCheckResponse.Status status) {
        this.overallStatus = status;
    }

    public void updateFile() {
        if (this.overallStatus.equals((Object)HealthCheckResponse.Status.DOWN)) {
            return;
        }
        if (!this.file.exists()) {
            if (!HealthFileUtils.createFile(this.file)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to create file " + this.file.getAbsolutePath()), (Object[])new Object[0]);
                }
                return;
            }
        } else if (!HealthFileUtils.setLastModified(this.file)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to update last modified time for  file " + this.file.getAbsolutePath()), (Object[])new Object[0]);
            }
            return;
        }
    }

    public HealthCheckResponse.Status getOverallStatus() {
        return this.overallStatus;
    }
}

