/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config12.converters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.interfaces.ConversionException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MethodFunction<X>
implements Function<String, X> {
    private final Method method;
    static final long serialVersionUID = -8638521882912513265L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected MethodFunction(Method method) {
        this.method = method;
    }

    @Override
    @FFDCIgnore(value={InvocationTargetException.class})
    public X apply(String value) {
        Object converted = null;
        if (value != null) {
            try {
                converted = this.method.invoke(null, value);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)cause;
                }
                throw new ConversionException(cause);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config12.converters.MethodFunction", (String)"47", (Object)this, (Object[])new Object[]{value});
                throw new ConversionException((Throwable)e);
            }
        }
        return (X)converted;
    }

    @Trivial
    public static <X> Function<String, X> getValueOfFunction(Class<X> reflectionClass) {
        return MethodFunction.getFunction(reflectionClass, "valueOf", String.class);
    }

    @Trivial
    public static <X> Function<String, X> getParseFunction(Class<X> reflectionClass) {
        return MethodFunction.getFunction(reflectionClass, "parse", CharSequence.class);
    }

    @Trivial
    public static <X> Function<String, X> getOfMethod(Class<X> reflectionClass) {
        return MethodFunction.getFunction(reflectionClass, "of", String.class);
    }

    @Trivial
    @FFDCIgnore(value={NoSuchMethodException.class})
    public static <X> Function<String, X> getFunction(Class<X> reflectionClass, String methodName, Class<?> ... paramTypes) {
        MethodFunction<X> implicitFunction = null;
        try {
            Method method = reflectionClass.getMethod(methodName, paramTypes);
            if ((method.getModifiers() & 8) == 0) {
                method = null;
            } else if (!reflectionClass.equals(method.getReturnType())) {
                method = null;
            }
            if (method != null) {
                implicitFunction = new MethodFunction<X>(method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return implicitFunction;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config12.converters.MethodFunction", MethodFunction.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config12.resources.Config12");
    }
}

