/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;

public class LongObjectHashMap {
    private static TraceComponent tc = Tr.register(LongObjectHashMap.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final Object DELETED = new Object();
    private Object[] _values;
    private long[] _keys;
    private final int _loadFactor;
    private int _mapSize;
    private int _currentLoad;
    private static final int DEFAULT_INITIAL_MAP_SIZE = 256;
    private static final int DEFAULT_LOAD_FACTOR = 60;
    private int _resizeThreshold;

    public LongObjectHashMap() {
        this(256, 60);
    }

    public LongObjectHashMap(int initialSize) throws IllegalArgumentException {
        this(initialSize, 60);
    }

    @Trivial
    public LongObjectHashMap(int initialSize, int loadFactor) throws IllegalArgumentException {
        if (loadFactor <= 0 || loadFactor > 100) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LongObjectHashMap", (Object)"IllegalArgumentException");
            }
            throw new IllegalArgumentException("loadFactor must lie in the range 0 < loadFactor <= 100");
        }
        if (initialSize < 0 || (initialSize & initialSize - 1) != 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LongObjectHashMap", (Object)"IllegalArgumentException");
            }
            throw new IllegalArgumentException("initialSize must be a power of two and greater than zero");
        }
        this._loadFactor = loadFactor;
        this._mapSize = initialSize;
        this._values = new Object[this._mapSize];
        this._keys = new long[this._mapSize];
        this._currentLoad = 0;
        this._resizeThreshold = (int)((float)this._mapSize * (float)this._loadFactor / 100.0f);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LongObjectHashMap", (Object[])new Object[]{this, initialSize, loadFactor, this._resizeThreshold});
        }
    }

    public Object put(long key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put", (Object[])new Object[]{key, value, this});
        }
        if (value == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"put", (Object)"IllegalArgumentException");
            }
            throw new IllegalArgumentException("Null is not a permitted value.");
        }
        int hash = this.getHashForNewEntry(key);
        Object previous = this._values[hash] == DELETED ? null : this._values[hash];
        this._values[hash] = value;
        this._keys[hash] = key;
        if (previous == null) {
            ++this._currentLoad;
            if (this._currentLoad == this._resizeThreshold) {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"put", (Object[])new Object[]{key, value, this});
                }
                long[] oldKeys = new long[this._mapSize];
                Object[] oldValues = new Object[this._mapSize];
                System.arraycopy(this._keys, 0, oldKeys, 0, oldKeys.length);
                System.arraycopy(this._values, 0, oldValues, 0, oldValues.length);
                this._mapSize *= 2;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("mapSize = " + this._mapSize), (Object[])new Object[0]);
                }
                this._resizeThreshold = (int)((float)this._mapSize * (float)this._loadFactor / 100.0f);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resizeThreshold = " + this._resizeThreshold), (Object[])new Object[0]);
                }
                this._values = new Object[this._mapSize];
                this._keys = new long[this._mapSize];
                this._currentLoad = 0;
                for (int i = 0; i < oldValues.length; ++i) {
                    Object oldValue = oldValues[i];
                    if (oldValue == null || oldValue == DELETED) continue;
                    this.put(oldKeys[i], oldValue);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put", (Object)previous);
        }
        return previous;
    }

    public Object remove(long key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object[])new Object[]{key, this});
        }
        int hash = this.getHashForExistingEntry(key);
        Object result = null;
        if (hash >= 0) {
            result = this._values[hash];
        }
        if (result != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Entry found in map - removing", (Object[])new Object[0]);
            }
            this._values[hash] = DELETED;
            --this._currentLoad;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove", (Object)result);
        }
        return result;
    }

    public Object get(long key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object[])new Object[]{key, this});
        }
        int hash = this.getHashForExistingEntry(key);
        Object value = null;
        if (hash >= 0) {
            value = this._values[hash];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", (Object)value);
        }
        return value;
    }

    public Object[] values() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"values", (Object[])new Object[]{this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current load = " + this._currentLoad), (Object[])new Object[0]);
        }
        Object[] values = new Object[this._currentLoad];
        int objCount = 0;
        for (int i = 0; i < this._mapSize; ++i) {
            Object value = this._values[i];
            if (value == null || value == DELETED) continue;
            values[objCount++] = value;
        }
        return values;
    }

    private int getHashForExistingEntry(long key) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHashForExistingEntry", (Object[])new Object[]{key, this});
        }
        int hash = this.getHashForKey(key);
        for (i = 1; i < this._mapSize && (this._values[hash] == DELETED || this._values[hash] != null && this._keys[hash] != key); ++i) {
            hash = (hash + i) % this._mapSize;
        }
        if (i == this._mapSize) {
            hash = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHashForExistingEntry", (Object)hash);
        }
        return hash;
    }

    @Trivial
    private int getHashForNewEntry(long key) {
        int hash = this.getHashForKey(key);
        int i = 1;
        while (this._values[hash] != null && this._values[hash] != DELETED && this._keys[hash] != key) {
            hash = (hash + i) % this._mapSize;
            ++i;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getHashForNewEntry {0} {1} {2}", (Object[])new Object[]{this, key, hash});
        }
        return hash;
    }

    @Trivial
    private int getHashForKey(long key) {
        int hash = (int)(key % (long)this._mapSize);
        if (hash < 0) {
            hash = -hash;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getHashForKey {0} {1} {2}", (Object[])new Object[]{this, key, hash});
        }
        return hash;
    }
}

