/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;
import zipkin2.reporter.HttpEndpointSuppliers;
import zipkin2.reporter.internal.SenderAdapter;
import zipkin2.reporter.okhttp3.InternalOkHttpSender;

public final class OkHttpSender
extends SenderAdapter {
    final InternalOkHttpSender delegate;
    final HttpEndpointSupplier.Factory endpointSupplierFactory;
    final String endpoint;

    public static OkHttpSender create(String endpoint) {
        return OkHttpSender.newBuilder().endpoint(endpoint).build();
    }

    public static Builder newBuilder() {
        return new Builder(new OkHttpClient.Builder());
    }

    OkHttpSender(Builder builder) {
        this.delegate = new InternalOkHttpSender(builder);
        this.endpointSupplierFactory = builder.endpointSupplierFactory;
        this.endpoint = builder.endpoint;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    protected BytesMessageSender delegate() {
        return this.delegate;
    }

    public static final class Builder {
        final OkHttpClient.Builder clientBuilder;
        HttpEndpointSupplier.Factory endpointSupplierFactory = HttpEndpointSuppliers.constantFactory();
        String endpoint;
        Encoding encoding = Encoding.JSON;
        boolean compressionEnabled = true;
        int maxRequests = 64;
        int messageMaxBytes = 500000;

        Builder(OkHttpClient.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
        }

        Builder(OkHttpSender sender) {
            this.clientBuilder = sender.delegate.client.newBuilder();
            this.endpointSupplierFactory = sender.endpointSupplierFactory;
            this.endpoint = sender.endpoint;
            this.maxRequests = sender.delegate.client.dispatcher().getMaxRequests();
            this.compressionEnabled = sender.delegate.compressionEnabled;
            this.encoding = sender.delegate.encoding;
            this.messageMaxBytes = sender.delegate.messageMaxBytes;
        }

        public Builder endpointSupplierFactory(HttpEndpointSupplier.Factory endpointSupplierFactory) {
            if (endpointSupplierFactory == null) {
                throw new NullPointerException("endpointSupplierFactory == null");
            }
            this.endpointSupplierFactory = endpointSupplierFactory;
            return this;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(HttpUrl endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint.toString();
            return this;
        }

        public Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public Builder maxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public Builder connectTimeout(int connectTimeoutMillis) {
            this.clientBuilder.connectTimeout((long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder readTimeout(int readTimeoutMillis) {
            this.clientBuilder.readTimeout((long)readTimeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder writeTimeout(int writeTimeoutMillis) {
            this.clientBuilder.writeTimeout((long)writeTimeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public OkHttpClient.Builder clientBuilder() {
            return this.clientBuilder;
        }

        public OkHttpSender build() {
            if (this.endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            return new OkHttpSender(this);
        }
    }
}

