/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MapCounter
implements ExponentialCounter {
    private static final int NULL_INDEX = Integer.MIN_VALUE;
    private final int maxSize;
    private final Map<Integer, AtomicLong> backing;
    private int indexStart;
    private int indexEnd;

    public MapCounter(int maxSize) {
        this.maxSize = maxSize;
        this.backing = new ConcurrentHashMap<Integer, AtomicLong>((int)Math.ceil((double)maxSize / 0.75) + 1);
        this.indexEnd = Integer.MIN_VALUE;
        this.indexStart = Integer.MIN_VALUE;
    }

    public MapCounter(ExponentialCounter otherCounter) {
        this.maxSize = otherCounter.getMaxSize();
        this.backing = new ConcurrentHashMap<Integer, AtomicLong>((int)Math.ceil((double)this.maxSize / 0.75) + 1);
        this.indexStart = otherCounter.getIndexStart();
        this.indexEnd = otherCounter.getIndexEnd();
        for (int i = this.indexStart; i <= this.indexEnd; ++i) {
            long val = otherCounter.get(i);
            if (val == 0L) continue;
            this.backing.put(i, new AtomicLong(val));
        }
    }

    @Override
    public int getIndexStart() {
        return this.indexStart;
    }

    @Override
    public int getIndexEnd() {
        return this.indexEnd;
    }

    @Override
    public boolean increment(int index, long delta) {
        if (this.indexStart == Integer.MIN_VALUE) {
            this.indexStart = index;
            this.indexEnd = index;
            this.doIncrement(index, delta);
            return true;
        }
        if (index > this.indexEnd) {
            if ((long)index - (long)this.indexStart + 1L > (long)this.maxSize) {
                return false;
            }
            this.indexEnd = index;
        } else if (index < this.indexStart) {
            if ((long)this.indexEnd - (long)index + 1L > (long)this.maxSize) {
                return false;
            }
            this.indexStart = index;
        }
        this.doIncrement(index, delta);
        return true;
    }

    @Override
    public long get(int index) {
        if (index < this.indexStart || index > this.indexEnd) {
            return 0L;
        }
        AtomicLong result = this.backing.get(index);
        if (result == null) {
            return 0L;
        }
        return result.longValue();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.indexStart = Integer.MIN_VALUE;
        this.indexEnd = Integer.MIN_VALUE;
    }

    private synchronized void doIncrement(int index, long delta) {
        long prevValue = this.backing.computeIfAbsent(index, k -> new AtomicLong(0L)).getAndAdd(delta);
        if (prevValue + delta == 0L) {
            this.backing.remove(index);
            if (this.isEmpty()) {
                this.indexStart = Integer.MIN_VALUE;
                this.indexEnd = Integer.MIN_VALUE;
            } else {
                this.indexStart = Collections.min(this.backing.keySet());
                this.indexEnd = Collections.max(this.backing.keySet());
            }
        }
    }

    public String toString() {
        return this.backing.toString();
    }
}

