/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.msgstore.expiry.ExpirableReference;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;

public class ExpiryIndex {
    private static TraceComponent tc = SibTr.register(ExpiryIndex.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final ConcurrentSkipListSet<ExpirableReference> tree;
    long cleaned = 0L;
    Object cleanLock = new Object();

    public ExpiryIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.tree = new ConcurrentSkipListSet<ExpirableReference>(new ExpiryComparator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{this.tree});
        }
    }

    public boolean put(ExpirableReference expirable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)("ObjecId=" + expirable.getID() + " ExpiryTime=" + expirable.getExpiryTime()));
        }
        boolean added = this.tree.add(expirable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put", (Object)("added=" + added));
        }
        return added;
    }

    public Iterator<ExpirableReference> iterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"iterator");
        }
        Iterator<ExpirableReference> iterator = this.tree.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"iterator", iterator);
        }
        return iterator;
    }

    public boolean remove(ExpirableReference expirableReference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"remove", (Object)(expirableReference == null ? "null" : "ObjectId=" + expirableReference.getID() + " ExpiryTime=" + expirableReference.getExpiryTime()));
        }
        if (expirableReference == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)" expirableReference=null");
            }
            return false;
        }
        boolean removed = this.tree.remove(expirableReference);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"remove", (Object)("removed=" + removed));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clean", (Object)("isEmpty=" + this.tree.isEmpty()));
        }
        Object object = this.cleanLock;
        synchronized (object) {
            this.cleaned = 0L;
            for (ExpirableReference expirableReference : this.tree) {
                Expirable expirable = (Expirable)expirableReference.get();
                if (expirable != null && expirable.expirableIsInStore()) continue;
                boolean removed = this.tree.remove(expirableReference);
                if (removed) {
                    ++this.cleaned;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Removed (cleaned) removed=" + removed + " ExpiryTime=" + expirableReference.getExpiryTime() + " objectId=" + expirableReference.getID()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clean", (Object)("isEmpty=" + this.tree.isEmpty()));
        }
        return this.cleaned;
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return this.tree.size();
    }

    private static class ExpiryComparator
    implements Comparator<ExpirableReference> {
        private ExpiryComparator() {
        }

        @Override
        public int compare(ExpirableReference ref1, ExpirableReference ref2) {
            long time2;
            long time1 = ref1.getExpiryTime();
            if (time1 == (time2 = ref2.getExpiryTime())) {
                long id2;
                long id1 = ref1.getID();
                if (id1 == (id2 = ref2.getID())) {
                    return 0;
                }
                if (id1 < id2) {
                    return -1;
                }
                return 1;
            }
            if (time1 < time2) {
                return -1;
            }
            return 1;
        }
    }
}

