/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ServerPlatformException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.server.NoServerPlatformDetector;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;
import org.eclipse.persistence.platform.server.glassfish.GlassfishPlatformDetector;
import org.eclipse.persistence.platform.server.was.WebSpherePlatformDetector;
import org.eclipse.persistence.platform.server.wls.WebLogicPlatformDetector;
import org.eclipse.persistence.sessions.DatabaseSession;

public final class ServerPlatformUtils {
    private static final List<ServerPlatformDetector> PLATFORMS = new ArrayList<ServerPlatformDetector>(){
        {
            this.add(new NoServerPlatformDetector());
            this.add(new WebSpherePlatformDetector());
            this.add(new WebLogicPlatformDetector());
            this.add(new GlassfishPlatformDetector());
        }
    };
    private static final String UNKNOWN_MARKER = "UNKNOWN";
    private static String SERVER_PLATFORM_CLS;

    public static String detectServerPlatform(AbstractSession session) {
        if (SERVER_PLATFORM_CLS == null) {
            for (ServerPlatformDetector server : PLATFORMS) {
                String res = server.checkPlatform();
                if (res == null) continue;
                SERVER_PLATFORM_CLS = PropertiesHandler.getPropertyValue("eclipselink.target-server", res);
                break;
            }
            if (SERVER_PLATFORM_CLS == null) {
                SERVER_PLATFORM_CLS = UNKNOWN_MARKER;
            }
        }
        if (SERVER_PLATFORM_CLS == UNKNOWN_MARKER) {
            return null;
        }
        if (session != null) {
            session.log(2, "server", "detect_server_platform", SERVER_PLATFORM_CLS);
        } else {
            AbstractSessionLog.getLog().log(2, "server", "detect_server_platform", (Object)SERVER_PLATFORM_CLS);
        }
        return SERVER_PLATFORM_CLS;
    }

    public static ServerPlatform createServerPlatform(DatabaseSession session, String platformClass, ClassLoader loader) {
        if (platformClass == null) {
            throw ServerPlatformException.invalidServerPlatformClass(null, null);
        }
        Class cls = null;
        try {
            cls = ServerPlatformUtils.findClass(platformClass, loader);
        }
        catch (ClassNotFoundException | PrivilegedActionException ex) {
            ClassLoader cl = ServerPlatformUtils.class.getClassLoader();
            if (loader != cl) {
                try {
                    cls = ServerPlatformUtils.findClass(platformClass, cl);
                }
                catch (ClassNotFoundException | PrivilegedActionException ex1) {
                    throw ServerPlatformException.serverPlatformClassNotFound(platformClass, ex);
                }
            }
            throw ServerPlatformException.serverPlatformClassNotFound(platformClass, ex);
        }
        Class[] paramTypes = new Class[]{DatabaseSession.class};
        Object[] params = new Object[]{session};
        ServerPlatform platform = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = AccessController.doPrivileged(new PrivilegedGetConstructorFor(cls, paramTypes, false));
                platform = (ServerPlatform)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, params));
            }
            catch (PrivilegedActionException ex) {
                throw ServerPlatformException.invalidServerPlatformClass(platformClass, ex);
            }
        }
        try {
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor(cls, paramTypes, false);
            platform = (ServerPlatform)PrivilegedAccessHelper.invokeConstructor(constructor, params);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw ServerPlatformException.invalidServerPlatformClass(platformClass, ex);
        }
        return platform;
    }

    private static Class findClass(String className, ClassLoader loader) throws ClassNotFoundException, PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedClassForName(className, false, loader));
        }
        return PrivilegedAccessHelper.getClassForName(className, false, loader);
    }
}

