/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import java.util.Map;
import java.util.Properties;

public class SSLConfigChangeEvent {
    private String selectionType;
    private String sslAlias;
    private String sslState;
    private Properties originalSSLConfig;
    private Properties changedSSLConfig;
    private Map<String, Object> connectionInfo;

    public SSLConfigChangeEvent(String alias, Properties config, String selection, Map<String, Object> connInfo) {
        this.sslAlias = alias;
        this.originalSSLConfig = config;
        this.selectionType = selection;
        this.connectionInfo = connInfo;
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public Map<String, Object> getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getAlias() {
        return this.sslAlias;
    }

    public String getClientCertificateAlias() {
        if (this.getOriginalSSLConfig() != null) {
            return this.getOriginalSSLConfig().getProperty("com.ibm.ssl.keyStoreClientAlias");
        }
        return null;
    }

    public String getServerCertificateAlias() {
        if (this.getOriginalSSLConfig() != null) {
            return this.getOriginalSSLConfig().getProperty("com.ibm.ssl.keyStoreServerAlias");
        }
        return null;
    }

    public String getState() {
        return this.sslState;
    }

    public Properties getOriginalSSLConfig() {
        return this.originalSSLConfig;
    }

    public Properties getChangedSSLConfig() {
        return this.changedSSLConfig;
    }

    public void setChangedSSLConfig(Properties config) {
        this.changedSSLConfig = config;
    }

    public void setState(String state) {
        this.sslState = state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLConfigChangeEvent: selectionType=").append(this.selectionType);
        sb.append(", sslAlias=").append(this.sslAlias);
        sb.append(", sslState=").append(this.sslState);
        return sb.toString();
    }
}

