/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedTypeImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotationImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.annotated.slim.unbacked.UnbackedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.reflection.Reflections;

public class ClassTransformer
implements BootstrapService {
    private final ConcurrentMap<Class<? extends Annotation>, UnbackedAnnotatedType<? extends Annotation>> syntheticAnnotationsAnnotatedTypes = new ConcurrentHashMap<Class<? extends Annotation>, UnbackedAnnotatedType<? extends Annotation>>();
    private final ConcurrentMap<AnnotatedTypeIdentifier, SlimAnnotatedType<?>> slimAnnotatedTypesById;
    private final ComputingCache<TypeHolder<?>, BackedAnnotatedType<?>> backedAnnotatedTypes;
    private final ComputingCache<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> enhancedAnnotatedTypes;
    private final ComputingCache<Class<? extends Annotation>, EnhancedAnnotation<?>> annotations;
    private final TypeStore typeStore;
    private final SharedObjectCache cache;
    private final ReflectionCache reflectionCache;
    private final String contextId;

    public static ClassTransformer instance(BeanManagerImpl manager) {
        return manager.getServices().get(ClassTransformer.class);
    }

    public ClassTransformer(TypeStore typeStore, SharedObjectCache cache, ReflectionCache reflectionCache, String contextId) {
        this.contextId = contextId;
        this.backedAnnotatedTypes = ComputingCacheBuilder.newBuilder().setWeakValues().build(new TransformClassToBackedAnnotatedType());
        this.enhancedAnnotatedTypes = ComputingCacheBuilder.newBuilder().build(new TransformSlimAnnotatedTypeToEnhancedAnnotatedType());
        this.annotations = ComputingCacheBuilder.newBuilder().build(new TransformClassToWeldAnnotation());
        this.typeStore = typeStore;
        this.cache = cache;
        this.reflectionCache = reflectionCache;
        this.slimAnnotatedTypesById = new ConcurrentHashMap();
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, Type baseType, String bdaId, String suffix) {
        try {
            return (BackedAnnotatedType)this.backedAnnotatedTypes.getCastValue(new TypeHolder<T>(rawType, baseType, bdaId, suffix));
        }
        catch (RuntimeException e) {
            if (e instanceof TypeNotPresentException || e instanceof ResourceLoadingException) {
                BootstrapLogger.LOG.exceptionWhileLoadingClass(rawType.getName(), e);
                throw new ResourceLoadingException("Exception while loading class " + rawType.getName(), e);
            }
            throw e;
        }
        catch (Error e) {
            if (e instanceof NoClassDefFoundError || e instanceof LinkageError) {
                throw new ResourceLoadingException("Error while loading class " + rawType.getName(), e);
            }
            BootstrapLogger.LOG.errorWhileLoadingClass(rawType.getName(), e);
            throw e;
        }
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, String bdaId) {
        return this.getBackedAnnotatedType(rawType, rawType, bdaId, null);
    }

    public <T> BackedAnnotatedType<T> getBackedAnnotatedType(Class<T> rawType, String bdaId, String suffix) {
        return this.getBackedAnnotatedType(rawType, rawType, bdaId, suffix);
    }

    public <T> SlimAnnotatedType<T> getSlimAnnotatedTypeById(AnnotatedTypeIdentifier id) {
        return (SlimAnnotatedType)Reflections.cast(this.slimAnnotatedTypesById.get(id));
    }

    public <T> UnbackedAnnotatedType<T> getUnbackedAnnotatedType(AnnotatedType<T> source, String bdaId, String suffix) {
        UnbackedAnnotatedType<T> type = UnbackedAnnotatedType.additionalAnnotatedType(this.contextId, source, bdaId, suffix, this.cache);
        return this.updateLookupTable(type);
    }

    public <T> UnbackedAnnotatedType<T> getUnbackedAnnotatedType(SlimAnnotatedType<T> originalType, AnnotatedType<T> source) {
        UnbackedAnnotatedType<T> type = UnbackedAnnotatedType.modifiedAnnotatedType(originalType, source, this.cache);
        return this.updateLookupTable(type);
    }

    public UnbackedAnnotatedType<? extends Annotation> getSyntheticAnnotationAnnotatedType(Class<? extends Annotation> annotationType) {
        return (UnbackedAnnotatedType)this.syntheticAnnotationsAnnotatedTypes.get(annotationType);
    }

    private <T, S extends SlimAnnotatedType<T>> S updateLookupTable(S annotatedType) {
        SlimAnnotatedType<?> previousValue = this.slimAnnotatedTypesById.putIfAbsent((AnnotatedTypeIdentifier)annotatedType.getIdentifier(), annotatedType);
        if (previousValue == null) {
            return annotatedType;
        }
        return (S)((SlimAnnotatedType)Reflections.cast(previousValue));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, String bdaId) {
        return this.getEnhancedAnnotatedType(this.getBackedAnnotatedType(rawType, bdaId));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(Class<T> rawType, Type baseType, String bdaId) {
        return this.getEnhancedAnnotatedType(this.getBackedAnnotatedType(rawType, baseType, bdaId, null));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(AnnotatedType<T> annotatedType, String bdaId) {
        if (annotatedType instanceof EnhancedAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(annotatedType);
        }
        if (annotatedType instanceof SlimAnnotatedType) {
            return (EnhancedAnnotatedType)Reflections.cast(this.getEnhancedAnnotatedType((SlimAnnotatedType)annotatedType));
        }
        return this.getEnhancedAnnotatedType(this.getUnbackedAnnotatedType(annotatedType, bdaId, AnnotatedTypes.createTypeId(annotatedType)));
    }

    public <T> EnhancedAnnotatedType<T> getEnhancedAnnotatedType(SlimAnnotatedType<T> annotatedType) {
        return (EnhancedAnnotatedType)Reflections.cast(this.enhancedAnnotatedTypes.getValue(annotatedType));
    }

    public <T extends Annotation> EnhancedAnnotation<T> getEnhancedAnnotation(Class<T> clazz) {
        return (EnhancedAnnotation)this.annotations.getCastValue(clazz);
    }

    public void clearAnnotationData(Class<? extends Annotation> annotationClass) {
        this.annotations.invalidate(annotationClass);
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    public SharedObjectCache getSharedObjectCache() {
        return this.cache;
    }

    public ReflectionCache getReflectionCache() {
        return this.reflectionCache;
    }

    public void addSyntheticAnnotation(AnnotatedType<? extends Annotation> annotation, String bdaId) {
        this.syntheticAnnotationsAnnotatedTypes.put(annotation.getJavaClass(), this.getUnbackedAnnotatedType(annotation, bdaId, "syntheticAnnotation"));
        this.clearAnnotationData(annotation.getJavaClass());
    }

    public <T> void disposeBackedAnnotatedType(Class<T> rawType, String bdaId, String suffix) {
        TypeHolder<T> typeHolder = new TypeHolder<T>(rawType, rawType, bdaId, suffix);
        BackedAnnotatedType annotatedType = (BackedAnnotatedType)Reflections.cast(this.backedAnnotatedTypes.getValueIfPresent(typeHolder));
        if (annotatedType != null) {
            this.backedAnnotatedTypes.invalidate(typeHolder);
            this.slimAnnotatedTypesById.remove(annotatedType.getIdentifier());
            this.enhancedAnnotatedTypes.invalidate(annotatedType);
        }
    }

    @Override
    public void cleanupAfterBoot() {
        this.enhancedAnnotatedTypes.clear();
        this.annotations.clear();
        this.backedAnnotatedTypes.forEachValue(BackedAnnotatedType::clear);
        this.backedAnnotatedTypes.clear();
    }

    @Override
    public void cleanup() {
        this.cleanupAfterBoot();
        this.slimAnnotatedTypesById.clear();
        this.syntheticAnnotationsAnnotatedTypes.clear();
    }

    public void removeAll(Set<Bean<?>> removable) {
        for (Bean<?> bean : removable) {
            if (!(bean instanceof AbstractClassBean)) continue;
            this.slimAnnotatedTypesById.remove(((AbstractClassBean)bean).getAnnotated().getIdentifier());
        }
    }

    private static final class TypeHolder<T> {
        private final String bdaId;
        private final Class<T> rawType;
        private final Type baseType;
        private final String suffix;

        private TypeHolder(Class<T> rawType, Type baseType, String bdaId, String suffix) {
            this.rawType = rawType;
            this.baseType = baseType;
            this.bdaId = bdaId;
            this.suffix = suffix;
        }

        Type getBaseType() {
            return this.baseType;
        }

        Class<T> getRawType() {
            return this.rawType;
        }

        String getBdaId() {
            return this.bdaId;
        }

        String getSuffix() {
            return this.suffix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeHolder) {
                TypeHolder that = (TypeHolder)obj;
                return Objects.equals(this.getBaseType(), that.getBaseType()) && Objects.equals(this.getBdaId(), that.getBdaId()) && Objects.equals(this.getSuffix(), that.getSuffix());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getBaseType(), this.getBdaId(), this.getSuffix());
        }

        public String toString() {
            return "TypeHolder [bdaId=" + this.bdaId + ", rawType=" + this.rawType + ", baseType=" + this.baseType + ", suffix=" + this.suffix + "]";
        }
    }

    private class TransformSlimAnnotatedTypeToEnhancedAnnotatedType
    implements Function<SlimAnnotatedType<?>, EnhancedAnnotatedType<?>> {
        private TransformSlimAnnotatedTypeToEnhancedAnnotatedType() {
        }

        @Override
        public EnhancedAnnotatedType<?> apply(SlimAnnotatedType<?> annotatedType) {
            return EnhancedAnnotatedTypeImpl.of(annotatedType, ClassTransformer.this);
        }
    }

    private class TransformClassToBackedAnnotatedType
    implements Function<TypeHolder<?>, BackedAnnotatedType<?>> {
        private TransformClassToBackedAnnotatedType() {
        }

        @Override
        public BackedAnnotatedType<?> apply(TypeHolder<?> typeHolder) {
            Reflections.checkDeclaringClassLoadable(typeHolder.getRawType());
            BackedAnnotatedType<?> type = BackedAnnotatedType.of(typeHolder.getRawType(), typeHolder.getBaseType(), ClassTransformer.this.cache, ClassTransformer.this.reflectionCache, ClassTransformer.this.contextId, typeHolder.getBdaId(), typeHolder.getSuffix());
            return ClassTransformer.this.updateLookupTable(type);
        }
    }

    private class TransformClassToWeldAnnotation
    implements Function<Class<? extends Annotation>, EnhancedAnnotation<?>> {
        private TransformClassToWeldAnnotation() {
        }

        @Override
        public EnhancedAnnotation<?> apply(Class<? extends Annotation> from) {
            BackedAnnotatedType<? extends Annotation> slimAnnotatedType = (BackedAnnotatedType<? extends Annotation>)ClassTransformer.this.syntheticAnnotationsAnnotatedTypes.get(from);
            if (slimAnnotatedType == null) {
                slimAnnotatedType = ClassTransformer.this.getBackedAnnotatedType(from, AnnotatedTypeIdentifier.NULL_BDA_ID);
            }
            return EnhancedAnnotationImpl.create(slimAnnotatedType, ClassTransformer.this);
        }
    }
}

