/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.http2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.netty.NettyHttpChannelConfig;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.pipeline.CRLFValidationHandler;
import com.ibm.ws.http.netty.pipeline.http2.LibertyUpgradeCodec;
import com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpObjectAggregator;
import com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpRequestHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.openliberty.http.netty.quiesce.QuiesceStrategy;
import io.openliberty.http.netty.timeout.TimeoutHandler;
import io.openliberty.netty.internal.impl.QuiesceHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyNettyALPNHandler
extends ApplicationProtocolNegotiationHandler {
    private static final TraceComponent tc = Tr.register(LibertyNettyALPNHandler.class, null, null);
    private final NettyHttpChannelConfig httpConfig;
    static final long serialVersionUID = -5180546842266712652L;

    public LibertyNettyALPNHandler(NettyHttpChannelConfig httpConfig) {
        super("http/1.1");
        this.httpConfig = httpConfig;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            QuiesceHandler quiesceHandler;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Configuring pipeline with HTTP 2 for incoming connection " + ctx.channel()), (Object[])new Object[0]);
            }
            LibertyUpgradeCodec codec = new LibertyUpgradeCodec(this.httpConfig, ctx.channel());
            HttpToHttp2ConnectionHandler handler = codec.buildHttp2ConnectionHandler(this.httpConfig, ctx.channel());
            ctx.pipeline().addAfter("ALPN_HANDLER", null, (ChannelHandler)handler);
            if (ctx.pipeline().get(TimeoutHandler.class) == null) {
                TimeoutHandler h = new TimeoutHandler(this.httpConfig);
                ctx.pipeline().addAfter("HTTP_SERVER_HANDLER", TimeoutHandler.NAME, (ChannelHandler)h);
                h.markProtocol(ctx.pipeline(), NettyHttpConstants.ProtocolName.HTTP2);
            }
            if ((quiesceHandler = (QuiesceHandler)ctx.pipeline().get(QuiesceHandler.class)) != null) {
                quiesceHandler.setQuiesceTask(QuiesceStrategy.HTTP2_GOAWAY.getTask());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Configured pipeline with " + ctx.pipeline().names()), (Object[])new Object[0]);
            }
            return;
        }
        if ("http/1.1".equals(protocol)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Configuring pipeline with HTTP 1.1 for incoming connection " + ctx.channel()), (Object[])new Object[0]);
            }
            ctx.pipeline().addAfter("ALPN_HANDLER", "HTTP_SERVER_HANDLER", (ChannelHandler)new HttpServerCodec(8192, Integer.MAX_VALUE, this.httpConfig.getIncomingBodyBufferSize()));
            if (ctx.pipeline().get(TimeoutHandler.class) == null) {
                TimeoutHandler h = new TimeoutHandler(this.httpConfig);
                ctx.pipeline().addAfter("HTTP_SERVER_HANDLER", TimeoutHandler.NAME, (ChannelHandler)h);
                h.markProtocol(ctx.pipeline(), NettyHttpConstants.ProtocolName.HTTP1);
            }
            ctx.pipeline().addBefore("HTTP_SERVER_HANDLER", "CRLFValidationHandler", (ChannelHandler)CRLFValidationHandler.INSTANCE);
            ctx.pipeline().addAfter("HTTP_SERVER_HANDLER", "httpKeepAlive", (ChannelHandler)new HttpServerKeepAliveHandler());
            ctx.pipeline().addAfter("httpKeepAlive", "LIBERTY_OBJECT_AGGREGATOR", (ChannelHandler)new LibertyHttpObjectAggregator(this.httpConfig.getMessageSizeLimit() == -1L ? Long.MAX_VALUE : this.httpConfig.getMessageSizeLimit()));
            ctx.pipeline().addAfter("LIBERTY_OBJECT_AGGREGATOR", "LIBERTY_REQUEST_HANDLER", (ChannelHandler)new LibertyHttpRequestHandler(this.httpConfig));
            ctx.channel().config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Configured pipeline with " + ctx.pipeline().names()), (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Pipeline unconfigured for protocol " + protocol), (Object[])new Object[0]);
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }
}

