/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import zipkin2.reporter.Encoding;

enum RequestBodyMessageEncoder {
    JSON{

        @Override
        public RequestBody encode(List<byte[]> encodedSpans) {
            return new JsonRequestBody(encodedSpans);
        }
    }
    ,
    THRIFT{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new ThriftRequestBody(encodedSpans);
        }
    }
    ,
    PROTO3{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new Protobuf3RequestBody(encodedSpans);
        }
    };


    static RequestBodyMessageEncoder forEncoding(Encoding encoding) {
        switch (encoding) {
            case JSON: {
                return JSON;
            }
            case THRIFT: {
                return THRIFT;
            }
            case PROTO3: {
                return PROTO3;
            }
        }
        throw new UnsupportedOperationException("Unsupported encoding: " + encoding.name());
    }

    abstract RequestBody encode(List<byte[]> var1);

    static final class Protobuf3RequestBody
    extends StreamingRequestBody {
        Protobuf3RequestBody(List<byte[]> values) {
            super(Encoding.PROTO3, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
            }
        }
    }

    static final class ThriftRequestBody
    extends StreamingRequestBody {
        ThriftRequestBody(List<byte[]> values) {
            super(Encoding.THRIFT, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int length = this.values.size();
            sink.writeByte(12);
            sink.writeByte(length >>> 24 & 0xFF);
            sink.writeByte(length >>> 16 & 0xFF);
            sink.writeByte(length >>> 8 & 0xFF);
            sink.writeByte(length & 0xFF);
            int i = 0;
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
            }
        }
    }

    static final class JsonRequestBody
    extends StreamingRequestBody {
        JsonRequestBody(List<byte[]> values) {
            super(Encoding.JSON, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.writeByte(91);
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
                if (i >= length) continue;
                sink.writeByte(44);
            }
            sink.writeByte(93);
        }
    }

    static abstract class StreamingRequestBody
    extends RequestBody {
        final MediaType contentType;
        final List<byte[]> values;
        final long contentLength;

        StreamingRequestBody(Encoding encoding, List<byte[]> values) {
            this.contentType = MediaType.parse((String)encoding.mediaType());
            this.values = values;
            this.contentLength = encoding.listSizeInBytes(values);
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }
    }
}

