/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.ssl.NoSSLSocketFactoryException;
import com.ibm.ws.security.common.ssl.SecuritySSLUtils;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.wsspi.ssl.SSLSupport;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import io.openliberty.security.oidcclientcore.http.BadPostRequestException;
import io.openliberty.security.oidcclientcore.http.HttpConstants;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcClientHttpUtil {
    public static final List<NameValuePair> commonHeaders;
    private static final TraceComponent tc;
    private final HttpUtils httpUtils = new HttpUtils();
    static OidcClientHttpUtil instance;
    static final long serialVersionUID = -1048635848529474401L;

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory getSSLSocketFactory(String sslConfigurationName, SSLSupport sslSupport) throws com.ibm.websphere.ssl.SSLException, NoSSLSocketFactoryException {
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = SecuritySSLUtils.getSSLSocketFactory((SSLSupport)sslSupport, (String)sslConfigurationName);
        }
        catch (SSLException sSLException) {
            void e;
            FFDCFilter.processException((Throwable)sSLException, (String)"io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil", (String)"69", (Object)this, (Object[])new Object[]{sslConfigurationName, sslSupport});
            throw new com.ibm.websphere.ssl.SSLException((Exception)e);
        }
        return sslSocketFactory;
    }

    public String extractEntityFromTokenResponse(Map<String, Object> postResponseMap) throws Exception {
        HttpResponse response = (HttpResponse)postResponseMap.get("RESPONSEMAP_CODE");
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity);
    }

    public HttpPost setupPost(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, String authMethod) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO RP POST TO URL [" + WebUtils.stripSecretFromUrl((String)url, (String)"client_secret") + "]"), (Object[])new Object[0]);
            this.httpUtils.debugPostToEndPoint(url, params, baUsername, baPassword, accessToken, commonHeaders);
        }
        HttpPost postMethod = this.httpUtils.createHttpPostMethod(url, commonHeaders);
        if (!"private_key_jwt".equals(authMethod)) {
            this.setAuthorizationHeaderForPostMethod(baUsername, baPassword, accessToken, postMethod, authMethod);
        }
        postMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return postMethod;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SSLException.class})
    HttpResponse setupResponse(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections, HttpPost postMethod) throws Exception {
        HttpClient httpClient = this.createHTTPClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
        HttpResponse response = null;
        ClassLoader origCL = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
        try {
            response = httpClient.execute((HttpUriRequest)postMethod);
        }
        catch (SSLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            void ioe;
            FFDCFilter.processException((Throwable)ex, (String)"io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil", (String)"117", (Object)this, (Object[])new Object[]{sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, postMethod});
            throw ioe;
        }
        finally {
            ThreadContextHelper.setClassLoader((ClassLoader)origCL);
        }
        return response;
    }

    Map<String, Object> finishPost(HttpResponse response, HttpPost postMethod) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", response);
        result.put("RESPONSEMAP_METHOD", postMethod);
        return result;
    }

    public Map<String, Object> postToEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        HttpPost postMethod = this.setupPost(url, params, baUsername, baPassword, accessToken, authMethod);
        return this.postToEndpoint(url, postMethod, sslSocketFactory, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
    }

    public Map<String, Object> postToEndpoint(String url, HttpPost postMethod, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        HttpResponse response = this.setupResponse(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, postMethod);
        StatusLine status = response.getStatusLine();
        if (status == null || status.getStatusCode() != 200) {
            String errorMsg = "Could not get the status of the response, or the response returned an error.";
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                errorMsg = EntityUtils.toString((HttpEntity)entity).trim();
            }
            if (status != null && status.getStatusCode() == 400) {
                throw new BadPostRequestException(errorMsg, 400);
            }
            throw new IOException("Failed to reach endpoint " + url + " because of the following error: " + errorMsg);
        }
        return this.finishPost(response, postMethod);
    }

    public Map<String, Object> postToIntrospectEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        HttpPost postMethod = this.setupPost(url, params, baUsername, baPassword, accessToken, authMethod);
        HttpResponse response = this.setupResponse(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, postMethod);
        return this.finishPost(response, postMethod);
    }

    public void setAuthorizationHeaderForPostMethod(String baUsername, @Sensitive String baPassword, String accessToken, HttpPost postMethod, String authMethod) {
        if (authMethod.contains("basic")) {
            String userpass = baUsername + ":" + baPassword;
            String encodedUserpass = Base64.getEncoder().encodeToString(userpass.getBytes());
            postMethod.setHeader("Authorization", "Basic " + encodedUserpass);
        }
        if (accessToken != null) {
            postMethod.addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    public static int getTokenEndPointPort(String url) {
        int last;
        int port = 0;
        int first = url.indexOf(":");
        if (first != (last = url.lastIndexOf(":"))) {
            int end = -1;
            int begin = last;
            if (begin > 0 && (end = url.substring(begin).indexOf("/")) > 0) {
                String s = url.substring(begin + 1, begin + end);
                port = Integer.valueOf(s);
            }
        } else if (url.startsWith("https:")) {
            port = 443;
        } else if (url.startsWith("http:")) {
            port = 80;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getFromEndpoint(String url, List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws HttpException, IOException {
        String query = null;
        if (params != null) {
            query = URLEncodedUtils.format(params, (Charset)HttpConstants.UTF_8);
        }
        if (query != null) {
            if (!url.endsWith("?")) {
                url = url + "?";
            }
            url = url + query;
        }
        HttpGet request = new HttpGet(url);
        for (NameValuePair nameValuePair : commonHeaders) {
            request.addHeader(nameValuePair.getName(), nameValuePair.getValue());
        }
        if (accessToken != null) {
            request.setHeader("Authorization", "Bearer " + accessToken);
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (baUsername != null) {
            credentialsProvider = this.httpUtils.createCredentialsProvider(baUsername, baPassword);
        }
        HttpClient httpClient = this.createHttpClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, credentialsProvider);
        HttpResponse response = null;
        ClassLoader origCL = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader((ClassLoader)this.getClass().getClassLoader());
        try {
            response = httpClient.execute((HttpUriRequest)request);
        }
        finally {
            ThreadContextHelper.setClassLoader((ClassLoader)origCL);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", response);
        result.put("RESPONSEMAP_METHOD", request);
        return result;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) {
        return this.httpUtils.createHttpClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword, boolean useSystemPropertiesForHttpClientConnections) {
        BasicCredentialsProvider credentialsProvider = this.httpUtils.createCredentialsProvider(baUser, baPassword);
        return this.httpUtils.createHttpClientWithCookieSpec(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, credentialsProvider);
    }

    public HttpClient createHttpClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections, BasicCredentialsProvider credentialsProvider) {
        return this.httpUtils.createHttpClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections, credentialsProvider);
    }

    public static OidcClientHttpUtil getInstance() {
        if (instance == null) {
            instance = new OidcClientHttpUtil();
        }
        return instance;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(OidcClientHttpUtil.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
        commonHeaders = new ArrayList<NameValuePair>();
        commonHeaders.add((NameValuePair)new BasicNameValuePair("Accept", "application/json"));
        instance = null;
    }
}

