/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.lang.reflect.Constructor;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.serialization.AbstractSerializableHolder;
import org.jboss.weld.util.reflection.DeclaredMemberIndexer;

public class ConstructorHolder<X>
extends AbstractSerializableHolder<Constructor<X>> {
    private static final long serialVersionUID = -6439218442811003152L;
    private final Class<X> declaringClass;
    private final int index;

    public static <T> ConstructorHolder<T> of(Constructor<T> constructor) {
        return new ConstructorHolder<T>(constructor);
    }

    public ConstructorHolder(Constructor<X> constructor) {
        super(constructor);
        this.declaringClass = constructor.getDeclaringClass();
        this.index = DeclaredMemberIndexer.getIndexForConstructor(constructor);
    }

    @Override
    protected Constructor<X> initialize() {
        try {
            return DeclaredMemberIndexer.getConstructorForIndex(this.index, this.declaringClass);
        }
        catch (Exception e) {
            throw ReflectionLogger.LOG.unableToGetConstructorOnDeserialization(this.declaringClass, this.index, e);
        }
    }
}

