/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.DummyManagedObject;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TransactionOptimisticReplaceLogRecord
extends LogRecord {
    private static final Class cclass = TransactionOptimisticReplaceLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = -4939541309211419352L;
    protected LogicalUnitOfWork logicalUnitOfWork;
    protected int transactionState;
    private List tokensToAdd;
    private List tokensToOptimisticReplace;
    private List serializedManagedObjectBytes;
    private List tokensToDelete;
    private List tokensToNotify;

    protected TransactionOptimisticReplaceLogRecord(InternalTransaction internalTransaction, List tokensToAdd, List tokensToOptimisticReplace, List serializedManagedObjectBytes, List tokensToDelete, List tokensToNotify) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{internalTransaction, tokensToAdd, tokensToOptimisticReplace, serializedManagedObjectBytes, tokensToDelete, tokensToNotify});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.transactionState = internalTransaction.getState();
        this.tokensToAdd = tokensToAdd;
        this.tokensToOptimisticReplace = tokensToOptimisticReplace;
        this.serializedManagedObjectBytes = serializedManagedObjectBytes;
        this.tokensToDelete = tokensToDelete;
        this.tokensToNotify = tokensToNotify;
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionOptimisticReplaceLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte[] serializedBuffer;
            int managedObjectLength;
            Token token;
            int i;
            int numberOfTokensToAdd = dataInputStream.readInt();
            int numberOfTokensToOptimisticReplace = dataInputStream.readInt();
            int numberOfTokensToDelete = dataInputStream.readInt();
            int numberOfTokensToNotify = dataInputStream.readInt();
            this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
            this.transactionState = dataInputStream.readInt();
            this.serializedManagedObjectBytes = new ArrayList(numberOfTokensToAdd + numberOfTokensToOptimisticReplace);
            this.tokensToAdd = new ArrayList(numberOfTokensToAdd);
            for (i = 0; i < numberOfTokensToAdd; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToAdd.add(token);
                managedObjectLength = dataInputStream.readInt();
                serializedBuffer = new byte[managedObjectLength];
                dataInputStream.read(serializedBuffer);
                this.serializedManagedObjectBytes.add(serializedBuffer);
            }
            this.tokensToOptimisticReplace = new ArrayList(numberOfTokensToOptimisticReplace);
            for (i = 0; i < numberOfTokensToOptimisticReplace; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToOptimisticReplace.add(token);
                managedObjectLength = dataInputStream.readInt();
                serializedBuffer = new byte[managedObjectLength];
                dataInputStream.read(serializedBuffer);
                this.serializedManagedObjectBytes.add(serializedBuffer);
            }
            this.tokensToDelete = new ArrayList(numberOfTokensToDelete);
            for (i = 0; i < numberOfTokensToDelete; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToDelete.add(token);
            }
            this.tokensToNotify = new ArrayList(numberOfTokensToNotify);
            for (i = 0; i < numberOfTokensToNotify; ++i) {
                token = Token.restore(dataInputStream, objectManagerState);
                this.tokensToNotify.add(token);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:174:1.11");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        ObjectManagerByteArrayOutputStream managedObjectBytes;
        int i;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffers");
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[1 + this.tokensToAdd.size() * 2 + this.tokensToOptimisticReplace.size() * 2 + this.tokensToDelete.size() + this.tokensToNotify.size()];
        int bufferIndex = 0;
        byteArrayOutputStream.reset();
        buffers[bufferIndex++] = byteArrayOutputStream;
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(this.tokensToAdd.size());
            dataOutputStream.writeInt(this.tokensToOptimisticReplace.size());
            dataOutputStream.writeInt(this.tokensToDelete.size());
            dataOutputStream.writeInt(this.tokensToNotify.size());
            this.logicalUnitOfWork.writeObject(dataOutputStream);
            dataOutputStream.writeInt(this.transactionState);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "getBuffers", exception, "1:228:1.11");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getBuffers", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        Iterator serializedObjectIterator = this.serializedManagedObjectBytes.iterator();
        for (i = 0; i < this.tokensToAdd.size(); ++i) {
            byteArrayOutputStream = new ObjectManagerByteArrayOutputStream((int)Token.maximumSerializedSize() + 4);
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((Token)this.tokensToAdd.get(i)).writeObject(dataOutputStream);
            managedObjectBytes = (ObjectManagerByteArrayOutputStream)serializedObjectIterator.next();
            try {
                dataOutputStream.writeInt(managedObjectBytes.getCount());
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "getBuffers", exception, "1:253:1.11");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "getBuffers", exception);
                }
                throw new PermanentIOException((Object)this, exception);
            }
            buffers[bufferIndex++] = byteArrayOutputStream;
            buffers[bufferIndex++] = managedObjectBytes;
        }
        for (i = 0; i < this.tokensToOptimisticReplace.size(); ++i) {
            byteArrayOutputStream = new ObjectManagerByteArrayOutputStream((int)Token.maximumSerializedSize() + 4);
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((Token)this.tokensToOptimisticReplace.get(i)).writeObject(dataOutputStream);
            managedObjectBytes = (ObjectManagerByteArrayOutputStream)serializedObjectIterator.next();
            try {
                dataOutputStream.writeInt(managedObjectBytes.getCount());
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "getBuffers", exception, "1:282:1.11");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "getBuffers", exception);
                }
                throw new PermanentIOException((Object)this, exception);
            }
            buffers[bufferIndex++] = byteArrayOutputStream;
            buffers[bufferIndex++] = managedObjectBytes;
        }
        for (i = 0; i < this.tokensToDelete.size(); ++i) {
            byteArrayOutputStream = new ObjectManagerByteArrayOutputStream((int)Token.maximumSerializedSize());
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((Token)this.tokensToDelete.get(i)).writeObject(dataOutputStream);
            buffers[bufferIndex++] = byteArrayOutputStream;
        }
        for (i = 0; i < this.tokensToNotify.size(); ++i) {
            byteArrayOutputStream = new ObjectManagerByteArrayOutputStream((int)Token.maximumSerializedSize());
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((Token)this.tokensToNotify.get(i)).writeObject(dataOutputStream);
            buffers[bufferIndex++] = byteArrayOutputStream;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", "return=" + buffers);
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{objectManagerState, this.logicalUnitOfWork, new Integer(this.transactionState), this.tokensToOptimisticReplace, this.serializedManagedObjectBytes, this.tokensToDelete, this.tokensToNotify});
        }
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        Iterator serializedObjectIterator = this.serializedManagedObjectBytes.iterator();
        ArrayList<ManagedObject> managedObjectsToAdd = new ArrayList<ManagedObject>(this.tokensToAdd.size());
        for (Token token : this.tokensToAdd) {
            byte[] managedObjectBytes = (byte[])serializedObjectIterator.next();
            ManagedObject managedObject = ManagedObject.restoreFromSerializedBytes(managedObjectBytes, objectManagerState);
            ManagedObject managedObjectToAdd = token.setManagedObject(managedObject);
            managedObjectToAdd.state = 1;
            managedObjectsToAdd.add(managedObjectToAdd);
        }
        ArrayList<ManagedObject> managedObjectsToOptimisticReplace = new ArrayList<ManagedObject>(this.tokensToOptimisticReplace.size());
        for (Token token : this.tokensToOptimisticReplace) {
            byte[] managedObjectBytes = (byte[])serializedObjectIterator.next();
            ManagedObject managedObject = ManagedObject.restoreFromSerializedBytes(managedObjectBytes, objectManagerState);
            ManagedObject managedObjectToReplace = token.setManagedObject(managedObject);
            managedObjectsToOptimisticReplace.add(managedObjectToReplace);
        }
        ArrayList<ManagedObject> managedObjectsToDelete = new ArrayList<ManagedObject>(this.tokensToDelete.size());
        for (Token token : this.tokensToDelete) {
            ManagedObject existingManagedObject = token.getManagedObject();
            if (existingManagedObject == null) {
                DummyManagedObject dummyManagedObject = new DummyManagedObject("Created by TransactionOptimisticReplaceLogRecord.performRecovery() (Delete)");
                existingManagedObject = token.setManagedObject(dummyManagedObject);
                existingManagedObject.state = 8;
            }
            managedObjectsToDelete.add(existingManagedObject);
        }
        ArrayList<DummyManagedObject> dummyManagedObjectsToNotify = new ArrayList<DummyManagedObject>();
        for (Token token : this.tokensToNotify) {
            ManagedObject existingManagedObject = token.getManagedObject();
            if (existingManagedObject != null) continue;
            DummyManagedObject dummyManagedObject = new DummyManagedObject("Created by TransactionOptimisticReplaceLogRecord.performRecovery() (Notify)");
            dummyManagedObject.state = 8;
            dummyManagedObjectsToNotify.add(dummyManagedObject);
            token.setManagedObject(dummyManagedObject);
        }
        transactionForRecovery.optimisticReplace(managedObjectsToAdd, managedObjectsToOptimisticReplace, managedObjectsToDelete, this.tokensToNotify);
        transactionForRecovery.internalTransaction.resetState(this.transactionState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    protected static long maximumSerializedSize() {
        return 20L + LogicalUnitOfWork.maximumSerializedSize() + 4L;
    }
}

