/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.xml;

import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.FieldInfo;
import com.ibm.ws.ras.instrument.internal.model.InstrumentationOptions;
import com.ibm.ws.ras.instrument.internal.model.MethodInfo;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TraceConfigFileParser
extends DefaultHandler {
    private String elementPath = "";
    private File file;
    private InstrumentationOptions instrumentationOptions = null;
    private Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();
    private Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>();
    private TraceOptionsData currentTraceOptions = null;
    private PackageInfo currentPackage = null;
    private ClassInfo currentClass = null;
    private FieldInfo currentField = null;
    private MethodInfo currentMethod = null;
    private StringBuffer currentData = null;
    private int currentArg = 0;

    public TraceConfigFileParser() {
    }

    public TraceConfigFileParser(File file) {
        this.setFile(file);
    }

    public void parse() throws IOException {
        if (this.file == null) {
            return;
        }
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            FileReader fr = new FileReader(this.file);
            xr.parse(new InputSource(fr));
        }
        catch (SAXException saxe) {
            IOException ioe = new IOException("Parse failure");
            ioe.initCause(saxe);
            throw ioe;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentData = new StringBuffer();
        this.elementPath = this.elementPath + "/" + localName;
        if (this.elementPath.equals("/trace-instrumentation/instrumentation-options")) {
            this.instrumentationOptions = new InstrumentationOptions();
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package")) {
            String packageName = attributes.getValue("", "name");
            this.currentPackage = new PackageInfo();
            this.currentPackage.setPackageName(packageName.trim());
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/trivial")) {
            this.currentPackage.setTrivial(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/trace-options")) {
            this.currentTraceOptions = new TraceOptionsData();
            this.currentPackage.setTraceOptionsData(this.currentTraceOptions);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class")) {
            String className = this.currentPackage.getPackageName() + "." + attributes.getValue("", "name");
            this.currentClass = new ClassInfo(className);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/sensitive")) {
            this.currentClass.setSensitive(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/trivial")) {
            this.currentClass.setTrivial(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/trace-options")) {
            this.currentTraceOptions = new TraceOptionsData();
            this.currentClass.setTraceOptionsData(this.currentTraceOptions);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/field")) {
            String fieldName = attributes.getValue("", "name");
            String fieldDescriptor = attributes.getValue("", "descriptor");
            this.currentField = new FieldInfo();
            this.currentField.setFieldName(fieldName);
            this.currentField.setFieldDescriptor(fieldDescriptor);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/field/logger")) {
            this.currentField.setLoggerField(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/field/sensitive")) {
            this.currentField.setSensitive(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method")) {
            String methodName = attributes.getValue("", "name");
            String methodDescriptor = attributes.getValue("", "descriptor");
            this.currentMethod = new MethodInfo(methodName, methodDescriptor);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method/sensitive")) {
            this.currentMethod.setResultSensitive(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method/trivial")) {
            this.currentMethod.setTrivial(true);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method/parameters/arg")) {
            String argNumber = attributes.getValue("", "index");
            this.currentArg = Integer.parseInt(argNumber);
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method/parameters/arg/sensitive")) {
            this.currentMethod.setArgIsSensitive(this.currentArg, true);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String data;
        String string = data = this.currentData != null ? this.currentData.toString() : null;
        if (this.elementPath.equals("/trace-instrumentation/annotations/package")) {
            this.packages.put(this.currentPackage.getInternalPackageName(), this.currentPackage);
            this.currentPackage = null;
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class")) {
            this.classes.put(this.currentClass.getInternalClassName(), this.currentClass);
            this.currentClass = null;
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/field")) {
            this.currentClass.getFieldInfoSet().add(this.currentField);
            this.currentField = null;
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method")) {
            this.currentClass.getMethodInfoSet().add(this.currentMethod);
            this.currentMethod = null;
        } else if (this.elementPath.endsWith("/trace-options")) {
            this.currentTraceOptions = null;
        } else if (this.elementPath.equals("/trace-instrumentation/instrumentation-options/packages/include")) {
            this.instrumentationOptions.addPackagesInclude(data);
        } else if (this.elementPath.equals("/trace-instrumentation/instrumentation-options/packages/exclude")) {
            this.instrumentationOptions.addPackagesExclude(data);
        } else if (this.elementPath.equals("/trace-instrumentation/instrumentation-options/ffdcEnabled")) {
            this.instrumentationOptions.setAddFFDC(Boolean.valueOf(data));
        } else if (this.elementPath.equals("/trace-instrumentation/instrumentation-options/trace-type")) {
            this.instrumentationOptions.setTraceType(data);
        } else if (this.elementPath.endsWith("/trace-options/traceGroup")) {
            this.currentTraceOptions.addTraceGroup(data);
        } else if (this.elementPath.endsWith("/trace-options/traceExceptionThrow")) {
            this.currentTraceOptions.setTraceExceptionThrow(Boolean.valueOf(data));
        } else if (this.elementPath.endsWith("/trace-options/traceExceptionHandling")) {
            this.currentTraceOptions.setTraceExceptionHandling(Boolean.valueOf(data));
        } else if (this.elementPath.equals("/trace-instrumentation/annotations/package/class/method/ffdcIgnore/exception")) {
            data = data.replaceAll("\\.", "/");
            this.currentMethod.addFFDCIgnoreException(Type.getObjectType((String)data));
        }
        this.elementPath = this.elementPath.replaceAll("\\/[^\\/]+$", "");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length).trim();
        this.currentData.append(data);
    }

    @Override
    public void endDocument() throws SAXException {
        for (ClassInfo ci : this.classes.values()) {
            PackageInfo pi = this.getPackageInfo(ci.getInternalPackageName());
            if (pi == null) continue;
            ci.updateDefaultValuesFromPackageInfo(pi);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Collection<ClassInfo> getClassInfo() {
        return this.classes.values();
    }

    public ClassInfo getClassInfo(String internalClassName) {
        return this.classes.get(internalClassName);
    }

    public InstrumentationOptions getInstrumentationOptions() {
        return this.instrumentationOptions;
    }

    public Collection<PackageInfo> getPackageInfo() {
        return this.packages.values();
    }

    public PackageInfo getPackageInfo(String internalPackageName) {
        return this.packages.get(internalPackageName);
    }

    public static void main(String[] args) throws Exception {
        TraceConfigFileParser parser = new TraceConfigFileParser();
        if (args.length != 1) {
            parser.setFile(new File("trace.xml"));
        } else {
            parser.setFile(new File(args[0]));
        }
        parser.parse();
        System.out.println(parser.instrumentationOptions);
        System.out.println(parser.packages);
        System.out.println(parser.classes);
    }
}

