/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.flow.MethodCallNode;
import jakarta.faces.flow.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.flow.Freezable;

public class MethodCallNodeImpl
extends MethodCallNode
implements Freezable {
    private String id;
    private MethodExpression methodExpression;
    private ValueExpression outcome;
    private List<Parameter> parameters;
    private List<Parameter> unmodifiableParameters;
    private boolean initialized;

    public MethodCallNodeImpl(String methodCallNodeId) {
        this.id = methodCallNodeId;
        this.parameters = new ArrayList<Parameter>();
        this.unmodifiableParameters = Collections.unmodifiableList(this.parameters);
    }

    public MethodExpression getMethodExpression() {
        return this.methodExpression;
    }

    public ValueExpression getOutcome() {
        return this.outcome;
    }

    public List<Parameter> getParameters() {
        return this.unmodifiableParameters;
    }

    public void addParameter(Parameter parameter) {
        this.checkInitialized();
        this.parameters.add(parameter);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void freeze() {
        this.initialized = true;
        for (Parameter value : this.parameters) {
            if (!(value instanceof Freezable)) continue;
            ((Freezable)value).freeze();
        }
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setMethodExpression(MethodExpression methodExpression) {
        this.checkInitialized();
        this.methodExpression = methodExpression;
    }

    public void setOutcome(ValueExpression outcome) {
        this.checkInitialized();
        this.outcome = outcome;
    }

    public void setId(String id) {
        this.checkInitialized();
        this.id = id;
    }
}

