/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

@ChannelHandler.Sharable
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CRLFValidationHandler
extends ChannelInboundHandlerAdapter {
    private static final int MAX_CRLF_ALLOWED = 2;
    public static final CRLFValidationHandler INSTANCE;
    static final long serialVersionUID = 3184696698048149427L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private CRLFValidationHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        byte b;
        if (!(msg instanceof ByteBuf)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf buffer = (ByteBuf)msg;
        buffer.markReaderIndex();
        int leadingCRLFCount = 0;
        while (buffer.isReadable() && (b = buffer.readByte()) == 13 && buffer.isReadable() && buffer.readByte() == 10) {
            if (++leadingCRLFCount <= 2) continue;
            ctx.channel().attr(NettyHttpConstants.THROW_FFDC).set((Object)true);
            throw new IllegalArgumentException("Too many leading CRLF characters");
        }
        buffer.resetReaderIndex();
        ctx.fireChannelRead(msg);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.CRLFValidationHandler", CRLFValidationHandler.class, null, null);
        INSTANCE = new CRLFValidationHandler();
    }
}

