/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.info.internal.ArrayClassInfo;
import com.ibm.ws.anno.info.internal.ClassInfoImpl;
import com.ibm.ws.anno.info.internal.DelayedClassInfo;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.anno.info.internal.NonDelayedClassInfo;
import com.ibm.ws.anno.info.internal.PackageInfoImpl;
import com.ibm.ws.anno.info.internal.PrimitiveClassInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.InfoStoreException;
import com.ibm.wsspi.anno.util.Util_Factory;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassInfoCache {
    private static final TraceComponent tc;
    public static final String CLASS_NAME;
    protected String hashText = ClassInfoCache.class.getName() + "@" + Integer.toString(new Object().hashCode());
    protected InfoStoreImpl infoStore;
    protected Util_InternMap descriptionInternMap;
    protected Util_InternMap packageNameInternMap;
    protected Util_InternMap classNameInternMap;
    protected Util_InternMap fieldNameInternMap;
    protected Util_InternMap methodNameInternMap;
    protected Map<String, PackageInfoImpl> packageInfos;
    protected static final boolean DO_FORCE_PACKAGE = true;
    protected static final boolean DO_NOT_FORCE_PACKAGE = false;
    protected static final boolean FOR_FAILED_LOAD = true;
    protected static final boolean NOT_FOR_FAILED_LOAD = false;
    protected HashMap<String, PrimitiveClassInfo> primitiveClassInfos;
    protected static final boolean DO_ALLOW_PRIMITIVE = true;
    protected static final boolean DO_NOT_ALLOW_PRIMITIVE = false;
    protected Map<String, DelayedClassInfo> delayedClassInfos;
    public static final String CLASSINFO_CACHE_LIMIT_PROPERTY_NAME = "classinfocachesize";
    public static final int MIN_CLASSINFO_CACHE_LIMIT = 100;
    public static final int MAX_CLASSINFO_CACHE_LIMIT = 10000;
    public static final int DEFAULT_CLASSINFO_CACHE_LIMIT = 2000;
    protected static final int classInfoCacheLimit;
    protected Map<String, NonDelayedClassInfo> javaClassInfos;
    protected Map<String, NonDelayedClassInfo> annotatedClassInfos;
    protected NonDelayedClassInfo firstClassInfo;
    protected NonDelayedClassInfo lastClassInfo;
    protected Map<String, NonDelayedClassInfo> classInfos;
    static final long serialVersionUID = 5186322941670956268L;

    public void discardRef(Object objectRef) {
    }

    public ClassInfoCache(InfoStoreImpl infoStore) {
        this.infoStore = infoStore;
        Util_Factory utilFactory = infoStore.getInfoStoreFactory().getUtilFactory();
        this.descriptionInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_OTHER, "DescriptionMap");
        this.packageNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_CLASS_NAME, "PackageNameMap");
        this.classNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_CLASS_NAME, "ClassNameMap");
        this.fieldNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_FIELD_NAME, "FieldNameMap");
        this.methodNameInternMap = utilFactory.createInternMap(Util_InternMap.ValueType.VT_METHOD_NAME, "MethodNameMap");
        this.packageInfos = new HashMap<String, PackageInfoImpl>();
        this.primitiveClassInfos = new HashMap();
        this.delayedClassInfos = new HashMap<String, DelayedClassInfo>();
        this.javaClassInfos = new HashMap<String, NonDelayedClassInfo>();
        this.annotatedClassInfos = new HashMap<String, NonDelayedClassInfo>();
        this.classInfos = new HashMap<String, NonDelayedClassInfo>();
        this.firstClassInfo = null;
        this.lastClassInfo = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Created on manager [ {1} ]", this.getHashText(), this.getInfoStore().getHashText()), (Object[])new Object[0]);
        }
    }

    protected String getHashText() {
        return this.hashText;
    }

    public InfoStoreImpl getInfoStore() {
        return this.infoStore;
    }

    protected void scanClass(String name) throws InfoStoreException {
        this.getInfoStore().scanClass(name);
    }

    protected void scanPackage(String packageClassName) throws InfoStoreException {
        this.getInfoStore().scanNewClass(packageClassName);
    }

    public Util_InternMap getDescriptionInternMap() {
        return this.descriptionInternMap;
    }

    public String internDescription(String description) {
        return this.getDescriptionInternMap().intern(description);
    }

    public Util_InternMap getPackageNameInternMap() {
        return this.packageNameInternMap;
    }

    public String internPackageName(String packageName) {
        return this.getPackageNameInternMap().intern(packageName);
    }

    public Util_InternMap getClassNameInternMap() {
        return this.classNameInternMap;
    }

    public String internClassName(String className) {
        return this.getClassNameInternMap().intern(className);
    }

    public Util_InternMap getFieldNameInternMap() {
        return this.fieldNameInternMap;
    }

    public String internFieldName(String fieldName) {
        return this.getFieldNameInternMap().intern(fieldName);
    }

    public Util_InternMap getMethodNameInternMap() {
        return this.methodNameInternMap;
    }

    public String internMethodName(String fieldName) {
        return this.getMethodNameInternMap().intern(fieldName);
    }

    protected PackageInfoImpl basicGetPackageInfo(String packageName) {
        return this.packageInfos.get(packageName);
    }

    protected PackageInfoImpl basicAddPackageInfo(String name, int access) {
        PackageInfoImpl packageInfo = new PackageInfoImpl(name, access, this.getInfoStore());
        packageInfo.setModifiers(access);
        this.packageInfos.put(name, packageInfo);
        return packageInfo;
    }

    /*
     * WARNING - void declaration
     */
    protected PackageInfoImpl getPackageInfo(String packageName, boolean doForce) {
        boolean failedLoad;
        PackageInfoImpl packageInfo;
        block6: {
            packageInfo = this.packageInfos.get(packageName);
            if (packageInfo != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] - cached", this.getHashText(), packageInfo.getHashText()), (Object[])new Object[0]);
                }
                return packageInfo;
            }
            String packageClassName = PackageInfoImpl.addClassNameToPackageName(packageName);
            try {
                this.scanPackage(packageClassName);
                failedLoad = false;
            }
            catch (InfoStoreException infoStoreException) {
                void e;
                FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.anno.info.internal.ClassInfoCache", (String)"274", (Object)this, (Object[])new Object[]{packageName, doForce});
                failedLoad = true;
                Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_SCAN_EXCEPTION", (Object[])new Object[]{this.getHashText(), packageClassName, e.getMessage(), e.getCause() == null ? e.getMessage() : e.getCause().getMessage()});
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [ {1} ]: Scan exception: Generating artifical package", this.getHashText(), packageClassName), (Object[])new Object[0]);
            }
        }
        packageInfo = this.packageInfos.get(packageName);
        if (packageInfo == null && (doForce || failedLoad)) {
            packageInfo = this.storeArtificalPackage(packageName, failedLoad);
        }
        if (tc.isDebugEnabled()) {
            String packageText = packageInfo != null ? packageInfo.getHashText() : null;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] - new ", this.getHashText(), packageText), (Object[])new Object[0]);
        }
        return packageInfo;
    }

    protected PackageInfoImpl storeArtificalPackage(String packageName, boolean forFailedLoad) {
        PackageInfoImpl packageInfo = new PackageInfoImpl(packageName, 0, this.getInfoStore());
        packageInfo.setIsArtificial(true);
        packageInfo.setForFailedLoad(forFailedLoad);
        String i_packageName = packageInfo.getName();
        this.packageInfos.put(i_packageName, packageInfo);
        return packageInfo;
    }

    protected ClassInfoImpl getDelayableClassInfo(Type type) {
        String classInfoCase;
        ClassInfoImpl classInfo;
        int sort;
        String typeClassName = type.getClassName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER [ {1} ] [ {2} ]", this.getHashText(), type, typeClassName), (Object[])new Object[0]);
        }
        if ((sort = type.getSort()) == 9) {
            classInfo = this.getArrayClassInfo(typeClassName, type);
            classInfoCase = "array class";
        } else if (sort == 10) {
            classInfo = this.getDelayableClassInfo(typeClassName, false);
            classInfoCase = classInfo.isJavaClass() ? (classInfo.isDelayedClass() ? "java delayed" : "java non-delayed") : (classInfo.isDelayedClass() ? "non-java delayed" : "non-java non-delayed");
        } else {
            classInfo = this.getPrimitiveClassInfo(typeClassName, type);
            classInfoCase = "primitive class";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] [ {2} ]", this.getHashText(), classInfo.getHashText(), classInfoCase), (Object[])new Object[0]);
        }
        return classInfo;
    }

    public ArrayClassInfo getArrayClassInfo(String typeClassName, Type arrayType) {
        ClassInfoImpl elementClassInfo = this.getDelayableClassInfo(arrayType.getElementType());
        return new ArrayClassInfo(typeClassName, elementClassInfo);
    }

    public static Class<?> getPrimitiveClass(Type type) {
        switch (type.getDescriptor().charAt(0)) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        throw new IllegalArgumentException("Unrecognized type [ " + type.getDescriptor() + " ]");
    }

    public static Type getPrimitiveType(String className) {
        if (className.equals("byte")) {
            return Type.BYTE_TYPE;
        }
        if (className.equals("char")) {
            return Type.CHAR_TYPE;
        }
        if (className.equals("double")) {
            return Type.DOUBLE_TYPE;
        }
        if (className.equals("float")) {
            return Type.FLOAT_TYPE;
        }
        if (className.equals("int")) {
            return Type.INT_TYPE;
        }
        if (className.equals("long")) {
            return Type.LONG_TYPE;
        }
        if (className.equals("short")) {
            return Type.SHORT_TYPE;
        }
        if (className.equals("void")) {
            return Type.VOID_TYPE;
        }
        if (className.equals("boolean")) {
            return Type.BOOLEAN_TYPE;
        }
        return null;
    }

    public PrimitiveClassInfo getPrimitiveClassInfo(String typeClassName, Type primitiveType) {
        String primitiveClassInfoCase;
        PrimitiveClassInfo primitiveClassInfo = this.primitiveClassInfos.get(typeClassName);
        if (primitiveClassInfo == null) {
            Class<?> typeClass = ClassInfoCache.getPrimitiveClass(primitiveType);
            primitiveClassInfo = new PrimitiveClassInfo(typeClassName, typeClass, this.getInfoStore());
            primitiveClassInfoCase = "created";
            typeClassName = primitiveClassInfo.getName();
            this.primitiveClassInfos.put(typeClassName, primitiveClassInfo);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Primitives cache size [ {1} ]", this.getHashText(), this.primitiveClassInfos.size()), (Object[])new Object[0]);
            }
        } else {
            primitiveClassInfoCase = "cached";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] [ {2} ]", this.getHashText(), primitiveClassInfo.getHashText(), primitiveClassInfoCase), (Object[])new Object[0]);
        }
        return primitiveClassInfo;
    }

    public ClassInfoImpl getDelayableClassInfo(String name, boolean allowPrimitive) {
        Type primitiveType;
        String useHashText;
        String string = useHashText = tc.isDebugEnabled() ? this.getHashText() : null;
        if (allowPrimitive && (primitiveType = ClassInfoCache.getPrimitiveType(name)) != null) {
            PrimitiveClassInfo primitiveClassInfo = this.getPrimitiveClassInfo(name, primitiveType);
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] primitive class", useHashText, primitiveClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return primitiveClassInfo;
        }
        NonDelayedClassInfo javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] java class", useHashText, javaClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return javaClassInfo;
        }
        NonDelayedClassInfo annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] annotated class", useHashText, annotatedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return annotatedClassInfo;
        }
        DelayedClassInfo delayedClassInfo = this.basicGetDelayedClassInfo(name);
        if (delayedClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] already delayed", useHashText, delayedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return delayedClassInfo;
        }
        delayedClassInfo = this.basicPutDelayedClassInfo(name);
        NonDelayedClassInfo nonDelayedClassInfo = this.associate(delayedClassInfo);
        if (useHashText != null) {
            if (nonDelayedClassInfo != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] newly created delayed for [ {2} ]", useHashText, delayedClassInfo.getHashText(), nonDelayedClassInfo.getHashText()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] newly created delayed", useHashText, delayedClassInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        return delayedClassInfo;
    }

    public ClassInfoImpl getNonDelayedClassInfo(String name, boolean allowPrimitive) {
        Type primitiveType;
        String useHashText;
        String string = useHashText = tc.isDebugEnabled() ? this.getHashText() : null;
        if (allowPrimitive && (primitiveType = ClassInfoCache.getPrimitiveType(name)) != null) {
            PrimitiveClassInfo primitiveClassInfo = this.getPrimitiveClassInfo(name, primitiveType);
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] primitive class", useHashText, primitiveClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return primitiveClassInfo;
        }
        NonDelayedClassInfo javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] java class", useHashText, javaClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return javaClassInfo;
        }
        NonDelayedClassInfo annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] annotated class", useHashText, annotatedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return annotatedClassInfo;
        }
        NonDelayedClassInfo nonDelayedClassInfo = this.basicGetClassInfo(name);
        if (nonDelayedClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ]", useHashText, nonDelayedClassInfo.getHashText()), (Object[])new Object[0]);
            }
        } else {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ null ]", useHashText), (Object[])new Object[0]);
        }
        return nonDelayedClassInfo;
    }

    protected DelayedClassInfo basicGetDelayedClassInfo(String name) {
        return this.delayedClassInfos.get(name);
    }

    protected DelayedClassInfo basicPutDelayedClassInfo(String name) {
        DelayedClassInfo delayedClassInfo = new DelayedClassInfo(name, this.getInfoStore());
        name = delayedClassInfo.getName();
        this.delayedClassInfos.put(name, delayedClassInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Adding delayed class info [ {1} ]", this.getHashText(), delayedClassInfo.getHashText()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Delayed cache size [ {1} ]", this.getHashText(), this.delayedClassInfos.size()), (Object[])new Object[0]);
        }
        return delayedClassInfo;
    }

    protected NonDelayedClassInfo associate(DelayedClassInfo delayedClassInfo) {
        NonDelayedClassInfo nonDelayedClassInfo = this.basicGetClassInfo(delayedClassInfo.getName());
        if (nonDelayedClassInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Attaching delayed [ {1} ] to non-delayed [ {2} ]", this.getHashText(), delayedClassInfo.getHashText(), nonDelayedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            delayedClassInfo.setClassInfo(nonDelayedClassInfo);
            nonDelayedClassInfo.setDelayedClassInfo(delayedClassInfo);
            return nonDelayedClassInfo;
        }
        return null;
    }

    protected ClassInfoImpl associate(NonDelayedClassInfo nonDelayedClassInfo) {
        DelayedClassInfo delayedClassInfo = this.basicGetDelayedClassInfo(nonDelayedClassInfo.getName());
        if (delayedClassInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Attaching delayed [ {1} ] to non-delayed [ {2} ]", this.getHashText(), delayedClassInfo.getHashText(), nonDelayedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            delayedClassInfo.setClassInfo(nonDelayedClassInfo);
            nonDelayedClassInfo.setDelayedClassInfo(delayedClassInfo);
            return delayedClassInfo;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] No delayed available for non-delayed [ {1} ]", this.getHashText(), nonDelayedClassInfo.getHashText()), (Object[])new Object[0]);
        }
        return null;
    }

    @Trivial
    protected NonDelayedClassInfo basicGetJavaClassInfo(String name) {
        return this.javaClassInfos.get(name);
    }

    protected boolean basicPutJavaClassInfo(NonDelayedClassInfo classInfo) {
        String classInfoName = classInfo.getName();
        NonDelayedClassInfo extantClassInfo = this.javaClassInfos.get(classInfoName);
        if (extantClassInfo == null) {
            this.javaClassInfos.put(classInfoName, classInfo);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Add of [ {1} ] increases java cache to [ {2} ]", this.getHashText(), classInfo.getHashText(), this.javaClassInfos.size()), (Object[])new Object[0]);
            }
            return true;
        }
        if (extantClassInfo != classInfo) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_EXISTS1", (Object[])new Object[]{this.getHashText(), classInfo.getHashText(), extantClassInfo.getHashText()});
        } else {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_EXISTS2", (Object[])new Object[]{this.getHashText(), classInfo.getHashText()});
        }
        return false;
    }

    protected NonDelayedClassInfo basicGetAnnotatedClassInfo(String name) {
        return this.annotatedClassInfos.get(name);
    }

    protected boolean basicPutAnnotatedClassInfo(NonDelayedClassInfo classInfo) {
        String classInfoName = classInfo.getName();
        NonDelayedClassInfo extantClassInfo = this.annotatedClassInfos.get(classInfoName);
        if (extantClassInfo == null) {
            this.annotatedClassInfos.put(classInfoName, classInfo);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Add of [ {1} ] increases annotated cache to [ {2} ]", this.getHashText(), classInfo.getHashText(), this.annotatedClassInfos.size()), (Object[])new Object[0]);
            }
            return true;
        }
        if (extantClassInfo != classInfo) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_EXISTS3", (Object[])new Object[]{this.getHashText(), classInfo.getHashText(), extantClassInfo.getHashText()});
        } else {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_EXISTS4", (Object[])new Object[]{this.getHashText(), classInfo.getHashText()});
        }
        return false;
    }

    protected NonDelayedClassInfo basicGetClassInfo(String name) {
        if (this.firstClassInfo != null && name.equals(this.firstClassInfo.getName())) {
            return this.firstClassInfo;
        }
        return this.classInfos.get(name);
    }

    protected boolean basicPutClassInfo(NonDelayedClassInfo classInfo) {
        String classInfoName = classInfo.getName();
        NonDelayedClassInfo extantClassInfo = this.classInfos.get(classInfoName);
        if (extantClassInfo == null) {
            this.classInfos.put(classInfoName, classInfo);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Add of [ {1} ] increases class cache to [ {2} ]", this.getHashText(), classInfo.getHashText(), this.classInfos.size()), (Object[])new Object[0]);
            }
            return true;
        }
        if (extantClassInfo != classInfo) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_EXISTS1", (Object[])new Object[]{this.getHashText(), classInfo.getHashText(), extantClassInfo.getHashText()});
        } else {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_EXISTS2", (Object[])new Object[]{this.getHashText(), classInfo.getHashText()});
        }
        return false;
    }

    protected NonDelayedClassInfo createClassInfo(String name, String superName, int access, String[] interfaces) {
        return new NonDelayedClassInfo(name, superName, access, interfaces, this.getInfoStore());
    }

    protected boolean addClassInfo(NonDelayedClassInfo classInfo) {
        boolean didAdd;
        if (classInfo.isJavaClass()) {
            didAdd = this.basicPutJavaClassInfo(classInfo);
        } else if (classInfo.isAnnotationPresent() || classInfo.isFieldAnnotationPresent() || classInfo.isMethodAnnotationPresent()) {
            didAdd = this.basicPutAnnotatedClassInfo(classInfo);
        } else {
            didAdd = this.basicPutClassInfo(classInfo);
            if (didAdd) {
                this.addAsFirst(classInfo);
            }
        }
        if (didAdd) {
            ClassInfoImpl delayedClassInfo = this.associate(classInfo);
            this.discardRef(delayedClassInfo);
        }
        return didAdd;
    }

    /*
     * WARNING - void declaration
     */
    public NonDelayedClassInfo resolveClassInfo(String name) {
        NonDelayedClassInfo cachedClassInfo = this.basicGetClassInfo(name);
        if (cachedClassInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] - cached", this.getHashText(), cachedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return cachedClassInfo;
        }
        String useHashText = tc.isDebugEnabled() ? this.getHashText() : null;
        NonDelayedClassInfo javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] java class", useHashText, javaClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return javaClassInfo;
        }
        NonDelayedClassInfo annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] annotated class", useHashText, annotatedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return annotatedClassInfo;
        }
        if (useHashText != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("ENTRY [ {0} ] Class [ {1} ] ", useHashText, name), (Object[])new Object[0]);
        }
        try {
            this.scanClass(name);
        }
        catch (InfoStoreException infoStoreException) {
            void e;
            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.anno.info.internal.ClassInfoCache", (String)"1082", (Object)this, (Object[])new Object[]{name});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSINFO_SCAN_EXCEPTION", (Object[])new Object[]{this.getHashText(), name, e.getMessage(), e.getCause() == null ? e.getMessage() : e.getCause().getMessage()});
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ null ]; class scan failed with an exception", useHashText, name), (Object[])new Object[0]);
            }
            return null;
        }
        cachedClassInfo = this.basicGetClassInfo(name);
        if (cachedClassInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER / RETURN [ {1} ] - newly cached", this.getHashText(), cachedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return cachedClassInfo;
        }
        javaClassInfo = this.basicGetJavaClassInfo(name);
        if (javaClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] newly added java class", useHashText, javaClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return javaClassInfo;
        }
        annotatedClassInfo = this.basicGetAnnotatedClassInfo(name);
        if (annotatedClassInfo != null) {
            if (useHashText != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] new added annotated class", useHashText, annotatedClassInfo.getHashText()), (Object[])new Object[0]);
            }
            return annotatedClassInfo;
        }
        if (useHashText != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ null ] for class which was not found", useHashText, name), (Object[])new Object[0]);
        }
        return null;
    }

    protected void addAsFirst(NonDelayedClassInfo classInfo) {
        String useClassHashText;
        String methodName = "addAsFirst";
        boolean doLog = tc.isDebugEnabled();
        String useHashText = doLog ? this.getHashText() : null;
        String string = useClassHashText = doLog ? classInfo.getHashText() : null;
        if (doLog) {
            this.logLinks(methodName, classInfo);
        }
        if (this.firstClassInfo == null) {
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Adding [ {1} ] to empty", useHashText, useClassHashText), (Object[])new Object[0]);
            }
            this.firstClassInfo = classInfo;
            this.lastClassInfo = classInfo;
        } else if (this.firstClassInfo == this.lastClassInfo) {
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Adding [ {1} ] to singleton [ {2} ]", useHashText, useClassHashText, this.firstClassInfo.getHashText()), (Object[])new Object[0]);
            }
            this.firstClassInfo = classInfo;
            this.firstClassInfo.setNextClassInfo(this.lastClassInfo);
            this.lastClassInfo.setPriorClassInfo(classInfo);
        } else {
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Adding [ {1} ] to multitude [ {2} ]", useHashText, useClassHashText, this.firstClassInfo.getHashText()), (Object[])new Object[0]);
            }
            classInfo.setNextClassInfo(this.firstClassInfo);
            this.firstClassInfo.setPriorClassInfo(classInfo);
            this.firstClassInfo = classInfo;
            if (this.classInfos.size() > classInfoCacheLimit) {
                DelayedClassInfo delayedClassInfo;
                NonDelayedClassInfo oldLastClassInfo = this.lastClassInfo;
                String lastClassName = this.lastClassInfo.getName();
                this.classInfos.remove(lastClassName);
                this.discardRef(lastClassName);
                this.lastClassInfo = oldLastClassInfo.getPriorClassInfo();
                this.lastClassInfo.setNextClassInfo(null);
                oldLastClassInfo.setPriorClassInfo(null);
                if (doLog) {
                    Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] new last [ {1} ] displaces [ {2} ]", useHashText, this.lastClassInfo.getHashText(), oldLastClassInfo.getHashText()), (Object[])new Object[0]);
                }
                if ((delayedClassInfo = oldLastClassInfo.getDelayedClassInfo()) != null) {
                    if (doLog) {
                        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Clearing link on displaced [ {1} ]", useHashText, oldLastClassInfo.getHashText()), (Object[])new Object[0]);
                    }
                    delayedClassInfo.setClassInfo(null);
                    oldLastClassInfo.setDelayedClassInfo(null);
                }
            }
        }
    }

    public void makeFirst(NonDelayedClassInfo classInfo) {
        String useClassHashText;
        String methodName = "makeFirst";
        boolean doLog = tc.isDebugEnabled();
        String useHashText = doLog ? this.getHashText() : null;
        String string = useClassHashText = doLog ? classInfo.getHashText() : null;
        if (doLog) {
            this.logLinks(methodName, classInfo);
        }
        if (classInfo == this.firstClassInfo) {
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Already first [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
            }
            return;
        }
        if (classInfo == this.lastClassInfo) {
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Moving from last [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Old first [ {1} ]", useHashText, this.firstClassInfo.getHashText()), (Object[])new Object[0]);
            }
            this.lastClassInfo = classInfo.getPriorClassInfo();
            this.lastClassInfo.setNextClassInfo(null);
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] New last [ {1} ]", useHashText, this.lastClassInfo.getHashText()), (Object[])new Object[0]);
            }
            this.firstClassInfo.setPriorClassInfo(classInfo);
            classInfo.setPriorClassInfo(null);
            classInfo.setNextClassInfo(this.firstClassInfo);
            this.firstClassInfo = classInfo;
        } else {
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Moving from middle [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Old first [ {1} ]", useHashText, this.firstClassInfo.getHashText()), (Object[])new Object[0]);
            }
            NonDelayedClassInfo currentPrior = classInfo.getPriorClassInfo();
            NonDelayedClassInfo currentNext = classInfo.getNextClassInfo();
            currentPrior.setNextClassInfo(currentNext);
            currentNext.setPriorClassInfo(currentPrior);
            this.firstClassInfo.setPriorClassInfo(classInfo);
            classInfo.setNextClassInfo(this.firstClassInfo);
            classInfo.setPriorClassInfo(null);
            this.firstClassInfo = classInfo;
        }
    }

    public void removeAsDelayable(NonDelayedClassInfo classInfo) {
        String useClassHashText;
        String methodName = "removeAsDelayable";
        boolean doLog = tc.isDebugEnabled();
        String useHashText = doLog ? this.getHashText() : null;
        String string = useClassHashText = doLog ? classInfo.getHashText() : null;
        if (doLog) {
            this.logLinks(methodName, classInfo);
        }
        if (this.firstClassInfo == null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Ignoring remove request; no linked classes [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
            return;
        }
        NonDelayedClassInfo currentPrior = classInfo.getPriorClassInfo();
        NonDelayedClassInfo currentNext = classInfo.getNextClassInfo();
        if (this.firstClassInfo != classInfo && currentPrior == null && currentNext == null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Ignoring remove request; not yet linked [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
            return;
        }
        if (currentPrior != null) {
            currentPrior.setNextClassInfo(currentNext);
        } else {
            this.firstClassInfo = currentNext;
        }
        if (currentNext != null) {
            currentNext.setPriorClassInfo(currentPrior);
        } else {
            this.lastClassInfo = currentPrior;
        }
        classInfo.setPriorClassInfo(null);
        classInfo.setNextClassInfo(null);
        this.classInfos.remove(classInfo.getName());
        this.basicPutAnnotatedClassInfo(classInfo);
        if (doLog) {
            if (currentPrior == null && currentNext == null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Removing as singleton [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
            } else if (currentPrior == null && currentNext != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Removing as first [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] New first [ {1} ]", useHashText, currentNext.getHashText()), (Object[])new Object[0]);
            } else if (currentPrior != null && currentNext == null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Removing as last [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] New last [ {1} ]", useHashText, currentPrior.getHashText()), (Object[])new Object[0]);
            } else if (currentPrior != null && currentNext != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Removing from middle [ {1} ]", useHashText, useClassHashText), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Old prior [ {1} ]", useHashText, currentPrior.getHashText()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Old next [ {1} ]", useHashText, currentNext.getHashText()), (Object[])new Object[0]);
            }
        }
    }

    protected void logLinks(String methodName, NonDelayedClassInfo classInfo) {
        if (classInfo.getNextClassInfo() != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] Next [ {2} ]", this.getHashText(), classInfo.getHashText(), classInfo.getNextClassInfo().getHashText()), (Object[])new Object[0]);
        }
        if (classInfo.getPriorClassInfo() != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] Prior [ {2} ]", this.getHashText(), classInfo.getHashText(), classInfo.getPriorClassInfo().getHashText()), (Object[])new Object[0]);
        }
    }

    public void recordAccess(NonDelayedClassInfo classInfo) {
        this.makeFirst(classInfo);
    }

    protected void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Info Store [ {0} ]", this.getInfoStore().getHashText()), (Object[])new Object[0]);
        this.log_internMaps(logger);
        this.log_packages(logger);
        this.log_primitiveClasses(logger);
        this.log_delayedClasses(logger);
        this.log_javaClasses(logger);
        this.log_annotatedClasses(logger);
        this.log_classes(logger);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    protected void log_internMaps(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Intern Maps:", (Object[])new Object[0]);
        this.getDescriptionInternMap().log(logger);
        this.getPackageNameInternMap().log(logger);
        this.getClassNameInternMap().log(logger);
        Tr.debug((TraceComponent)logger, (String)"END Intern Maps:", (Object[])new Object[0]);
    }

    protected void log_packages(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Packages:", (Object[])new Object[0]);
        for (PackageInfoImpl packageInfo : this.packageInfos.values()) {
            packageInfo.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"END Packages", (Object[])new Object[0]);
    }

    protected void log_classes(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Classes:", (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  First Class [ {0} ]:", this.firstClassInfo == null ? null : this.firstClassInfo.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Last Class [ {0} ]:", this.lastClassInfo == null ? null : this.lastClassInfo.getHashText()), (Object[])new Object[0]);
        for (NonDelayedClassInfo classInfo : this.classInfos.values()) {
            classInfo.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"END Classes", (Object[])new Object[0]);
    }

    protected void log_annotatedClasses(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Annotated Classes:", (Object[])new Object[0]);
        for (NonDelayedClassInfo annotatedClassInfo : this.annotatedClassInfos.values()) {
            annotatedClassInfo.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"END Annotated Classes", (Object[])new Object[0]);
    }

    protected void log_javaClasses(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Java Classes:", (Object[])new Object[0]);
        for (NonDelayedClassInfo javaClassInfo : this.javaClassInfos.values()) {
            javaClassInfo.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"END Java Classes", (Object[])new Object[0]);
    }

    protected void log_delayedClasses(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Delayed Classes:", (Object[])new Object[0]);
        for (ClassInfoImpl classInfoImpl : this.delayedClassInfos.values()) {
            classInfoImpl.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"END Delayed Classes", (Object[])new Object[0]);
    }

    protected void log_primitiveClasses(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)"BEGIN Primitive Classes:", (Object[])new Object[0]);
        for (PrimitiveClassInfo primitiveClassInfo : this.primitiveClassInfos.values()) {
            primitiveClassInfo.log(logger);
        }
        Tr.debug((TraceComponent)logger, (String)"END Primitive Classes", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        int useCacheLimit;
        tc = Tr.register(ClassInfoCache.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassInfoCache.class.getName();
        String classInfoCacheSizeText = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -4844079995092644540L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(ClassInfoCache.CLASSINFO_CACHE_LIMIT_PROPERTY_NAME);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.anno.info.internal.ClassInfoCache$1", 1.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Cache Property [ {0} ] and value [ {1} ]", CLASSINFO_CACHE_LIMIT_PROPERTY_NAME, classInfoCacheSizeText), (Object[])new Object[0]);
        }
        String scanLimitCase = "Default; No property";
        if (classInfoCacheSizeText == null) {
            useCacheLimit = 2000;
            scanLimitCase = "default; no property value";
        } else {
            try {
                useCacheLimit = Integer.valueOf(classInfoCacheSizeText);
                if (useCacheLimit < 100) {
                    useCacheLimit = 100;
                    scanLimitCase = "out of range; reassigned to minimum";
                } else if (useCacheLimit > 10000) {
                    useCacheLimit = 10000;
                    scanLimitCase = "out of range; reassigned to maximum";
                } else {
                    scanLimitCase = "in range; assigned from property";
                }
            }
            catch (NumberFormatException numberFormatException) {
                void nfe;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.anno.info.internal.ClassInfoCache", (String)"782", null, (Object[])new Object[0]);
                useCacheLimit = 2000;
                scanLimitCase = "defaulted; non-valid integer value ( " + nfe.getMessage() + " )";
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Setting class info cache size [ {0} ]: [ {1} ]", useCacheLimit, scanLimitCase), (Object[])new Object[0]);
        }
        classInfoCacheLimit = useCacheLimit;
    }
}

